/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ElementKind;
import javax.validation.metadata.ParameterDescriptor;
import javax.validation.metadata.ReturnValueDescriptor;
import org.hibernate.validator.internal.metadata.aggregated.AbstractConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.MetaDataBuilder;
import org.hibernate.validator.internal.metadata.aggregated.ParameterMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ReturnValueMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ValidatableParametersMetaData;
import org.hibernate.validator.internal.metadata.aggregated.rule.MethodConfigurationRule;
import org.hibernate.validator.internal.metadata.aggregated.rule.OverridingMethodMustNotAlterParameterConstraints;
import org.hibernate.validator.internal.metadata.aggregated.rule.ParallelMethodsMustNotDefineGroupConversionForCascadedReturnValue;
import org.hibernate.validator.internal.metadata.aggregated.rule.ParallelMethodsMustNotDefineParameterConstraints;
import org.hibernate.validator.internal.metadata.aggregated.rule.ReturnValueMayOnlyBeMarkedOnceAsCascadedPerHierarchyLine;
import org.hibernate.validator.internal.metadata.aggregated.rule.VoidMethodsMustNotBeReturnValueConstrained;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ExecutableDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ExecutableConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ExecutableMetaData
extends AbstractConstraintMetaData {
    private static final Log log = LoggerFactory.make();
    private final Class<?>[] parameterTypes;
    private final List<ParameterMetaData> parameterMetaDataList;
    private final Set<MetaConstraint<?>> crossParameterConstraints;
    private final boolean isGetter;
    private final String identifier;
    private final ReturnValueMetaData returnValueMetaData;

    private ExecutableMetaData(String name, Class<?> returnType, Class<?>[] parameterTypes, ElementKind kind, Set<MetaConstraint<?>> returnValueConstraints, List<ParameterMetaData> parameterMetaData, Set<MetaConstraint<?>> crossParameterConstraints, Map<Class<?>, Class<?>> returnValueGroupConversions, boolean isCascading, boolean isConstrained, boolean isGetter) {
        super(name, returnType, returnValueConstraints, kind, isCascading, isConstrained);
        this.parameterTypes = parameterTypes;
        this.parameterMetaDataList = Collections.unmodifiableList(parameterMetaData);
        this.crossParameterConstraints = Collections.unmodifiableSet(crossParameterConstraints);
        this.identifier = name + Arrays.toString(parameterTypes);
        this.returnValueMetaData = new ReturnValueMetaData(returnType, returnValueConstraints, isCascading, returnValueGroupConversions);
        this.isGetter = isGetter;
    }

    public ParameterMetaData getParameterMetaData(int parameterIndex) {
        if (parameterIndex < 0 || parameterIndex > this.parameterMetaDataList.size() - 1) {
            throw log.getInvalidMethodParameterIndexException(this.getName(), parameterIndex);
        }
        return this.parameterMetaDataList.get(parameterIndex);
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Set<MetaConstraint<?>> getCrossParameterConstraints() {
        return this.crossParameterConstraints;
    }

    public ValidatableParametersMetaData getValidatableParametersMetaData() {
        HashSet cascadedParameters = CollectionHelper.newHashSet();
        for (ParameterMetaData parameterMetaData : this.parameterMetaDataList) {
            if (!parameterMetaData.isCascading()) continue;
            cascadedParameters.add(parameterMetaData);
        }
        return new ValidatableParametersMetaData(cascadedParameters);
    }

    public ReturnValueMetaData getReturnValueMetaData() {
        return this.returnValueMetaData;
    }

    @Override
    public ExecutableDescriptorImpl asDescriptor(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        return new ExecutableDescriptorImpl(this.getType(), this.getName(), this.asDescriptors(this.getCrossParameterConstraints()), (ReturnValueDescriptor)this.returnValueMetaData.asDescriptor(defaultGroupSequenceRedefined, (List)defaultGroupSequence), this.parametersAsDescriptors(defaultGroupSequenceRedefined, defaultGroupSequence), defaultGroupSequenceRedefined, this.isGetter, defaultGroupSequence);
    }

    private List<ParameterDescriptor> parametersAsDescriptors(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        ArrayList<ParameterDescriptor> parameterDescriptorList = CollectionHelper.newArrayList();
        for (ParameterMetaData parameterMetaData : this.parameterMetaDataList) {
            parameterDescriptorList.add((ParameterDescriptor)parameterMetaData.asDescriptor(defaultGroupSequenceRedefined, (List)defaultGroupSequence));
        }
        return parameterDescriptorList;
    }

    @Override
    public String toString() {
        StringBuilder parameterBuilder = new StringBuilder();
        for (Class<?> oneParameterType : this.getParameterTypes()) {
            parameterBuilder.append(oneParameterType.getSimpleName());
            parameterBuilder.append(", ");
        }
        String parameters = parameterBuilder.length() > 0 ? parameterBuilder.substring(0, parameterBuilder.length() - 2) : parameterBuilder.toString();
        return "ExecutableMetaData [executable=" + this.getType() + " " + this.getName() + "(" + parameters + "), isCascading=" + this.isCascading() + ", isConstrained=" + this.isConstrained() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecutableMetaData other = (ExecutableMetaData)obj;
        return Arrays.equals(this.parameterTypes, other.parameterTypes);
    }

    public static class Builder
    extends MetaDataBuilder {
        private static final Set<MethodConfigurationRule> rules = Collections.unmodifiableSet(CollectionHelper.asSet(new OverridingMethodMustNotAlterParameterConstraints(), new ParallelMethodsMustNotDefineParameterConstraints(), new VoidMethodsMustNotBeReturnValueConstrained(), new ReturnValueMayOnlyBeMarkedOnceAsCascadedPerHierarchyLine(), new ParallelMethodsMustNotDefineGroupConversionForCascadedReturnValue()));
        private final ConstrainedElement.ConstrainedElementKind kind;
        private final Set<ConstrainedExecutable> constrainedExecutables = CollectionHelper.newHashSet();
        private final ExecutableConstraintLocation location;
        private final Set<MetaConstraint<?>> crossParameterConstraints = CollectionHelper.newHashSet();
        private boolean isConstrained = false;
        private final Map<Class<?>, ConstrainedExecutable> executablesByDeclaringType = CollectionHelper.newHashMap();

        public Builder(Class<?> beanClass, ConstrainedExecutable constrainedExecutable, ConstraintHelper constraintHelper) {
            super(beanClass, constraintHelper);
            this.kind = constrainedExecutable.getKind();
            this.location = constrainedExecutable.getLocation();
            this.add(constrainedExecutable);
        }

        @Override
        public boolean accepts(ConstrainedElement constrainedElement) {
            if (this.kind != constrainedElement.getKind()) {
                return false;
            }
            ExecutableElement executableElement = ((ConstrainedExecutable)constrainedElement).getLocation().getExecutableElement();
            return this.location.getExecutableElement().equals(executableElement) || this.location.getExecutableElement().overrides(executableElement) || executableElement.overrides(this.location.getExecutableElement());
        }

        @Override
        public void add(ConstrainedElement constrainedElement) {
            super.add(constrainedElement);
            ConstrainedExecutable constrainedExecutable = (ConstrainedExecutable)constrainedElement;
            this.constrainedExecutables.add(constrainedExecutable);
            this.isConstrained = this.isConstrained || constrainedExecutable.isConstrained();
            this.crossParameterConstraints.addAll(constrainedExecutable.getCrossParameterConstraints());
            this.addToExecutablesByDeclaringType(constrainedExecutable);
        }

        private void addToExecutablesByDeclaringType(ConstrainedExecutable executable) {
            Class<?> beanClass = executable.getLocation().getBeanClass();
            ConstrainedExecutable mergedExecutable = this.executablesByDeclaringType.get(beanClass);
            mergedExecutable = mergedExecutable != null ? mergedExecutable.merge(executable) : executable;
            this.executablesByDeclaringType.put(beanClass, mergedExecutable.merge(executable));
        }

        @Override
        public ExecutableMetaData build() {
            this.assertCorrectnessOfConfiguration();
            ExecutableElement executableElement = this.location.getExecutableElement();
            return new ExecutableMetaData(executableElement.getSimpleName(), executableElement.getReturnType(), executableElement.getParameterTypes(), this.kind == ConstrainedElement.ConstrainedElementKind.CONSTRUCTOR ? ElementKind.CONSTRUCTOR : ElementKind.METHOD, this.adaptOriginsAndImplicitGroups(this.getConstraints()), this.findParameterMetaData(), this.adaptOriginsAndImplicitGroups(this.crossParameterConstraints), this.getGroupConversions(), this.isCascading(), this.isConstrained, executableElement.isGetterMethod());
        }

        private List<ParameterMetaData> findParameterMetaData() {
            ArrayList<ParameterMetaData.Builder> parameterBuilders = null;
            for (ConstrainedExecutable oneExecutable : this.constrainedExecutables) {
                if (parameterBuilders == null) {
                    parameterBuilders = CollectionHelper.newArrayList();
                    for (ConstrainedParameter oneParameter : oneExecutable.getAllParameterMetaData()) {
                        parameterBuilders.add(new ParameterMetaData.Builder(this.location.getBeanClass(), oneParameter, this.constraintHelper));
                    }
                    continue;
                }
                int i = 0;
                for (ConstrainedParameter oneParameter : oneExecutable.getAllParameterMetaData()) {
                    ((ParameterMetaData.Builder)parameterBuilders.get(i)).add(oneParameter);
                    ++i;
                }
            }
            ArrayList<ParameterMetaData> parameterMetaDatas = CollectionHelper.newArrayList();
            for (ParameterMetaData.Builder oneBuilder : parameterBuilders) {
                parameterMetaDatas.add(oneBuilder.build());
            }
            return parameterMetaDatas;
        }

        private void assertCorrectnessOfConfiguration() {
            for (Map.Entry<Class<?>, ConstrainedExecutable> entry : this.executablesByDeclaringType.entrySet()) {
                for (Map.Entry<Class<?>, ConstrainedExecutable> otherEntry : this.executablesByDeclaringType.entrySet()) {
                    for (MethodConfigurationRule rule : rules) {
                        rule.apply(entry.getValue(), otherEntry.getValue());
                    }
                }
            }
        }
    }
}

