/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.Verifier;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.config.processor.ApplicationConfigProcessor;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.servlet.ServletContext;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValidatorConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String VALIDATOR = "validator";
    private static final String VALIDATOR_ID = "validator-id";
    private static final String VALIDATOR_CLASS = "validator-class";

    public void process(ServletContext sc, DocumentInfo[] documentInfos) throws Exception {
        this.processAnnotations(FacesValidator.class);
        for (int i = 0; i < documentInfos.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing validator elements for document: ''{0}''", documentInfos[i].getSourceURI()));
            }
            Document document = documentInfos[i].getDocument();
            String namespace = document.getDocumentElement().getNamespaceURI();
            NodeList validators = document.getDocumentElement().getElementsByTagNameNS(namespace, VALIDATOR);
            if (validators == null || validators.getLength() <= 0) continue;
            this.addValidators(validators, namespace);
        }
        this.processDefaultValidatorIds();
        this.invokeNext(sc, documentInfos);
    }

    private void processDefaultValidatorIds() {
        Application app = this.getApplication();
        Map<String, String> defaultValidatorInfo = app.getDefaultValidatorInfo();
        for (Map.Entry<String, String> info : defaultValidatorInfo.entrySet()) {
            String defaultValidatorId = info.getKey();
            boolean found = false;
            Iterator<String> registered = app.getValidatorIds();
            while (registered.hasNext()) {
                if (!defaultValidatorId.equals(registered.next())) continue;
                found = true;
                break;
            }
            if (found) continue;
            String msg = MessageFormat.format("Default validator ''{0}'' does not reference a registered validator.", defaultValidatorId);
            throw new ConfigurationException(msg);
        }
    }

    private void addValidators(NodeList validators, String namespace) throws XPathExpressionException {
        Application app = this.getApplication();
        Verifier verifier = Verifier.getCurrentInstance();
        int size = validators.getLength();
        for (int i = 0; i < size; ++i) {
            Node validator = validators.item(i);
            NodeList children = ((Element)validator).getElementsByTagNameNS(namespace, "*");
            String validatorId = null;
            String validatorClass = null;
            int csize = children.getLength();
            for (int c = 0; c < csize; ++c) {
                Node n = children.item(c);
                if (n.getNodeType() != 1) continue;
                if (VALIDATOR_ID.equals(n.getLocalName())) {
                    validatorId = this.getNodeText(n);
                    continue;
                }
                if (!VALIDATOR_CLASS.equals(n.getLocalName())) continue;
                validatorClass = this.getNodeText(n);
            }
            if (validatorId == null || validatorClass == null) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.addValidator({0},{1})", validatorId, validatorClass));
            }
            boolean doAdd = true;
            if (validatorId.equals("javax.faces.Bean")) {
                doAdd = ApplicationConfigProcessor.isBeanValidatorAvailable();
            }
            if (!doAdd) continue;
            if (verifier != null) {
                verifier.validateObject(Verifier.ObjectType.VALIDATOR, validatorClass, Validator.class);
            }
            app.addValidator(validatorId, validatorClass);
        }
    }
}

