/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.WebappLifecycleListener;
import com.sun.faces.config.ConfigManager;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.InitFacesContext;
import com.sun.faces.config.Verifier;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.el.ChainTypeCompositeELResolver;
import com.sun.faces.el.ELContextImpl;
import com.sun.faces.el.ELContextListenerImpl;
import com.sun.faces.el.ELUtils;
import com.sun.faces.el.FacesCompositeELResolver;
import com.sun.faces.mgbean.BeanBuilder;
import com.sun.faces.mgbean.BeanManager;
import com.sun.faces.scripting.groovy.GroovyHelper;
import com.sun.faces.scripting.groovy.GroovyHelperFactory;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.MojarraThreadFactory;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.Timer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;
import javax.faces.event.PreDestroyApplicationEvent;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigureListener
implements ServletRequestListener,
HttpSessionListener,
ServletRequestAttributeListener,
HttpSessionAttributeListener,
ServletContextAttributeListener,
ServletContextListener {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private ScheduledThreadPoolExecutor webResourcePool;
    protected WebappLifecycleListener webAppListener;
    protected WebConfiguration webConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        ConfigManager configManager;
        ServletContext context = sce.getServletContext();
        Timer timer = Timer.getInstance();
        if (timer != null) {
            timer.startTiming();
        }
        if (null == (configManager = ConfigManager.getInstance(context))) {
            configManager = ConfigManager.createInstance(context);
        }
        if (configManager.hasBeenInitialized(context)) {
            return;
        }
        InitFacesContext initContext = new InitFacesContext(context);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, MessageFormat.format("ConfigureListener.contextInitialized({0})", ConfigureListener.getServletContextIdentifier(context)));
        }
        this.webConfig = WebConfiguration.getInstance(context);
        Object mappingsAdded = context.getAttribute("com.sun.faces.facesInitializerMappingsAdded");
        if (mappingsAdded != null) {
            context.removeAttribute("com.sun.faces.facesInitializerMappingsAdded");
        }
        WebXmlProcessor webXmlProcessor = new WebXmlProcessor(context);
        if (mappingsAdded == null) {
            if (!webXmlProcessor.isFacesServletPresent()) {
                if (!this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.ForceLoadFacesConfigFiles)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "No FacesServlet found in deployment descriptor - bypassing configuration");
                    }
                    WebConfiguration.clear(context);
                    configManager.destroy(context);
                    ConfigManager.removeInstance(context);
                    InitFacesContext.cleanupInitMaps(context);
                    return;
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "FacesServlet found in deployment descriptor - processing configuration.");
            }
        }
        if (webXmlProcessor.isDistributablePresent()) {
            this.webConfig.setOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableDistributable, true);
            context.setAttribute(WebConfiguration.BooleanWebContextInitParameter.EnableDistributable.getQualifiedName(), (Object)Boolean.TRUE);
        }
        this.webAppListener = new WebappLifecycleListener(context);
        this.webAppListener.contextInitialized(sce);
        ReflectionUtils.initCache(Thread.currentThread().getContextClassLoader());
        Throwable caughtThrowable = null;
        try {
            Verifier v;
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "jsf.config.listener.version", ConfigureListener.getServletContextIdentifier(context));
            }
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.VerifyFacesConfigObjects)) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("jsf.config.verifyobjects.development_only");
                }
                this.webConfig.overrideContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.EnableLazyBeanValidation, false);
                Verifier.setCurrentInstance(new Verifier());
            }
            this.initScripting();
            configManager.initialize(context);
            if (this.shouldInitConfigMonitoring()) {
                this.initConfigMonitoring(context);
            }
            if ((v = Verifier.getCurrentInstance()) != null && !v.isApplicationValid() && LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("jsf.config.verifyobjects.failures_detected");
                StringBuilder sb = new StringBuilder(128);
                for (String m : v.getMessages()) {
                    sb.append(m).append('\n');
                }
                LOGGER.severe(sb.toString());
            }
            this.registerELResolverAndListenerWithJsp(context, false);
            ApplicationAssociate associate = ApplicationAssociate.getInstance(context);
            ELContextImpl elctx = new ELContextImpl(initContext.getApplication().getELResolver());
            elctx.putContext(FacesContext.class, initContext);
            ExpressionFactory exFactory = ELUtils.getDefaultExpressionFactory(associate, initContext);
            if (null != exFactory) {
                elctx.putContext(ExpressionFactory.class, exFactory);
            }
            initContext.setELContext(elctx);
            if (associate != null) {
                associate.setContextName(ConfigureListener.getServletContextIdentifier(context));
                BeanManager manager = associate.getBeanManager();
                List<String> eagerBeans = manager.getEagerBeanNames();
                if (!eagerBeans.isEmpty()) {
                    for (String name : eagerBeans) {
                        manager.create(name, initContext);
                    }
                }
                boolean isErrorPagePresent = webXmlProcessor.isErrorPagePresent();
                associate.setErrorPagePresent(isErrorPagePresent);
                context.setAttribute("com.sun.faces.errorPagePresent", (Object)isErrorPagePresent);
            }
            this.webConfig.doPostBringupActions();
            configManager.publishPostConfigEvent();
        }
        catch (Throwable t) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Critical error during deployment: ", t);
            }
            caughtThrowable = t;
        }
        finally {
            sce.getServletContext().removeAttribute("com.sun.faces.AnnotatedClasses");
            Verifier.setCurrentInstance(null);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "jsf.config.listener.version.complete");
            }
            if (timer != null) {
                timer.stopTiming();
                timer.logResult("Initialization of context " + ConfigureListener.getServletContextIdentifier(context));
            }
            if (null != caughtThrowable) {
                throw new RuntimeException(caughtThrowable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        ConfigManager configManager = ConfigManager.getInstance(context);
        if (null == configManager && WebConfiguration.getInstanceWithoutCreating(context) != null && LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, "Unexpected state during contextDestroyed: no ConfigManager instance in current ServletContext but one is expected to exist.");
        }
        if (null == configManager || !configManager.hasBeenInitialized(context)) {
            return;
        }
        InitFacesContext initContext = null;
        try {
            GroovyHelper helper;
            initContext = this.getInitFacesContext(context);
            if (null == initContext) {
                initContext = new InitFacesContext(context);
            } else {
                InitFacesContext.getThreadInitContextMap().put(Thread.currentThread(), initContext);
            }
            if (this.webAppListener != null) {
                this.webAppListener.contextDestroyed(sce);
                this.webAppListener = null;
            }
            if (this.webResourcePool != null) {
                this.webResourcePool.shutdownNow();
            }
            if ((helper = GroovyHelper.getCurrentInstance(context)) != null) {
                helper.setClassLoader();
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "ConfigureListener.contextDestroyed({0})", context.getServletContextName());
            }
            ELContextImpl elctx = new ELContextImpl(initContext.getApplication().getELResolver());
            elctx.putContext(FacesContext.class, initContext);
            ExpressionFactory exFactory = ELUtils.getDefaultExpressionFactory(initContext);
            if (null != exFactory) {
                elctx.putContext(ExpressionFactory.class, exFactory);
            }
            initContext.setELContext(elctx);
            Application app = initContext.getApplication();
            app.publishEvent(initContext, PreDestroyApplicationEvent.class, Application.class, app);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unexpected exception when attempting to tear down the Mojarra runtime", e);
            }
        }
        finally {
            ApplicationAssociate.clearInstance(context);
            ApplicationAssociate.setCurrentInstance(null);
            configManager.destroy(context);
            ConfigManager.removeInstance(context);
            FactoryFinder.releaseFactories();
            ReflectionUtils.clearCache(Thread.currentThread().getContextClassLoader());
            WebConfiguration.clear(context);
            InitFacesContext.cleanupInitMaps(context);
        }
    }

    public void requestDestroyed(ServletRequestEvent event) {
        if (this.webAppListener != null) {
            this.webAppListener.requestDestroyed(event);
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
        if (this.webAppListener != null) {
            this.webAppListener.requestInitialized(event);
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        if (this.webAppListener != null) {
            this.webAppListener.sessionCreated(event);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (this.webAppListener != null) {
            this.webAppListener.sessionDestroyed(event);
        }
    }

    public void attributeAdded(ServletRequestAttributeEvent event) {
    }

    public void attributeRemoved(ServletRequestAttributeEvent event) {
        if (this.webAppListener != null) {
            this.webAppListener.attributeRemoved(event);
        }
    }

    public void attributeReplaced(ServletRequestAttributeEvent event) {
        if (this.webAppListener != null) {
            this.webAppListener.attributeReplaced(event);
        }
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        if (this.webAppListener != null) {
            this.webAppListener.attributeRemoved(event);
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        if (this.webAppListener != null) {
            this.webAppListener.attributeReplaced(event);
        }
    }

    public void attributeAdded(ServletContextAttributeEvent event) {
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        if (this.webAppListener != null) {
            this.webAppListener.attributeRemoved(event);
        }
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
        if (this.webAppListener != null) {
            this.webAppListener.attributeReplaced(event);
        }
    }

    private boolean shouldInitConfigMonitoring() {
        boolean development = this.isDevModeEnabled();
        boolean threadingOptionSpecified = this.webConfig.isSet(WebConfiguration.BooleanWebContextInitParameter.EnableThreading);
        if (development && !threadingOptionSpecified) {
            return true;
        }
        boolean threadingOption = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableThreading);
        return development && threadingOptionSpecified && threadingOption;
    }

    private void initConfigMonitoring(ServletContext context) {
        Collection webURIs = (Collection)context.getAttribute("com.sun.faces.webresources");
        if (this.isDevModeEnabled() && webURIs != null && !webURIs.isEmpty()) {
            this.webResourcePool = new ScheduledThreadPoolExecutor(1, new MojarraThreadFactory("WebResourceMonitor"));
            this.webResourcePool.scheduleAtFixedRate(new WebConfigResourceMonitor(context, webURIs), 2000L, 2000L, TimeUnit.MILLISECONDS);
        }
        context.removeAttribute("com.sun.faces.webresources");
    }

    private void initScripting() {
        GroovyHelper helper;
        if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableGroovyScripting) && (helper = GroovyHelperFactory.createHelper()) != null) {
            helper.setClassLoader();
        }
    }

    private boolean isDevModeEnabled() {
        return "Development".equals(this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.JavaxFacesProjectStage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reload(ServletContext sc) {
        block31: {
            block29: {
                InitFacesContext initContext2222;
                GroovyHelper helper;
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Reloading JSF configuration for context {0}", ConfigureListener.getServletContextIdentifier(sc));
                }
                if ((helper = GroovyHelper.getCurrentInstance()) != null) {
                    helper.setClassLoader();
                }
                try {
                    try {
                        ApplicationAssociate associate;
                        List<HttpSession> sessions;
                        if (null != this.webAppListener && (sessions = this.webAppListener.getActiveSessions()) != null) {
                            for (HttpSession session : sessions) {
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    LOGGER.log(Level.INFO, "Invalidating Session {0}", session.getId());
                                }
                                session.invalidate();
                            }
                        }
                        if ((associate = ApplicationAssociate.getInstance(sc)) != null) {
                            BeanManager manager = associate.getBeanManager();
                            for (Map.Entry<String, BeanBuilder> entry : manager.getRegisteredBeans().entrySet()) {
                                String name = entry.getKey();
                                BeanBuilder bean = entry.getValue();
                                if (!ELUtils.Scope.APPLICATION.toString().equals(bean.getScope())) continue;
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    LOGGER.log(Level.INFO, "Removing application scoped managed bean: {0}", name);
                                }
                                sc.removeAttribute(name);
                            }
                        }
                        FactoryFinder.releaseFactories();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Object var10_12 = null;
                        InitFacesContext initContext2222 = new InitFacesContext(sc);
                        ApplicationAssociate.clearInstance(((FacesContext)initContext2222).getExternalContext());
                        ApplicationAssociate.setCurrentInstance(null);
                        ConfigManager configManager = ConfigManager.getInstance(sc);
                        if (null != configManager) {
                            configManager.destroy(sc);
                            ConfigManager.removeInstance(sc);
                        } else if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, "Unexpected state during reload: no ConfigManager instance in current ServletContext but one is expected to exist.");
                        }
                        ((FacesContext)initContext2222).release();
                        ReflectionUtils.clearCache(Thread.currentThread().getContextClassLoader());
                        WebConfiguration.clear(sc);
                        break block29;
                    }
                    Object var10_11 = null;
                    initContext2222 = new InitFacesContext(sc);
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    InitFacesContext initContext2222 = new InitFacesContext(sc);
                    ApplicationAssociate.clearInstance(((FacesContext)initContext2222).getExternalContext());
                    ApplicationAssociate.setCurrentInstance(null);
                    ConfigManager configManager = ConfigManager.getInstance(sc);
                    if (null != configManager) {
                        configManager.destroy(sc);
                        ConfigManager.removeInstance(sc);
                    } else if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "Unexpected state during reload: no ConfigManager instance in current ServletContext but one is expected to exist.");
                    }
                    ((FacesContext)initContext2222).release();
                    ReflectionUtils.clearCache(Thread.currentThread().getContextClassLoader());
                    WebConfiguration.clear(sc);
                    throw throwable;
                }
                ApplicationAssociate.clearInstance(((FacesContext)initContext2222).getExternalContext());
                ApplicationAssociate.setCurrentInstance(null);
                ConfigManager configManager = ConfigManager.getInstance(sc);
                if (null != configManager) {
                    configManager.destroy(sc);
                    ConfigManager.removeInstance(sc);
                } else if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Unexpected state during reload: no ConfigManager instance in current ServletContext but one is expected to exist.");
                }
                ((FacesContext)initContext2222).release();
                ReflectionUtils.clearCache(Thread.currentThread().getContextClassLoader());
                WebConfiguration.clear(sc);
            }
            this.webAppListener = new WebappLifecycleListener(sc);
            InitFacesContext initContext = new InitFacesContext(sc);
            ReflectionUtils.initCache(Thread.currentThread().getContextClassLoader());
            try {
                block30: {
                    try {
                        Boolean errorPagePresent;
                        ConfigManager configManager = ConfigManager.createInstance(sc);
                        if (null != configManager) {
                            configManager.initialize(sc);
                        } else if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, "Unexpected state during reload: no ConfigManager instance in current ServletContext but one is expected to exist.");
                        }
                        this.registerELResolverAndListenerWithJsp(sc, true);
                        ApplicationAssociate associate = ApplicationAssociate.getInstance(sc);
                        if (associate == null || null == (errorPagePresent = (Boolean)sc.getAttribute("com.sun.faces.errorPagePresent"))) break block30;
                        associate.setErrorPagePresent(errorPagePresent);
                        associate.setContextName(ConfigureListener.getServletContextIdentifier(sc));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Object var14_22 = null;
                        ((FacesContext)initContext).release();
                        break block31;
                    }
                }
                Object var14_21 = null;
                ((FacesContext)initContext).release();
            }
            catch (Throwable throwable) {
                Object var14_23 = null;
                ((FacesContext)initContext).release();
                throw throwable;
            }
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Reload complete.", ConfigureListener.getServletContextIdentifier(sc));
        }
    }

    private static String getServletContextIdentifier(ServletContext context) {
        if (context.getMajorVersion() == 2 && context.getMinorVersion() < 5) {
            return context.getServletContextName();
        }
        return context.getContextPath();
    }

    private static boolean isJspTwoOne(ServletContext context) {
        block7: {
            try {
                Class.forName("org.apache.jasper.compiler.JspRuntimeContext");
            }
            catch (ClassNotFoundException ignored) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block7;
                LOGGER.log(Level.FINEST, "Dected JSP 2.1", ignored);
            }
        }
        if (JspFactory.getDefaultFactory() == null) {
            return false;
        }
        try {
            JspFactory.class.getMethod("getJspApplicationContext", ServletContext.class);
        }
        catch (Exception e) {
            return false;
        }
        try {
            JspFactory.getDefaultFactory().getJspApplicationContext(context);
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public void registerELResolverAndListenerWithJsp(ServletContext context, boolean reloaded) {
        if (this.webConfig.isSet(WebConfiguration.WebContextInitParameter.ExpressionFactory) || !ConfigureListener.isJspTwoOne(context)) {
            if (!this.installExpressionFactory(context, this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ExpressionFactory))) {
                throw new ConfigurationException(MessageUtils.getExceptionMessageString("com.sun.faces.INCORRECT_JSP_VERSION", WebConfiguration.WebContextInitParameter.ExpressionFactory.getDefaultValue(), WebConfiguration.WebContextInitParameter.ExpressionFactory.getQualifiedName()));
            }
        } else {
            JspApplicationContext jspAppContext;
            block8: {
                if (JspFactory.getDefaultFactory().getJspApplicationContext(context) == null) {
                    return;
                }
                ChainTypeCompositeELResolver compositeELResolverForJsp = new ChainTypeCompositeELResolver(FacesCompositeELResolver.ELResolverChainType.JSP);
                ApplicationAssociate associate = ApplicationAssociate.getInstance(context);
                if (associate != null) {
                    associate.setFacesELResolverForJsp(compositeELResolverForJsp);
                }
                jspAppContext = JspFactory.getDefaultFactory().getJspApplicationContext(context);
                if (associate != null) {
                    associate.setExpressionFactory(jspAppContext.getExpressionFactory());
                }
                try {
                    jspAppContext.addELResolver((ELResolver)compositeELResolverForJsp);
                }
                catch (IllegalStateException e) {
                    ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory");
                    Application app = factory.getApplication();
                    if (app.getProjectStage() == ProjectStage.UnitTest || reloaded) break block8;
                    throw e;
                }
            }
            ELContextListenerImpl elContextListener = new ELContextListenerImpl();
            jspAppContext.addELContextListener((ELContextListener)elContextListener);
        }
    }

    private boolean installExpressionFactory(ServletContext sc, String elFactoryType) {
        if (elFactoryType == null) {
            return false;
        }
        try {
            ExpressionFactory factory = (ExpressionFactory)Util.loadClass(elFactoryType, this).newInstance();
            ApplicationAssociate associate = ApplicationAssociate.getInstance(sc);
            if (associate != null) {
                associate.setExpressionFactory(factory);
            }
            return true;
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe(MessageFormat.format("Unable to instantiate ExpressionFactory ''{0}''", elFactoryType));
            }
            return false;
        }
    }

    private InitFacesContext getInitFacesContext(ServletContext context) {
        Map initContextServletContext = InitFacesContext.getInitContextServletContextMap();
        Set entries = initContextServletContext.entrySet();
        InitFacesContext initContext = null;
        for (Map.Entry entry1 : entries) {
            Object initContextKey = entry1.getKey();
            Object value1 = entry1.getValue();
            if (context != value1) continue;
            initContext = (InitFacesContext)initContextKey;
            break;
        }
        return initContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WebConfigResourceMonitor
    implements Runnable {
        private List<Monitor> monitors;
        private ServletContext sc;

        public WebConfigResourceMonitor(ServletContext sc, Collection<URI> uris) {
            assert (uris != null);
            this.sc = sc;
            for (URI uri : uris) {
                if (this.monitors == null) {
                    this.monitors = new ArrayList<Monitor>(uris.size());
                }
                try {
                    Monitor m = new Monitor(uri);
                    this.monitors.add(m);
                }
                catch (IOException ioe) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.severe("Unable to setup resource monitor for " + uri.toString() + ".  Resource will not be monitored for changes.");
                    }
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, ioe.toString(), ioe);
                }
            }
        }

        @Override
        public void run() {
            assert (this.monitors != null);
            boolean reloaded = false;
            Iterator<Monitor> i = this.monitors.iterator();
            while (i.hasNext()) {
                Monitor m = i.next();
                try {
                    if (!m.hasBeenModified() || reloaded) continue;
                    reloaded = true;
                }
                catch (IOException ioe) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.severe("Unable to access url " + m.uri.toString() + ".  Monitoring for this resource will no longer occur.");
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, ioe.toString(), ioe);
                    }
                    i.remove();
                }
            }
            if (reloaded) {
                ConfigureListener.this.reload(this.sc);
            }
        }

        private class Monitor {
            private URI uri;
            private long timestamp = -1L;

            Monitor(URI uri) throws IOException {
                this.uri = uri;
                this.timestamp = this.getLastModified();
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Monitoring {0} for modifications", uri.toURL().toExternalForm());
                }
            }

            boolean hasBeenModified() throws IOException {
                long temp = this.getLastModified();
                if (this.timestamp < temp) {
                    this.timestamp = temp;
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, "{0} changed!", this.uri.toURL().toExternalForm());
                    }
                    return true;
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long getLastModified() throws IOException {
                InputStream in = null;
                try {
                    URLConnection conn = this.uri.toURL().openConnection();
                    conn.connect();
                    in = conn.getInputStream();
                    long l = conn.getLastModified();
                    return l;
                }
                finally {
                    block8: {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException ignored) {
                                if (!LOGGER.isLoggable(Level.FINEST)) break block8;
                                LOGGER.log(Level.FINEST, "Exception while closing stream", ignored);
                            }
                        }
                    }
                }
            }
        }
    }

    private static class WebXmlProcessor {
        private static final String WEB_XML_PATH = "/WEB-INF/web.xml";
        private static final String WEB_FRAGMENT_PATH = "META-INF/web-fragment.xml";
        private boolean facesServletPresent;
        private boolean errorPagePresent;
        private boolean distributablePresent;

        WebXmlProcessor(ServletContext context) {
            if (context != null) {
                this.scanForFacesServlet(context);
            }
        }

        boolean isFacesServletPresent() {
            return this.facesServletPresent;
        }

        boolean isErrorPagePresent() {
            return this.errorPagePresent;
        }

        public boolean isDistributablePresent() {
            return this.distributablePresent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanForFacesServlet(ServletContext context) {
            InputStream in = context.getResourceAsStream(WEB_XML_PATH);
            if (in == null && context.getMajorVersion() < 3) {
                throw new ConfigurationException("no web.xml present");
            }
            SAXParserFactory factory = this.getConfiguredFactory();
            if (in != null) {
                try {
                    SAXParser parser = factory.newSAXParser();
                    parser.parse(in, (DefaultHandler)new WebXmlHandler());
                }
                catch (Exception e) {
                    this.warnProcessingError(e, context);
                    this.facesServletPresent = true;
                    return;
                }
                finally {
                    block31: {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception ioe) {
                                if (!LOGGER.isLoggable(Level.FINEST)) break block31;
                                LOGGER.log(Level.FINEST, "Closing stream", ioe);
                            }
                        }
                    }
                }
            }
            if (!this.facesServletPresent && context.getMajorVersion() >= 3) {
                Enumeration<URL> urls;
                ClassLoader cl = Util.getCurrentLoader(this);
                try {
                    urls = cl.getResources(WEB_FRAGMENT_PATH);
                }
                catch (IOException ioe) {
                    throw new ConfigurationException(ioe);
                }
                if (urls != null) {
                    while (urls.hasMoreElements() && !this.facesServletPresent) {
                        InputStream fragmentStream = null;
                        try {
                            URL url = urls.nextElement();
                            URLConnection conn = url.openConnection();
                            conn.setUseCaches(false);
                            fragmentStream = conn.getInputStream();
                            SAXParser parser = factory.newSAXParser();
                            parser.parse(fragmentStream, (DefaultHandler)new WebXmlHandler());
                        }
                        catch (Exception e) {
                            this.warnProcessingError(e, context);
                            this.facesServletPresent = true;
                            return;
                        }
                        finally {
                            if (fragmentStream == null) continue;
                            try {
                                fragmentStream.close();
                            }
                            catch (IOException ioe) {
                                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                                LOGGER.log(Level.WARNING, "Exception whil scanning for FacesServlet", ioe);
                            }
                        }
                    }
                }
            }
        }

        private SAXParserFactory getConfiguredFactory() {
            SAXParserFactory factory = Util.createSAXParserFactory();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            return factory;
        }

        private void warnProcessingError(Exception e, ServletContext sc) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, MessageFormat.format("jsf.configuration.web.xml.parse.failed", ConfigureListener.getServletContextIdentifier(sc)), e);
            }
        }

        private class WebXmlHandler
        extends DefaultHandler {
            private static final String ERROR_PAGE = "error-page";
            private static final String SERVLET_CLASS = "servlet-class";
            private static final String FACES_SERVLET = "javax.faces.webapp.FacesServlet";
            private boolean servletClassFound;
            private StringBuffer content;

            private WebXmlHandler() {
            }

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                return new InputSource(new StringReader(""));
            }

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (!WebXmlProcessor.this.errorPagePresent && ERROR_PAGE.equals(localName)) {
                    WebXmlProcessor.this.errorPagePresent = true;
                    return;
                }
                if (!WebXmlProcessor.this.facesServletPresent) {
                    if (SERVLET_CLASS.equals(localName)) {
                        this.servletClassFound = true;
                        this.content = new StringBuffer();
                    } else {
                        this.servletClassFound = false;
                    }
                }
                if ("distributable".equals(localName)) {
                    WebXmlProcessor.this.distributablePresent = true;
                }
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.servletClassFound && !WebXmlProcessor.this.facesServletPresent) {
                    this.content.append(ch, start, length);
                }
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (this.servletClassFound && !WebXmlProcessor.this.facesServletPresent && FACES_SERVLET.equals(this.content.toString().trim())) {
                    WebXmlProcessor.this.facesServletPresent = true;
                }
            }
        }
    }
}

