/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

class ZipDirectoryEntryScanner {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private static final String prefix = "META-INF/resources";
    private static final int prefixLen = "META-INF/resources".length();
    Map<String, Boolean> resourceLibraries;

    ZipDirectoryEntryScanner() {
        ExternalContext extContext = FacesContext.getCurrentInstance().getExternalContext();
        Set<String> webInfLibJars = extContext.getResourcePaths("/WEB-INF/lib");
        this.resourceLibraries = new ConcurrentHashMap<String, Boolean>();
        ZipInputStream zis = null;
        ZipEntry ze = null;
        String entryName = null;
        if (null != webInfLibJars) {
            for (String cur : webInfLibJars) {
                zis = new ZipInputStream(extContext.getResourceAsStream(cur));
                try {
                    while (null != (ze = zis.getNextEntry())) {
                        int i;
                        entryName = ze.getName();
                        if (!entryName.startsWith(prefix) || prefixLen >= entryName.length() || (entryName = entryName.substring(prefixLen + 1)).endsWith("/") || -1 == (i = entryName.lastIndexOf("/")) || this.resourceLibraries.containsKey(entryName = entryName.substring(0, i))) continue;
                        this.resourceLibraries.put(entryName, Boolean.TRUE);
                    }
                }
                catch (IOException ioe) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, "Unable to inspect resource library " + cur, ioe);
                }
            }
        }
        Iterator<String> iter = this.resourceLibraries.keySet().iterator();
        while (iter.hasNext()) {
            String cur;
            cur = iter.next();
            if (!cur.contains("/")) continue;
            iter.remove();
        }
    }

    boolean libraryExists(String libraryName, String localePrefix) {
        boolean result = false;
        result = null != localePrefix ? this.resourceLibraries.containsKey(localePrefix + "/" + libraryName) : this.resourceLibraries.containsKey(libraryName);
        return result;
    }
}

