/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ApplicationStateInfo;
import com.sun.faces.util.ComponentStruct;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MostlySingletonSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRemoveFromViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateContext {
    private static final String KEY = StateContext.class.getName() + "_KEY";
    private static final String MARK_CREATED_REMOVED = StateContext.class.getName() + "_MARK_CREATED_REMOVED";
    private boolean partial;
    private boolean partialLocked;
    private boolean trackMods = true;
    private AddRemoveListener modListener;
    private ApplicationStateInfo stateInfo;
    private WeakReference<UIViewRoot> viewRootRef = new WeakReference<Object>(null);
    private static final Logger LOGGER = FacesLogger.CONTEXT.getLogger();

    private StateContext(ApplicationStateInfo stateInfo) {
        this.stateInfo = stateInfo;
    }

    public static void release(FacesContext facesContext) {
        StateContext stateContext = (StateContext)facesContext.getAttributes().get(KEY);
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot != null && stateContext.modListener != null) {
            viewRoot.unsubscribeFromViewEvent(PostAddToViewEvent.class, stateContext.modListener);
            viewRoot.unsubscribeFromViewEvent(PreRemoveFromViewEvent.class, stateContext.modListener);
        }
        facesContext.getAttributes().remove(KEY);
    }

    public static StateContext getStateContext(FacesContext ctx) {
        StateContext stateCtx = (StateContext)ctx.getAttributes().get(KEY);
        if (stateCtx == null) {
            ApplicationAssociate associate = ApplicationAssociate.getCurrentInstance();
            ApplicationStateInfo info = associate.getApplicationStateInfo();
            stateCtx = new StateContext(info);
            ctx.getAttributes().put(KEY, stateCtx);
        }
        return stateCtx;
    }

    public boolean isPartialStateSaving(FacesContext ctx, String viewId) {
        UIViewRoot refRoot;
        UIViewRoot root = ctx.getViewRoot();
        if (root != (refRoot = (UIViewRoot)this.viewRootRef.get())) {
            this.viewRootRef = new WeakReference<UIViewRoot>(root);
            if (refRoot != null) {
                this.modListener = null;
                this.partialLocked = false;
            }
        }
        if (!this.partialLocked) {
            if (viewId == null) {
                viewId = root != null ? root.getViewId() : (String)ctx.getAttributes().get("com.sun.faces.viewId");
            }
            this.partial = this.stateInfo.usePartialStateSaving(viewId);
            this.partialLocked = true;
        }
        return this.partial;
    }

    public boolean trackViewModifications() {
        return this.trackMods;
    }

    public void startTrackViewModifications(FacesContext ctx, UIViewRoot root) {
        if (this.modListener == null) {
            if (root != null) {
                this.modListener = this.createAddRemoveListener(ctx, root);
                root.subscribeToViewEvent(PostAddToViewEvent.class, this.modListener);
                root.subscribeToViewEvent(PreRemoveFromViewEvent.class, this.modListener);
            } else {
                LOGGER.warning("Unable to attach AddRemoveListener to UIViewRoot because it is null");
            }
        }
        this.setTrackViewModifications(true);
    }

    public void setTrackViewModifications(boolean trackMods) {
        this.trackMods = trackMods;
    }

    public boolean componentAddedDynamically(UIComponent c) {
        return c.getAttributes().containsKey("com.sun.faces.DynamicComponent");
    }

    public int getIndexOfDynamicallyAddedChildInParent(UIComponent c) {
        int result = -1;
        Map<String, Object> attrs = c.getAttributes();
        if (attrs.containsKey("com.sun.faces.DynamicComponent")) {
            result = (Integer)attrs.get("com.sun.faces.DynamicComponent");
        }
        return result;
    }

    public boolean hasOneOrMoreDynamicChild(UIComponent parent) {
        return parent.getAttributes().containsKey("com.sun.faces.DynamicChildCount");
    }

    private int incrementDynamicChildCount(UIComponent parent) {
        int result;
        Map<String, Object> attrs = parent.getAttributes();
        Integer cur = (Integer)attrs.get("com.sun.faces.DynamicChildCount");
        if (null != cur) {
            Integer n = cur;
            Integer n2 = cur = Integer.valueOf(cur + 1);
            result = n;
        } else {
            result = 1;
        }
        attrs.put("com.sun.faces.DynamicChildCount", result);
        return result;
    }

    private int decrementDynamicChildCount(UIComponent parent) {
        int result = 0;
        Map<String, Object> attrs = parent.getAttributes();
        Integer cur = (Integer)attrs.get("com.sun.faces.DynamicChildCount");
        if (null != cur) {
            int n;
            if (0 < cur) {
                Integer n2 = cur;
                Integer n3 = cur = Integer.valueOf(cur - 1);
                n = n2;
            } else {
                n = result = 0;
            }
        }
        if (0 == result && null != cur) {
            attrs.remove("com.sun.faces.DynamicChildCount");
        }
        return result;
    }

    public List<ComponentStruct> getDynamicActions() {
        return this.modListener != null ? this.modListener.getDynamicActions() : null;
    }

    public HashMap<String, UIComponent> getDynamicComponents() {
        return this.modListener != null ? this.modListener.getDynamicComponents() : null;
    }

    private AddRemoveListener createAddRemoveListener(FacesContext context, UIViewRoot root) {
        return this.isPartialStateSaving(context, root.getViewId()) ? new DynamicAddRemoveListener(context) : new StatelessAddRemoveListener(context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DynamicAddRemoveListener
    extends AddRemoveListener {
        private List<ComponentStruct> dynamicActions;
        private transient HashMap<String, UIComponent> dynamicComponents;

        public DynamicAddRemoveListener(FacesContext context) {
            super(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ComponentStruct> getDynamicActions() {
            DynamicAddRemoveListener dynamicAddRemoveListener = this;
            synchronized (dynamicAddRemoveListener) {
                if (this.dynamicActions == null) {
                    this.dynamicActions = new ArrayList<ComponentStruct>();
                }
            }
            return this.dynamicActions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HashMap<String, UIComponent> getDynamicComponents() {
            DynamicAddRemoveListener dynamicAddRemoveListener = this;
            synchronized (dynamicAddRemoveListener) {
                if (this.dynamicComponents == null) {
                    this.dynamicComponents = new HashMap();
                }
            }
            return this.dynamicComponents;
        }

        @Override
        protected void handleRemove(FacesContext context, UIComponent component) {
            if (component.isInView()) {
                StateContext.this.decrementDynamicChildCount(component.getParent());
                ComponentStruct struct = new ComponentStruct();
                struct.action = "REMOVE";
                struct.clientId = component.getClientId(context);
                struct.id = component.getId();
                this.handleAddRemoveWithAutoPrune(component, struct);
            }
        }

        @Override
        protected void handleAdd(FacesContext context, UIComponent component) {
            if (component.getParent() != null && component.getParent().isInView()) {
                String facetName;
                String id = component.getId();
                if (id != null) {
                    component.setId(id);
                }
                if ((facetName = this.findFacetNameForComponent(component)) != null) {
                    StateContext.this.incrementDynamicChildCount(component.getParent());
                    component.clearInitialState();
                    component.getAttributes().put("com.sun.faces.DynamicComponent", component.getParent().getChildren().indexOf(component));
                    ComponentStruct struct = new ComponentStruct();
                    struct.action = "ADD";
                    struct.facetName = facetName;
                    struct.parentClientId = component.getParent().getClientId(context);
                    struct.clientId = component.getClientId(context);
                    struct.id = component.getId();
                    this.handleAddRemoveWithAutoPrune(component, struct);
                } else {
                    StateContext.this.incrementDynamicChildCount(component.getParent());
                    component.clearInitialState();
                    component.getAttributes().put("com.sun.faces.DynamicComponent", component.getParent().getChildren().indexOf(component));
                    ComponentStruct struct = new ComponentStruct();
                    struct.action = "ADD";
                    struct.parentClientId = component.getParent().getClientId(context);
                    struct.clientId = component.getClientId(context);
                    struct.id = component.getId();
                    this.handleAddRemoveWithAutoPrune(component, struct);
                }
            }
        }

        private String findFacetNameForComponent(UIComponent component) {
            Set<Map.Entry<String, UIComponent>> entrySet = component.getParent().getFacets().entrySet();
            for (Map.Entry<String, UIComponent> candidate : entrySet) {
                if (component != candidate.getValue()) continue;
                return candidate.getKey();
            }
            return null;
        }

        private void handleAddRemoveWithAutoPrune(UIComponent component, ComponentStruct struct) {
            List<ComponentStruct> actionList = this.getDynamicActions();
            HashMap<String, UIComponent> componentMap = this.getDynamicComponents();
            int firstIndex = actionList.indexOf(struct);
            if (firstIndex == -1) {
                actionList.add(struct);
                componentMap.put(struct.clientId, component);
            } else {
                int lastIndex = actionList.lastIndexOf(struct);
                if (lastIndex == firstIndex) {
                    ComponentStruct previousStruct = actionList.get(firstIndex);
                    if ("ADD".equals(previousStruct.action)) {
                        if ("ADD".equals(struct.action)) {
                            throw new FacesException("Cannot add the same component twice: " + struct.clientId);
                        }
                        if ("REMOVE".equals(struct.action)) {
                            actionList.remove(firstIndex);
                            componentMap.remove(struct.clientId);
                        }
                    }
                    if ("REMOVE".equals(previousStruct.action)) {
                        if ("ADD".equals(struct.action)) {
                            actionList.add(struct);
                            componentMap.put(struct.clientId, component);
                        }
                        if ("REMOVE".equals(struct.action)) {
                            throw new FacesException("Cannot remove the same component twice: " + struct.clientId);
                        }
                    }
                } else {
                    if ("ADD".equals(struct.action)) {
                        throw new FacesException("Cannot add the same component twice: " + struct.clientId);
                    }
                    if ("REMOVE".equals(struct.action)) {
                        actionList.remove(lastIndex);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StatelessAddRemoveListener
    extends NoopAddRemoveListener {
        private static final String DYNAMIC_COMPONENT_ADD_COLLECTION = "com.sun.faces.DynamicComponentSubtreeRoots";

        public StatelessAddRemoveListener(FacesContext context) {
            super(context);
        }

        private boolean thisEventCorrespondsToSubtreeRootRemove(FacesContext context, UIComponent c) {
            boolean result = false;
            if (null != c && null != (c = c.getParent())) {
                result = c.isInView();
            }
            return result;
        }

        private boolean thisEventCorrespondsToSubtreeRootAdd(FacesContext context, UIComponent c) {
            Collection<UIComponent> dynamics;
            boolean result = false;
            Map<Object, Object> contextMap = context.getAttributes();
            UIViewRoot root = context.getViewRoot();
            UIComponent originalComponent = c;
            if (null != c && !(dynamics = this.getDynamicComponentCollection(contextMap)).contains(c)) {
                for (c = c.getParent(); null != c && !dynamics.contains(c); c = c.getParent()) {
                }
                if (null == c || root.equals(c)) {
                    dynamics.add(originalComponent);
                    result = true;
                }
            }
            return result;
        }

        private Collection<UIComponent> getDynamicComponentCollection(Map<Object, Object> contextMap) {
            HashSet result = (HashSet)contextMap.get(DYNAMIC_COMPONENT_ADD_COLLECTION);
            if (null == result) {
                result = new HashSet();
                contextMap.put(DYNAMIC_COMPONENT_ADD_COLLECTION, result);
            }
            return result;
        }

        @Override
        protected void handleRemove(FacesContext context, UIComponent component) {
            if (!this.thisEventCorrespondsToSubtreeRootRemove(context, component)) {
                return;
            }
            Map<String, Object> attrs = component.getAttributes();
            String tagId = (String)attrs.remove("com.sun.faces.facelets.MARK_ID");
            if (tagId != null) {
                attrs.put(MARK_CREATED_REMOVED, tagId);
                this.childRemovedFromParent(component.getParent(), tagId);
            }
        }

        private void childRemovedFromParent(UIComponent parent, String childTagId) {
            if (parent != null) {
                Collection<String> removedChildrenIds = this.getPreviouslyRemovedChildren(parent);
                removedChildrenIds.add(childTagId);
                this.markChildrenModified(parent);
            }
        }

        private Collection<String> getPreviouslyRemovedChildren(UIComponent parent) {
            Map<String, Object> attrs = parent.getAttributes();
            MostlySingletonSet removedChildrenIds = (MostlySingletonSet)attrs.get("com.sun.faces.facelets.REMOVED_CHILDREN");
            if (removedChildrenIds == null) {
                removedChildrenIds = new MostlySingletonSet();
                attrs.put("com.sun.faces.facelets.REMOVED_CHILDREN", removedChildrenIds);
            }
            return removedChildrenIds;
        }

        private void markChildrenModified(UIComponent parent) {
            parent.getAttributes().put("com.sun.faces.facelets.MARK_CHILDREN_MODIFIED", true);
        }

        @Override
        protected void handleAdd(FacesContext context, UIComponent component) {
            if (!this.thisEventCorrespondsToSubtreeRootAdd(context, component)) {
                return;
            }
            Map<String, Object> attrs = component.getAttributes();
            String tagId = (String)attrs.get(MARK_CREATED_REMOVED);
            if (this.childAddedToSameParentAsBefore(component, tagId)) {
                attrs.remove(MARK_CREATED_REMOVED);
                attrs.put("com.sun.faces.facelets.MARK_ID", tagId);
            }
            this.markChildrenModified(component.getParent());
        }

        private boolean childAddedToSameParentAsBefore(UIComponent parent, String childTagId) {
            Map<String, Object> attrs;
            Collection removedChildrenIds;
            if (parent != null && (removedChildrenIds = (Collection)(attrs = parent.getAttributes()).get("com.sun.faces.facelets.REMOVED_CHILDREN")) != null && removedChildrenIds.remove(childTagId)) {
                if (removedChildrenIds.isEmpty()) {
                    attrs.remove("com.sun.faces.facelets.REMOVED_CHILDREN");
                }
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NoopAddRemoveListener
    extends AddRemoveListener {
        private HashMap emptyComponentsMap;

        public NoopAddRemoveListener(FacesContext context) {
            super(context);
            this.emptyComponentsMap = new HashMap();
        }

        @Override
        public List<ComponentStruct> getDynamicActions() {
            return Collections.emptyList();
        }

        @Override
        public HashMap<String, UIComponent> getDynamicComponents() {
            return this.emptyComponentsMap;
        }

        @Override
        protected void handleRemove(FacesContext context, UIComponent component) {
        }

        @Override
        protected void handleAdd(FacesContext context, UIComponent component) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AddRemoveListener
    implements SystemEventListener {
        private StateContext stateCtx;

        protected AddRemoveListener(FacesContext context) {
            this.stateCtx = StateContext.getStateContext(context);
        }

        public abstract List<ComponentStruct> getDynamicActions();

        public abstract HashMap<String, UIComponent> getDynamicComponents();

        @Override
        public void processEvent(SystemEvent event) throws AbortProcessingException {
            FacesContext ctx = FacesContext.getCurrentInstance();
            if (event instanceof PreRemoveFromViewEvent) {
                if (this.stateCtx.trackViewModifications()) {
                    this.handleRemove(ctx, ((PreRemoveFromViewEvent)event).getComponent());
                }
            } else if (this.stateCtx.trackViewModifications()) {
                this.handleAdd(ctx, ((PostAddToViewEvent)event).getComponent());
            }
        }

        @Override
        public boolean isListenerForSource(Object source) {
            return source instanceof UIComponent && !(source instanceof UIViewRoot);
        }

        protected abstract void handleRemove(FacesContext var1, UIComponent var2);

        protected abstract void handleAdd(FacesContext var1, UIComponent var2);
    }
}

