/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.FacesLogger;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.faces.FacesException;
import javax.xml.bind.DatatypeConverter;

public final class ByteArrayGuardAESCTR {
    private static final Logger LOGGER = FacesLogger.RENDERKIT.getLogger();
    private static final int KEY_LENGTH = 128;
    private static final int IV_LENGTH = 16;
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_CODE = "AES/CTR/NoPadding";
    private SecretKey sk;
    private IvParameterSpec ivspec;
    private Charset utf8;

    public ByteArrayGuardAESCTR() {
        try {
            this.setupKeyAndCharset();
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unexpected exception initializing encryption.  No encryption will be performed.", e);
            }
            System.err.println("ERROR: Initializing Ciphers");
        }
    }

    public String encrypt(String value) {
        String securedata = null;
        byte[] bytes = value.getBytes(this.utf8);
        try {
            Cipher encryptCipher = Cipher.getInstance(CIPHER_CODE);
            encryptCipher.init(1, (Key)this.sk, this.ivspec);
            byte[] encdata = encryptCipher.doFinal(bytes);
            securedata = DatatypeConverter.printBase64Binary((byte[])encdata);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unexpected exception initializing encryption.  No encryption will be performed.", e);
            }
            return null;
        }
        return securedata;
    }

    public String decrypt(String value) throws InvalidKeyException {
        byte[] bytes = DatatypeConverter.parseBase64Binary((String)value);
        try {
            byte[] plaindata;
            Cipher decryptCipher = Cipher.getInstance(CIPHER_CODE);
            decryptCipher.init(2, (Key)this.sk, this.ivspec);
            for (byte cur : plaindata = decryptCipher.doFinal(bytes)) {
                if (cur >= 0 && cur <= 127) continue;
                throw new InvalidKeyException("Invalid characters in decrypted value");
            }
            return new String(plaindata, this.utf8);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InvalidKeyException(nsae);
        }
        catch (NoSuchPaddingException nspe) {
            throw new InvalidKeyException(nspe);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new InvalidKeyException(iape);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new InvalidKeyException(ibse);
        }
        catch (BadPaddingException bpe) {
            throw new InvalidKeyException(bpe);
        }
    }

    private void setupKeyAndCharset() {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
            kg.init(128);
            this.sk = kg.generateKey();
        }
        catch (Exception e) {
            throw new FacesException(e);
        }
        SecureRandom rand = new SecureRandom();
        byte[] iv = new byte[16];
        rand.nextBytes(iv);
        this.ivspec = new IvParameterSpec(iv);
        SortedMap<String, Charset> availableCharsets = Charset.availableCharsets();
        if (availableCharsets.containsKey("UTF-8")) {
            this.utf8 = (Charset)availableCharsets.get("UTF-8");
        } else if (availableCharsets.containsKey("UTF8")) {
            this.utf8 = (Charset)availableCharsets.get("UTF8");
        } else {
            throw new FacesException("Unable to get UTF-8 Charset.");
        }
    }
}

