/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerationException;
import javax.json.stream.JsonGenerator;

class JsonGeneratorImpl
implements JsonGenerator {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    protected final GeneratorBufferedWriter writer;
    protected Context currentContext = new Context(Scope.IN_NONE);
    private final Deque<Context> stack = new ArrayDeque<Context>();
    private static final char[] INT_MIN_VALUE_CHARS = "-2147483648".toCharArray();
    private static final int[] INT_CHARS_SIZE_TABLE = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final char[] DIGIT_TENS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] DIGIT_ONES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    JsonGeneratorImpl(Writer writer) {
        this.writer = new GeneratorBufferedWriter(writer);
    }

    JsonGeneratorImpl(OutputStream out) {
        this(out, UTF_8);
    }

    JsonGeneratorImpl(OutputStream out, Charset encoding) {
        this(new OutputStreamWriter(out, encoding));
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new JsonException("I/O error while flushing JsonGenerator", e);
        }
    }

    @Override
    public JsonGenerator writeStartObject() {
        if (this.currentContext.scope == Scope.IN_OBJECT) {
            throw new JsonGenerationException("writeStartObject() cannot be called in object context");
        }
        if (this.currentContext.scope == Scope.IN_NONE && !this.currentContext.first) {
            throw new JsonGenerationException("writeStartObject() cannot be called in no context more than once");
        }
        try {
            this.writeComma();
            this.writer.write("{");
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing start object", ioe);
        }
        this.stack.push(this.currentContext);
        this.currentContext = new Context(Scope.IN_OBJECT);
        return this;
    }

    @Override
    public JsonGenerator writeStartObject(String name) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("writeStartObject(String) can only be called in object context");
        }
        try {
            this.writeName(name);
            this.writer.write("{");
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing start of object in JSON object", ioe);
        }
        this.stack.push(this.currentContext);
        this.currentContext = new Context(Scope.IN_OBJECT);
        return this;
    }

    private JsonGenerator writeName(String name) throws IOException {
        this.writeComma();
        JsonGeneratorImpl.writeEscapedString(this.writer, name);
        this.writer.write(":");
        return this;
    }

    @Override
    public JsonGenerator write(String name, String fieldValue) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("write(String, String) can only be called in object context");
        }
        try {
            this.writeName(name);
            JsonGeneratorImpl.writeEscapedString(this.writer, fieldValue);
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing (name, String) pair in JSON object", ioe);
        }
        return this;
    }

    @Override
    public JsonGenerator write(String name, int value) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("write(String, int) can only be called in object context");
        }
        try {
            this.writeName(name);
            this.writer.write(value);
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing (name, int) pair in JSON object", ioe);
        }
        return this;
    }

    @Override
    public JsonGenerator write(String name, long value) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("write(String, long) can only be called in object context");
        }
        try {
            this.writeName(name);
            this.writer.write(String.valueOf(value));
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing (name, long) pair in JSON object", ioe);
        }
        return this;
    }

    @Override
    public JsonGenerator write(String name, double value) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("write(String, double) can only be called in object context");
        }
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new NumberFormatException("write(String, double) value cannot be Infinite or NaN");
        }
        try {
            this.writeName(name);
            this.writer.write(String.valueOf(value));
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing (name, double) pair in JSON object", ioe);
        }
        return this;
    }

    @Override
    public JsonGenerator write(String name, BigInteger value) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("write(String, BigInteger) can only be called in object context");
        }
        try {
            this.writeName(name);
            this.writer.write(String.valueOf(value));
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing (name, BigInteger) pair in JSON object", ioe);
        }
        return this;
    }

    @Override
    public JsonGenerator write(String name, BigDecimal value) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("write(String, BigDecimal) can only be called in object context");
        }
        try {
            this.writeName(name);
            this.writer.write(String.valueOf(value));
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing (name, BigDecimal) pair in JSON object", ioe);
        }
        return this;
    }

    @Override
    public JsonGenerator write(String name, boolean value) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("write(String, boolean) can only be called in object context");
        }
        try {
            this.writeName(name);
            this.writer.write(value ? "true" : "false");
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing (name, boolean) pair in JSON object", ioe);
        }
        return this;
    }

    @Override
    public JsonGenerator writeNull(String name) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("writeNull(String) can only be called in object context");
        }
        try {
            this.writeName(name);
            this.writer.write("null");
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing null value in JSON object", ioe);
        }
        return this;
    }

    @Override
    public JsonGenerator write(JsonValue value) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException("write(JsonValue) can only be called in array context");
        }
        switch (value.getValueType()) {
            case ARRAY: {
                JsonArray array = (JsonArray)value;
                this.writeStartArray();
                for (JsonValue child : array) {
                    this.write(child);
                }
                this.writeEnd();
                break;
            }
            case OBJECT: {
                JsonObject object = (JsonObject)value;
                this.writeStartObject();
                for (Map.Entry member : object.entrySet()) {
                    this.write((String)member.getKey(), (JsonValue)member.getValue());
                }
                this.writeEnd();
                break;
            }
            case STRING: {
                JsonString str = (JsonString)value;
                this.write(str.getString());
                break;
            }
            case NUMBER: {
                JsonNumber number = (JsonNumber)value;
                try {
                    this.writeValue(number.toString());
                    break;
                }
                catch (IOException ioe) {
                    throw new JsonException("I/O error while writing a number", ioe);
                }
            }
            case TRUE: {
                this.write(true);
                break;
            }
            case FALSE: {
                this.write(false);
                break;
            }
            case NULL: {
                this.writeNull();
            }
        }
        return this;
    }

    @Override
    public JsonGenerator writeStartArray() {
        if (this.currentContext.scope == Scope.IN_OBJECT) {
            throw new JsonGenerationException("writeStartArray() cannot be called in object context");
        }
        if (this.currentContext.scope == Scope.IN_NONE && !this.currentContext.first) {
            throw new JsonGenerationException("writeStartArray() cannot be called in no context more than once");
        }
        try {
            this.writeComma();
            this.writer.write("[");
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing start of JSON array", ioe);
        }
        this.stack.push(this.currentContext);
        this.currentContext = new Context(Scope.IN_ARRAY);
        return this;
    }

    @Override
    public JsonGenerator writeStartArray(String name) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("writeStartArray(String) can only be called in object context");
        }
        try {
            this.writeName(name);
            this.writer.write("[");
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing start of array in JSON object", ioe);
        }
        this.stack.push(this.currentContext);
        this.currentContext = new Context(Scope.IN_ARRAY);
        return this;
    }

    @Override
    public JsonGenerator write(String name, JsonValue value) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("write(String, JsonValue) can only be called in object context");
        }
        switch (value.getValueType()) {
            case ARRAY: {
                JsonArray array = (JsonArray)value;
                this.writeStartArray(name);
                for (JsonValue child : array) {
                    this.write(child);
                }
                this.writeEnd();
                break;
            }
            case OBJECT: {
                JsonObject object = (JsonObject)value;
                this.writeStartObject(name);
                for (Map.Entry member : object.entrySet()) {
                    this.write((String)member.getKey(), (JsonValue)member.getValue());
                }
                this.writeEnd();
                break;
            }
            case STRING: {
                JsonString str = (JsonString)value;
                this.write(name, str.getString());
                break;
            }
            case NUMBER: {
                JsonNumber number = (JsonNumber)value;
                try {
                    this.writeValue(name, number.toString());
                    break;
                }
                catch (IOException ioe) {
                    throw new JsonException("I/O error while writing a number in JSON object", ioe);
                }
            }
            case TRUE: {
                this.write(name, true);
                break;
            }
            case FALSE: {
                this.write(name, false);
                break;
            }
            case NULL: {
                this.writeNull(name);
            }
        }
        return this;
    }

    @Override
    public JsonGenerator write(String value) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException("write(String) can only be called in array context");
        }
        try {
            this.writeComma();
            JsonGeneratorImpl.writeEscapedString(this.writer, value);
        }
        catch (IOException e) {
            throw new JsonException("I/O error while writing string value in JSON array", e);
        }
        return this;
    }

    @Override
    public JsonGenerator write(int value) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException("write(int) can only be called in array context");
        }
        try {
            this.writeComma();
            this.writer.write(value);
        }
        catch (IOException e) {
            throw new JsonException("I/O error while writing int value in JSON array", e);
        }
        return this;
    }

    @Override
    public JsonGenerator write(long value) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException("write(long) can only be called in array context");
        }
        try {
            this.writeValue(String.valueOf(value));
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing long value in JSON array", ioe);
        }
        return this;
    }

    @Override
    public JsonGenerator write(double value) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException("write(double) can only be called in array context");
        }
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new NumberFormatException("write(double) value cannot be Infinite or NaN");
        }
        try {
            this.writeValue(String.valueOf(value));
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing double value in JSON array", ioe);
        }
        return this;
    }

    @Override
    public JsonGenerator write(BigInteger value) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException("write(BigInteger) can only be called in array context");
        }
        try {
            this.writeValue(value.toString());
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing BigInteger value in JSON array", ioe);
        }
        return this;
    }

    @Override
    public JsonGenerator write(BigDecimal value) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException("write(BigDecimal) can only be called in array context");
        }
        try {
            this.writeValue(value.toString());
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing BigDecimal value in JSON array", ioe);
        }
        return this;
    }

    @Override
    public JsonGenerator write(boolean value) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException("write(boolean) can only be called in array context");
        }
        try {
            this.writeComma();
            this.writer.write(value ? "true" : "false");
        }
        catch (IOException e) {
            throw new JsonException("I/O error while writing boolean value in JSON array", e);
        }
        return this;
    }

    @Override
    public JsonGenerator writeNull() {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException("writeNull() can only be called in array context");
        }
        try {
            this.writeComma();
            this.writer.write("null");
        }
        catch (IOException e) {
            throw new JsonException("I/O error while writing null value in JSON array", e);
        }
        return this;
    }

    private void writeValue(String value) throws IOException {
        this.writeComma();
        this.writer.write(value);
    }

    private void writeValue(String name, String value) throws IOException {
        this.writeComma();
        JsonGeneratorImpl.writeEscapedString(this.writer, name);
        this.writer.write(':');
        this.writer.write(value);
    }

    void flushBuffer() {
        try {
            this.writer.flushBuffer();
        }
        catch (IOException e) {
            throw new JsonException("I/O error while flushing the buffer", e);
        }
    }

    @Override
    public JsonGenerator writeEnd() {
        if (this.currentContext.scope == Scope.IN_NONE) {
            throw new JsonGenerationException("writeEnd() cannot be called in no context");
        }
        try {
            this.writer.write(this.currentContext.scope == Scope.IN_ARRAY ? (char)']' : '}');
        }
        catch (IOException e) {
            throw new JsonException("I/O error while writing end of JSON structure", e);
        }
        this.currentContext = this.stack.pop();
        return this;
    }

    protected void writeComma() throws IOException {
        if (!this.currentContext.first) {
            this.writer.write(",");
        }
        this.currentContext.first = false;
    }

    @Override
    public void close() {
        if (this.currentContext.scope != Scope.IN_NONE || this.currentContext.first) {
            throw new JsonGenerationException("Generating incomplete JSON");
        }
        try {
            this.writer.close();
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while closing JsonGenerator", ioe);
        }
    }

    static void writeEscapedString(GeneratorBufferedWriter w, String string) throws IOException {
        w.write('\"');
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    w.write('\\');
                    w.write(c);
                    continue block8;
                }
                case '\b': {
                    w.write("\\b");
                    continue block8;
                }
                case '\f': {
                    w.write("\\f");
                    continue block8;
                }
                case '\n': {
                    w.write("\\n");
                    continue block8;
                }
                case '\r': {
                    w.write("\\r");
                    continue block8;
                }
                case '\t': {
                    w.write("\\t");
                    continue block8;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String hex = "000" + Integer.toHexString(c);
                        w.write("\\u" + hex.substring(hex.length() - 4));
                        continue block8;
                    }
                    w.write(c);
                }
            }
        }
        w.write('\"');
    }

    private static int stringSize(int x) {
        int i = 0;
        while (x > INT_CHARS_SIZE_TABLE[i]) {
            ++i;
        }
        return i + 1;
    }

    private static void fillIntChars(int i, char[] buf, int index) {
        int r;
        int q;
        int charPos = index;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--charPos] = DIGIT_ONES[r];
            buf[--charPos] = DIGIT_TENS[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = DIGITS[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    static final class GeneratorBufferedWriter {
        private final Writer writer;
        private final char[] buf = new char[4096];
        private int len = 0;

        GeneratorBufferedWriter(Writer writer) {
            this.writer = writer;
        }

        void write(String str) throws IOException {
            int begin = 0;
            int end = str.length();
            while (begin < end) {
                int no = Math.min(this.buf.length - this.len, end - begin);
                str.getChars(begin, begin + no, this.buf, this.len);
                begin += no;
                this.len += no;
                if (this.len < this.buf.length) continue;
                this.flushBuffer();
            }
        }

        void write(char c) throws IOException {
            if (this.len >= this.buf.length) {
                this.flushBuffer();
            }
            this.buf[this.len++] = c;
        }

        void write(int num) throws IOException {
            int size;
            if (num == Integer.MIN_VALUE) {
                size = INT_MIN_VALUE_CHARS.length;
            } else {
                int n = size = num < 0 ? JsonGeneratorImpl.stringSize(-num) + 1 : JsonGeneratorImpl.stringSize(num);
            }
            if (this.len + size >= this.buf.length) {
                this.flushBuffer();
            }
            if (num == Integer.MIN_VALUE) {
                System.arraycopy(INT_MIN_VALUE_CHARS, 0, this.buf, this.len, size);
            } else {
                JsonGeneratorImpl.fillIntChars(num, this.buf, this.len + size);
            }
            this.len += size;
        }

        void flushBuffer() throws IOException {
            if (this.len > 0) {
                this.writer.write(this.buf, 0, this.len);
                this.len = 0;
            }
        }

        void flush() throws IOException {
            this.flushBuffer();
            this.writer.flush();
        }

        void close() throws IOException {
            this.flushBuffer();
            this.writer.close();
        }
    }

    private static class Context {
        boolean first = true;
        final Scope scope;

        Context(Scope scope) {
            this.scope = scope;
        }
    }

    private static enum Scope {
        IN_NONE,
        IN_OBJECT,
        IN_ARRAY;

    }
}

