/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.validation.internal;

import jakarta.validation.Configuration;
import jakarta.validation.ValidationException;
import jakarta.validation.executable.ExecutableType;
import jakarta.validation.executable.ValidateOnExecution;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.glassfish.jersey.internal.guava.ListMultimap;
import org.glassfish.jersey.internal.guava.Multimap;
import org.glassfish.jersey.internal.guava.Multimaps;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.server.validation.internal.LocalizationMessages;

class ValidateOnExecutionHandler {
    private final ConcurrentMap<Method, Boolean> validateMethodCache = new ConcurrentHashMap<Method, Boolean>();
    private final ConcurrentMap<Method, Boolean> validateGetterCache = new ConcurrentHashMap<Method, Boolean>();
    private final Configuration config;
    private final boolean checkOverrides;

    ValidateOnExecutionHandler(Configuration config, boolean checkOverrides) {
        this.config = config;
        this.checkOverrides = checkOverrides;
    }

    boolean validateGetter(Class<?> clazz, Method method) {
        if (!this.validateGetterCache.containsKey(method)) {
            this.processMethod(clazz, method, method, true);
        }
        return (Boolean)this.validateGetterCache.get(method);
    }

    boolean validateMethod(Class<?> clazz, Method method, Method validationMethod) {
        if (!this.validateMethodCache.containsKey(validationMethod)) {
            this.processMethod(clazz, method, validationMethod, false);
        }
        return (Boolean)this.validateMethodCache.get(validationMethod);
    }

    private void processMethod(Class<?> clazz, Method method, Method validationMethod, boolean forceValidation) {
        Deque<Class<?>> hierarchy = this.getValidationClassHierarchy(clazz);
        Boolean validateMethod = this.processAnnotation(method, hierarchy, this.checkOverrides);
        if (validateMethod != null) {
            this.validateMethodCache.putIfAbsent(validationMethod, validateMethod);
            this.validateGetterCache.putIfAbsent(validationMethod, validateMethod);
        }
        if (!this.validateMethodCache.containsKey(validationMethod)) {
            Set defaultValidatedExecutableTypes = this.config.getBootstrapConfiguration().getDefaultValidatedExecutableTypes();
            validateMethod = this.validateMethod(method, false, defaultValidatedExecutableTypes);
            this.validateGetterCache.putIfAbsent(validationMethod, validateMethod != false || forceValidation);
            this.validateMethodCache.putIfAbsent(validationMethod, ReflectionHelper.isGetter((Method)validationMethod) || validateMethod != false);
        }
    }

    private Boolean processAnnotation(Method method, Deque<Class<?>> hierarchy, boolean checkOverrides) {
        while (!hierarchy.isEmpty()) {
            Class<?> overriddenClass = hierarchy.removeFirst();
            Method overriddenMethod = (Method)AccessController.doPrivileged(ReflectionHelper.findMethodOnClassPA(overriddenClass, (Method)method));
            if (overriddenMethod == null) continue;
            Set<ExecutableType> executableTypes = this.getExecutableTypes(overriddenMethod);
            if (!executableTypes.isEmpty()) {
                if (checkOverrides && this.processAnnotation(method, hierarchy, false) != null) {
                    String methodName = method.getDeclaringClass().getName() + "#" + method.getName();
                    throw new ValidationException(LocalizationMessages.OVERRIDE_CHECK_ERROR(methodName));
                }
                return this.validateMethod(overriddenMethod, true, executableTypes);
            }
            executableTypes = this.getExecutableTypes(overriddenClass);
            if (executableTypes.isEmpty() || executableTypes.size() == 1 && executableTypes.contains(ExecutableType.IMPLICIT)) continue;
            return this.validateMethod(overriddenMethod, false, executableTypes);
        }
        return null;
    }

    private boolean validateMethod(Method method, boolean allowImplicit, Set<ExecutableType> executableTypes) {
        if (executableTypes.contains(ExecutableType.ALL) || allowImplicit && executableTypes.contains(ExecutableType.IMPLICIT)) {
            return true;
        }
        return ReflectionHelper.isGetter((Method)method) ? executableTypes.contains(ExecutableType.GETTER_METHODS) : executableTypes.contains(ExecutableType.NON_GETTER_METHODS);
    }

    private Set<ExecutableType> getExecutableTypes(AnnotatedElement element) {
        ValidateOnExecution validateExecutable = element.getAnnotation(ValidateOnExecution.class);
        return validateExecutable != null ? Arrays.stream(validateExecutable.type()).collect(Collectors.toSet()) : Collections.emptySet();
    }

    private Deque<Class<?>> getValidationClassHierarchy(Class<?> clazz) {
        ArrayList hierarchy = new ArrayList();
        for (Class<?> currentClass = clazz; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            hierarchy.add(clazz);
        }
        hierarchy.addAll(this.getAllValidationInterfaces(clazz));
        Collections.reverse(hierarchy);
        return new ArrayDeque(hierarchy);
    }

    private List<Class<?>> getAllValidationInterfaces(Class<?> clazz) {
        ListMultimap map = Multimaps.newListMultimap(new TreeMap(), ArrayList::new);
        this.retrieveAllValidationInterfaces(clazz, (Multimap<Integer, Class<?>>)map);
        ArrayList interfaces = new ArrayList(map.values());
        Collections.reverse(interfaces);
        return interfaces;
    }

    private int retrieveAllValidationInterfaces(Class<?> clazz, Multimap<Integer, Class<?>> map) {
        if (clazz == null) {
            return 0;
        }
        int minDepth = 0;
        while (clazz != null) {
            for (Class<?> iface : clazz.getInterfaces()) {
                int depth = this.retrieveAllValidationInterfaces(iface, map);
                if (!map.containsValue(iface)) {
                    map.put((Object)depth, iface);
                }
                minDepth = minDepth > depth ? depth : minDepth;
            }
            clazz = clazz.getSuperclass();
        }
        return minDepth + 1;
    }
}

