/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.readline;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.gnu.readline.ReadlineCompleter;
import org.gnu.readline.ReadlineConstInt;
import org.gnu.readline.ReadlineConstString;
import org.gnu.readline.ReadlineLibrary;

public class Readline {
    public static final ReadlineConstString RL_LIBRARY_VERSION = new ReadlineConstString(0, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline, ReadlineLibrary.Editline});
    public static final ReadlineConstString RL_READLINE_NAME = new ReadlineConstString(1, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline, ReadlineLibrary.Editline});
    public static final ReadlineConstString RL_PROMPT = new ReadlineConstString(2, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline, ReadlineLibrary.Getline});
    public static final ReadlineConstString RL_LINE_BUFFER = new ReadlineConstString(3, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline, ReadlineLibrary.Editline, ReadlineLibrary.Getline});
    public static final ReadlineConstString RL_TERMINAL_NAME = new ReadlineConstString(4, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstString RL_EXECUTING_MACRO = new ReadlineConstString(5, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstString RL_BASIC_WORD_BREAK_CHARACTERS = new ReadlineConstString(6, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline, ReadlineLibrary.Editline});
    public static final ReadlineConstString RL_COMPLETER_WORD_BREAK_CHARACTERS = new ReadlineConstString(7, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline, ReadlineLibrary.Editline});
    public static final ReadlineConstString RL_COMPLETER_QUOTE_CHARACTERS = new ReadlineConstString(8, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline, ReadlineLibrary.Editline});
    public static final ReadlineConstString RL_BASIC_QUOTE_CHARACTERS = new ReadlineConstString(9, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstString RL_FILENAME_QUOTE_CHARACTERS = new ReadlineConstString(10, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstString RL_SPECIAL_PREFIXES = new ReadlineConstString(11, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline, ReadlineLibrary.Editline});
    public static final ReadlineConstString HISTORY_WORD_DELIMITERS = new ReadlineConstString(12, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstString HISTORY_NO_EXPAND_CHARS = new ReadlineConstString(13, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstString HISTORY_SEARCH_DELIMITERS = new ReadlineConstString(14, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_READLINE_VERSION = new ReadlineConstInt(0, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_GNU_READLINE_P = new ReadlineConstInt(1, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_READLINE_STATE = new ReadlineConstInt(2, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_EDITING_MODE = new ReadlineConstInt(3, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_INSERT_MODE = new ReadlineConstInt(4, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline, ReadlineLibrary.Getline});
    public static final ReadlineConstInt RL_POINT = new ReadlineConstInt(5, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline, ReadlineLibrary.Editline, ReadlineLibrary.Getline});
    public static final ReadlineConstInt RL_END = new ReadlineConstInt(6, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline, ReadlineLibrary.Editline, ReadlineLibrary.Getline});
    public static final ReadlineConstInt RL_MARK = new ReadlineConstInt(7, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_DONE = new ReadlineConstInt(8, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_PENDING_INPUT = new ReadlineConstInt(9, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_DISPATCHING = new ReadlineConstInt(10, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_EXPLICIT_ARG = new ReadlineConstInt(11, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_NUMERIC_ARG = new ReadlineConstInt(12, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_ERASE_EMPTY_LINE = new ReadlineConstInt(13, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_ALREADY_PROMPTED = new ReadlineConstInt(14, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_NUM_CHARS_TO_READ = new ReadlineConstInt(15, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_CATCH_SIGNALS = new ReadlineConstInt(16, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_CATCH_SIGWINCH = new ReadlineConstInt(17, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_FILENAME_COMPLETION_DESIRED = new ReadlineConstInt(18, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_FILENAME_QUOTING_DESIRED = new ReadlineConstInt(19, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_ATTEMPTED_COMPLETION_OVER = new ReadlineConstInt(20, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_COMPLETION_TYPE = new ReadlineConstInt(21, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline, ReadlineLibrary.Editline});
    public static final ReadlineConstInt RL_COMPLETION_APPEND_CHARACTER = new ReadlineConstInt(22, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline, ReadlineLibrary.Editline});
    public static final ReadlineConstInt RL_COMPLETION_SUPPRESS_APPEND = new ReadlineConstInt(23, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_COMPLETION_QUERY_ITEMS = new ReadlineConstInt(24, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline, ReadlineLibrary.Editline});
    public static final ReadlineConstInt RL_COMPLETION_MARK_SYMLINK_DIRS = new ReadlineConstInt(25, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_IGNORE_COMPLETION_DUPLICATES = new ReadlineConstInt(26, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt RL_INHIBIT_COMPLETION = new ReadlineConstInt(27, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline, ReadlineLibrary.Editline});
    public static final ReadlineConstInt HISTORY_BASE = new ReadlineConstInt(28, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline, ReadlineLibrary.Editline});
    public static final ReadlineConstInt HISTORY_LENGTH = new ReadlineConstInt(29, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline, ReadlineLibrary.Editline});
    public static final ReadlineConstInt HISTORY_MAX_ENTRIES = new ReadlineConstInt(30, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    public static final ReadlineConstInt HISTORY_QUOTES_EXPANSION = new ReadlineConstInt(31, new ReadlineLibrary[]{ReadlineLibrary.GnuReadline});
    private static ReadlineCompleter iCompleter = null;
    private static ReadlineLibrary iLib = ReadlineLibrary.PureJava;
    private static BufferedReader iReader = null;
    private static String iEncoding = System.getProperty("readline.encoding", null);
    private static boolean iThrowException = false;

    public static final void load(ReadlineLibrary readlineLibrary) throws UnsatisfiedLinkError {
        if (readlineLibrary == iLib) {
            return;
        }
        if (readlineLibrary == ReadlineLibrary.PureJava) {
            iLib = readlineLibrary;
            return;
        }
        System.loadLibrary(readlineLibrary.getName());
        iLib = readlineLibrary;
    }

    public static void initReadline(String string) {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline || iLib == ReadlineLibrary.Getline) {
            Readline.initReadlineImpl(string);
        }
    }

    public static String readline(String string) throws EOFException, IOException, UnsupportedEncodingException {
        return Readline.readline(string, true);
    }

    public static String readline(String string, boolean bl) throws EOFException, IOException, UnsupportedEncodingException {
        String string2;
        if (iLib != ReadlineLibrary.PureJava) {
            String string3 = Readline.readlineImpl(string);
            if (string3 != null && bl) {
                Readline.addToHistory(string3);
            }
            return string3;
        }
        System.out.print(string);
        if (iReader == null) {
            iReader = iEncoding == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new InputStreamReader(System.in, iEncoding));
        }
        if ((string2 = iReader.readLine()) == null) {
            throw new EOFException("EOF");
        }
        if (string2.length() == 0) {
            string2 = null;
        }
        return string2;
    }

    public static void addToHistory(String string) {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline || iLib == ReadlineLibrary.Getline) {
            Readline.addToHistoryImpl(string);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static void getHistory(Collection collection) {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.getHistoryImpl(collection);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static int getHistorySize() {
        int n = 0;
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            n = Readline.getHistorySizeImpl();
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return n;
    }

    public static void clearHistory() {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.clearHistoryImpl();
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static String getHistoryLine(int n) {
        String string = null;
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            if (n < 0 || n >= Readline.getHistorySize()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            string = Readline.getHistoryLineImpl(n);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return string;
    }

    public static void readInitFile(String string) throws IOException {
        if (iLib == ReadlineLibrary.GnuReadline) {
            Readline.readInitFileImpl(string);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static boolean parseAndBind(String string) {
        if (iLib == ReadlineLibrary.GnuReadline) {
            return Readline.parseAndBindImpl(string);
        }
        if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return true;
    }

    public static void readHistoryFile(String string) throws EOFException, UnsupportedEncodingException {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.readHistoryFileImpl(string);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static void writeHistoryFile(String string) throws EOFException, UnsupportedEncodingException {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.writeHistoryFileImpl(string);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static void setCompleter(ReadlineCompleter readlineCompleter) {
        iCompleter = readlineCompleter;
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.setCompleterImpl(iCompleter);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static ReadlineCompleter getCompleter() {
        return iCompleter;
    }

    public static void cleanup() {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.cleanupReadlineImpl();
        }
    }

    public static boolean hasTerminal() {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            return Readline.hasTerminalImpl();
        }
        return true;
    }

    public static void setWordBreakCharacters(String string) throws UnsupportedEncodingException {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.setWordBreakCharactersImpl(string);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static String getWordBreakCharacters() {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            return Readline.getWordBreakCharactersImpl();
        }
        if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public static String getLineBuffer() {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            return Readline.getLineBufferImpl();
        }
        if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public static void setThrowExceptionOnUnsupportedMethod(boolean bl) {
        iThrowException = bl;
    }

    public static boolean getThrowExceptionOnUnsupportedMethod() {
        return iThrowException;
    }

    public static void setEncoding(String string) {
        iEncoding = string;
    }

    public static String getEncoding() {
        return iEncoding;
    }

    public static int setVar(ReadlineConstInt readlineConstInt, int n) {
        if (readlineConstInt.isSupported(iLib)) {
            return Readline.setVarIntImpl(readlineConstInt.getNumber(), n);
        }
        if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return Integer.MIN_VALUE;
    }

    public static int getVar(ReadlineConstInt readlineConstInt) {
        if (readlineConstInt.isSupported(iLib)) {
            return Readline.getVarIntImpl(readlineConstInt.getNumber());
        }
        if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return Integer.MIN_VALUE;
    }

    public static String setVar(ReadlineConstString readlineConstString, String string) throws UnsupportedEncodingException {
        if (readlineConstString.isSupported(iLib)) {
            return Readline.setVarStringImpl(readlineConstString.getNumber(), string);
        }
        if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public static String getVar(ReadlineConstString readlineConstString) throws UnsupportedEncodingException {
        if (readlineConstString.isSupported(iLib)) {
            return Readline.getVarStringImpl(readlineConstString.getNumber());
        }
        if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    private static native void initReadlineImpl(String var0);

    private static native void cleanupReadlineImpl();

    private static native boolean hasTerminalImpl();

    private static native String readlineImpl(String var0) throws EOFException, UnsupportedEncodingException;

    private static native void addToHistoryImpl(String var0);

    private static native void getHistoryImpl(Collection var0);

    private static native int getHistorySizeImpl();

    private static native String getHistoryLineImpl(int var0);

    private static native void clearHistoryImpl();

    private static native void readInitFileImpl(String var0) throws IOException;

    private static native String getLineBufferImpl();

    private static native boolean parseAndBindImpl(String var0);

    private static native void readHistoryFileImpl(String var0) throws EOFException, UnsupportedEncodingException;

    private static native void writeHistoryFileImpl(String var0) throws EOFException, UnsupportedEncodingException;

    private static native void setCompleterImpl(ReadlineCompleter var0);

    private static native String getWordBreakCharactersImpl();

    private static native void setWordBreakCharactersImpl(String var0) throws UnsupportedEncodingException;

    private static native int setVarIntImpl(int var0, int var1);

    private static native int getVarIntImpl(int var0);

    private static native String setVarStringImpl(int var0, String var1) throws UnsupportedEncodingException;

    private static native String getVarStringImpl(int var0) throws UnsupportedEncodingException;
}

