/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.graalvm.buildtools.Utils;
import org.graalvm.buildtools.maven.AbstractNativeMojo;
import org.graalvm.buildtools.maven.NativeExtension;
import org.graalvm.buildtools.utils.NativeImageUtils;
import org.graalvm.junit.platform.JUnitPlatformFeature;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST, requiresDependencyCollection=ResolutionScope.TEST)
public class NativeTestMojo
extends AbstractNativeMojo {
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="skipNativeTests", defaultValue="false")
    private boolean skipNativeTests;
    @Parameter(property="classpath")
    private List<String> classpath;
    @Parameter(property="project.build.directory")
    private File buildDirectory;
    @Parameter(property="environmentVariables")
    private Map<String, String> environment;
    @Parameter(property="systemPropertyVariables")
    private Map<String, String> systemProperties;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTests || this.skipNativeTests) {
            this.logger.info("Skipping native-image tests (parameter 'skipTests' or 'skipNativeTests' is true).");
            return;
        }
        this.configureEnvironment();
        if (!this.hasTests()) {
            return;
        }
        String classpath = this.getClassPath();
        Optional<Path> nativePlatformJar = NativeTestMojo.findNativePlatformJar();
        if (nativePlatformJar.isPresent()) {
            classpath = classpath + File.pathSeparator + nativePlatformJar.get().toFile().getAbsolutePath();
        }
        Path targetFolder = new File(this.project.getBuild().getDirectory()).toPath();
        targetFolder.toFile().mkdirs();
        this.logger.info("====================");
        this.logger.info("Initializing project: " + this.project.getName());
        this.logger.info("====================");
        if (!this.hasTestIds()) {
            this.logger.error("Test configuration file wasn't found. Make sure that test execution wasn't skipped.");
            throw new IllegalStateException("Test configuration file wasn't found.");
        }
        this.logger.debug("Classpath: " + classpath);
        this.buildImage(classpath, targetFolder);
        this.runTests(targetFolder);
    }

    private void configureEnvironment() {
        Object configuration;
        Plugin plugin = this.project.getPlugin("org.apache.maven.plugins:maven-surefire-plugin");
        if (plugin != null && (configuration = plugin.getConfiguration()) instanceof Xpp3Dom) {
            Xpp3Dom systemProps;
            Xpp3Dom dom = (Xpp3Dom)configuration;
            Xpp3Dom environmentVariables = dom.getChild("environmentVariables");
            if (environmentVariables != null) {
                Xpp3Dom[] children = environmentVariables.getChildren();
                if (this.environment == null) {
                    this.environment = new HashMap<String, String>(children.length);
                }
                for (Xpp3Dom child : children) {
                    this.environment.put(child.getName(), child.getValue());
                }
            }
            if ((systemProps = dom.getChild("systemPropertyVariables")) != null) {
                Xpp3Dom[] children = systemProps.getChildren();
                if (this.systemProperties == null) {
                    this.systemProperties = new HashMap<String, String>(children.length);
                }
                for (Xpp3Dom child : children) {
                    this.systemProperties.put(child.getName(), child.getValue());
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasTests() {
        Path testOutputPath = Paths.get(this.project.getBuild().getTestOutputDirectory(), new String[0]);
        if (!Files.exists(testOutputPath, new LinkOption[0])) return false;
        if (!Files.isDirectory(testOutputPath, new LinkOption[0])) return false;
        try (DirectoryStream<Path> directory = Files.newDirectoryStream(testOutputPath);){
            boolean bl = directory.iterator().hasNext();
            return bl;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void buildImage(String classpath, Path targetFolder) throws MojoExecutionException {
        Path nativeImageExecutable = Utils.getNativeImage();
        List<String> command = new ArrayList<String>(Arrays.asList("-cp", classpath, "--features=org.graalvm.junit.platform.JUnitPlatformFeature", "-Djunit.platform.listeners.uid.tracking.output.dir=" + NativeExtension.testIdsDirectory(this.buildDirectory.getAbsolutePath()), "-H:Path=" + targetFolder.toAbsolutePath(), "-H:Name=" + Utils.NATIVE_TESTS_EXE));
        this.maybeAddGeneratedResourcesConfig(command);
        if (this.buildArgs != null) {
            command.addAll(this.buildArgs);
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(nativeImageExecutable.toString());
            this.prepareVariables(processBuilder, command);
            command = NativeImageUtils.convertToArgsFile(command);
            processBuilder.command().addAll(command);
            processBuilder.command().add("org.graalvm.junit.platform.NativeImageJUnitLauncher");
            processBuilder.directory(new File(this.project.getBuild().getDirectory()));
            processBuilder.inheritIO();
            String commandString = String.join((CharSequence)" ", processBuilder.command());
            this.getLog().info((CharSequence)("Executing: " + commandString));
            Process imageBuildProcess = processBuilder.start();
            if (imageBuildProcess.waitFor() != 0) {
                throw new MojoExecutionException("Execution of " + commandString + " returned non-zero result");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Building image with " + nativeImageExecutable + " failed", e);
        }
    }

    private void runTests(Path targetFolder) throws MojoExecutionException {
        Path xmlLocation = targetFolder.resolve("native-test-reports");
        xmlLocation.toFile().mkdirs();
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(targetFolder.resolve(Utils.NATIVE_TESTS_EXE).toAbsolutePath().toString());
            processBuilder.inheritIO();
            ArrayList<String> command = new ArrayList<String>();
            this.prepareVariables(processBuilder, command);
            command.add("--xml-output-dir");
            command.add(xmlLocation.toString());
            processBuilder.command().addAll(command);
            String commandString = String.join((CharSequence)" ", processBuilder.command());
            this.getLog().info((CharSequence)("Executing: " + commandString));
            Process imageBuildProcess = processBuilder.start();
            if (imageBuildProcess.waitFor() != 0) {
                throw new MojoExecutionException("Execution of " + commandString + " returned non-zero result");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("native-image test run failed");
        }
    }

    private void prepareVariables(ProcessBuilder processBuilder, List<String> command) {
        if (this.environment != null) {
            processBuilder.environment().putAll(this.environment);
        }
        if (this.systemProperties != null) {
            for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
                command.add("-D" + entry.getKey() + "=" + entry.getValue());
            }
        }
    }

    private String getClassPath() throws MojoFailureException {
        if (this.classpath != null && !this.classpath.isEmpty()) {
            return String.join((CharSequence)File.pathSeparator, this.classpath);
        }
        try {
            List pluginDependencies = this.pluginArtifacts.stream().filter(it -> it.getGroupId().startsWith("org.graalvm.buildtools") || it.getGroupId().startsWith("org.junit")).collect(Collectors.toList());
            ArrayList projectClassPath = new ArrayList(this.project.getTestClasspathElements());
            Stream<String> allResources = Stream.concat(this.project.getBuild().getResources().stream().map(FileSet::getDirectory), this.project.getBuild().getTestResources().stream().map(FileSet::getDirectory));
            return Stream.concat(Stream.concat(projectClassPath.stream(), allResources), pluginDependencies.stream().map(it -> it.getFile().toString())).collect(Collectors.joining(File.pathSeparator));
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean hasTestIds() {
        try {
            Path buildDir = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
            return this.readAllFiles(buildDir, "junit-platform-unique-ids").anyMatch(contents -> !contents.isEmpty());
        }
        catch (Exception ex) {
            return false;
        }
    }

    private Stream<String> readAllFiles(Path dir, String prefix) throws IOException {
        return NativeTestMojo.findFiles(dir, prefix).map(outputFile -> {
            try {
                return Files.readAllLines(outputFile);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }).flatMap(Collection::stream);
    }

    private static Stream<Path> findFiles(Path dir, String prefix) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return Stream.empty();
        }
        return Files.find(dir, Integer.MAX_VALUE, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile() && path.getFileName().toString().startsWith(prefix), new FileVisitOption[0]);
    }

    private static Optional<Path> findNativePlatformJar() {
        try {
            return Optional.of(new File(JUnitPlatformFeature.class.getProtectionDomain().getCodeSource().getLocation().toURI()).toPath());
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
    }
}

