/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.js.runtime.util.ReferenceKey;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

public final class ConcurrentWeakIdentityHashMap<K, V>
implements Map<K, V> {
    private final Map<ReferenceKey<K>, V> map = new ConcurrentHashMap<ReferenceKey<K>, V>();
    private final ReferenceQueue<K> stale = new ReferenceQueue();

    private ConcurrentWeakIdentityHashMap() {
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> ConcurrentWeakIdentityHashMap<K, V> create() {
        return new ConcurrentWeakIdentityHashMap<K, V>();
    }

    private ReferenceKey<K> entryKey(K key) {
        return new ReferenceKey.WeakKeyWithIdentity<K>(key, this.stale);
    }

    private ReferenceKey<K> lookupKey(Object key) {
        return new ReferenceKey.StrongKeyWithIdentity<Object>(key);
    }

    @Override
    public V get(Object key) {
        this.removeStaleReferences();
        return this.map.get(this.lookupKey(key));
    }

    @Override
    public boolean containsKey(Object key) {
        this.removeStaleReferences();
        return this.map.containsKey(this.lookupKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        this.removeStaleReferences();
        return this.map.containsValue(value);
    }

    @Override
    public V put(K key, V value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        this.removeStaleReferences();
        ReferenceKey<K> entryKey = this.entryKey(key);
        V oldValue = this.map.put(entryKey, value);
        if (oldValue != null) {
            entryKey.clear();
        }
        return oldValue;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        this.removeStaleReferences();
        ReferenceKey<K> entryKey = this.entryKey(key);
        V oldValue = this.map.putIfAbsent(entryKey, value);
        if (oldValue != null) {
            entryKey.clear();
        }
        return oldValue;
    }

    @Override
    public void clear() {
        this.removeStaleReferences();
        this.map.clear();
    }

    @Override
    public V remove(Object key) {
        this.removeStaleReferences();
        return this.map.remove(this.lookupKey(key));
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.removeStaleReferences();
        return this.map.remove(this.lookupKey(key), value);
    }

    private void removeStaleReferences() {
        Reference<K> key;
        while ((key = this.stale.poll()) != null) {
            this.map.remove(key);
        }
    }

    @Override
    public void forEach(final BiConsumer<? super K, ? super V> action) {
        this.removeStaleReferences();
        this.map.forEach(new BiConsumer<ReferenceKey<K>, V>(this){
            final /* synthetic */ ConcurrentWeakIdentityHashMap this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(ReferenceKey<K> refKey, V value) {
                Object key = refKey.get();
                if (key == null) {
                    return;
                }
                action.accept(key, value);
            }
        });
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw ConcurrentWeakIdentityHashMap.unsupported();
    }

    @Override
    public int size() {
        throw ConcurrentWeakIdentityHashMap.unsupported();
    }

    @Override
    public boolean isEmpty() {
        throw ConcurrentWeakIdentityHashMap.unsupported();
    }

    @Override
    public Set<K> keySet() {
        throw ConcurrentWeakIdentityHashMap.unsupported();
    }

    @Override
    public Collection<V> values() {
        throw ConcurrentWeakIdentityHashMap.unsupported();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw ConcurrentWeakIdentityHashMap.unsupported();
    }

    @CompilerDirectives.TruffleBoundary
    private static UnsupportedOperationException unsupported() {
        throw new UnsupportedOperationException();
    }
}

