/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.CleanableWeakReference;
import com.oracle.truffle.polyglot.enterprise.EnterpriseEngineAccessor;
import com.oracle.truffle.polyglot.enterprise.EnterpriseEngineOptions;
import com.oracle.truffle.polyglot.enterprise.EnterprisePolyglotImpl;
import com.oracle.truffle.polyglot.enterprise.GuestHostLanguage;
import com.oracle.truffle.polyglot.enterprise.HSHostLanguageService;
import com.oracle.truffle.polyglot.enterprise.HSPolyglotHostService;
import com.oracle.truffle.polyglot.enterprise.HSPolyglotHostServiceGen;
import com.oracle.truffle.polyglot.enterprise.IsolateSourceCache;
import com.oracle.truffle.polyglot.enterprise.PolyglotHostServices;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolate;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateServices;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.nativebridge.NativeObjectHandles;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.RuntimeOptions;
import org.graalvm.nativeimage.VMRuntime;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.options.OptionMap;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.SandboxPolicy;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.MessageTransport;
import org.graalvm.polyglot.io.ProcessHandler;
import org.graalvm.word.WordFactory;

final class GuestPolyglotIsolateServices
implements PolyglotIsolateServices {
    private static final Map<String, String> XOPTIONS;
    private static final String HEAP_DUMP_PREFIX = "polyglotisolate-heapdump-";
    private static final String HEAP_DUMP_EXT = ".hprof";
    private static final Object GUARD_TARGETS;
    private final AbstractPolyglotImpl polyglot;

    GuestPolyglotIsolateServices(AbstractPolyglotImpl abstractPolyglotImpl) {
        this.polyglot = abstractPolyglotImpl;
    }

    @Override
    public void initialize(PolyglotHostServices polyglotHostServices, String string) {
        RuntimeOptions.set((String)"EnableSignalHandling", (Object)false);
        RuntimeOptions.set((String)"InstallSegfaultHandler", (Object)false);
        if (string != null) {
            System.setProperty("polyglot.engine.resourcePath", string);
        }
        PolyglotIsolate.Lazy lazy = new PolyglotIsolate.Lazy(JNIMethodScope.env(), polyglotHostServices);
        if (PolyglotIsolate.lazy != null) {
            throw new IllegalStateException("PolyglotIsolate.lazy is already set.");
        }
        PolyglotIsolate.lazy = lazy;
        EnterpriseEngineAccessor.ENGINE.setIsolatePolyglot((AbstractPolyglotImpl)EnterprisePolyglotImpl.instance);
    }

    @Override
    public long buildEngine(String[] stringArray, SandboxPolicy sandboxPolicy, OutputStream outputStream, OutputStream outputStream2, InputStream inputStream, Map<String, String> map, boolean bl, boolean bl2, MessageTransport messageTransport, AbstractPolyglotImpl.LogHandler logHandler, Object object) {
        GuestHostLanguage guestHostLanguage = new GuestHostLanguage(this.polyglot, JNIMethodScope.env());
        HSPolyglotHostService hSPolyglotHostService = HSPolyglotHostServiceGen.createNativeToHS(null, this.polyglot, JNIMethodScope.env());
        hSPolyglotHostService.bindToEndpoint(JNIMethodScope.env(), (JNI.JObject)WordFactory.pointer((long)((Long)object)));
        Engine engine = this.polyglot.buildEngine(stringArray, sandboxPolicy, outputStream, outputStream2, inputStream, map, bl, bl2, messageTransport, (Object)logHandler, (Object)guestHostLanguage, false, false, (Object)hSPolyglotHostService);
        Object object2 = this.polyglot.getAPIAccess().getEngineReceiver((Object)engine);
        GuestPolyglotIsolateServices.setVMOptions(sandboxPolicy, object2);
        long l2 = NativeObjectHandles.create((Object)new EngineHolder(engine));
        PolyglotIsolate.registerEngine(object2, l2);
        return l2;
    }

    private static void setVMOptions(SandboxPolicy sandboxPolicy, Object object) {
        long l2;
        Object object2;
        OptionValues optionValues = EnterpriseEngineAccessor.ENGINE.getEngineOptionValues(object);
        Set set = ((OptionMap)optionValues.get(EnterpriseEngineOptions.IsolateOption)).entrySet();
        assert (SandboxPolicy.CONSTRAINED.isStricterOrEqual(sandboxPolicy) || set.isEmpty()) : "SandboxPolicy ISOLATED or UNTRUSTED must not have vm options.";
        if (!set.isEmpty()) {
            for (Map.Entry entry : set) {
                Object object3;
                object2 = (String)entry.getKey();
                String string = XOPTIONS.getOrDefault(object2, (String)object2);
                RuntimeOptions.Descriptor descriptor2 = RuntimeOptions.getDescriptor((String)string);
                if (descriptor2 == null) {
                    object3 = new ArrayList();
                    RuntimeOptions.listDescriptors().forEach(descriptor -> object3.add(descriptor.name()));
                    throw new IllegalArgumentException(String.format("Unknown option %s. Supported options: %s", string, String.join((CharSequence)", ", (Iterable<? extends CharSequence>)object3)));
                }
                try {
                    object3 = descriptor2.convertValue((String)entry.getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException(String.format("Failed to parse %s option. %s", object2, illegalArgumentException.getMessage()));
                }
                RuntimeOptions.set((String)string, (Object)object3);
            }
        }
        if ((l2 = ((Long)optionValues.get(EnterpriseEngineOptions.MaxIsolateMemory)).longValue()) != -1L) {
            RuntimeOptions.set((String)"MaxHeapSize", (Object)l2);
        }
        if ((object2 = (EnterpriseEngineOptions.UntrustedCodeMitigationPolicy)((Object)optionValues.get(EnterpriseEngineOptions.UntrustedCodeMitigation))) == EnterpriseEngineOptions.UntrustedCodeMitigationPolicy.SOFTWARE) {
            RuntimeOptions.set((String)"SpectrePHTBarriers", (Object)GUARD_TARGETS);
            RuntimeOptions.set((String)"BlindConstants", (Object)true);
            RuntimeOptions.set((String)"MaxRuntimeCodeOffset", (Object)128);
        }
    }

    private static Object loadSpectrePHTMitigationsGuardTargets() {
        try {
            Class<Enum> clazz = Class.forName("jdk.graal.compiler.core.common.SpectrePHTMitigations").asSubclass(Enum.class);
            for (Enum enum_ : clazz.getEnumConstants()) {
                if (!"GuardTargets".equals(enum_.name())) continue;
                return enum_;
            }
            throw new IllegalStateException("No GuardTargets constant found in the SpectrePHTMitigations enum.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }

    @Override
    public long createContext(Object object, SandboxPolicy sandboxPolicy, OutputStream outputStream, OutputStream outputStream2, InputStream inputStream, boolean bl, Object object2, Object object3, FileSystem fileSystem, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Map<String, String> map, Map<String, String[]> map2, String[] stringArray, String string, String string2, ProcessHandler processHandler, Object object4, Map<String, String> map3, ZoneId zoneId, long l2, Object object5, boolean bl8, boolean bl9, AbstractPolyglotImpl.LogHandler logHandler, Object object6) {
        Object object7;
        AbstractPolyglotImpl.IOAccessor iOAccessor;
        EngineHolder engineHolder = (EngineHolder)object;
        Engine engine = engineHolder.engine;
        AbstractPolyglotImpl.APIAccess aPIAccess = this.polyglot.getAPIAccess();
        Object object8 = aPIAccess.getEngineReceiver((Object)engine);
        AbstractPolyglotImpl.AbstractEngineDispatch abstractEngineDispatch = aPIAccess.getEngineDispatch((Object)engine);
        if (bl7 && EnterpriseEngineAccessor.ENGINE.isCreateProcessSupported() && processHandler == null) {
            throw new IllegalArgumentException("ProcessHandler must be no null when allowCreateProcess is enabled.");
        }
        Object object9 = aPIAccess.getHostAccessNone();
        if (fileSystem != null) {
            iOAccessor = this.polyglot.getIO();
            object7 = iOAccessor.createIOAccess(null, iOAccessor.hasHostFileAccess(object3), iOAccessor.hasHostSocketAccess(object3), fileSystem);
        } else {
            object7 = object3;
        }
        iOAccessor = abstractEngineDispatch.createContext(object8, engine, sandboxPolicy, outputStream, outputStream2, inputStream, bl, object9, object2, bl2, bl3, bl4, bl5, bl6, null, map, map2, stringArray, object7, (Object)logHandler, bl7, processHandler, object4, map3, zoneId, null, string, string2, null, bl8, bl9, false);
        Engine engine2 = iOAccessor.getEngine();
        Object object10 = aPIAccess.getEngineReceiver((Object)engine2);
        if (object8 != object10) {
            PolyglotIsolate.patchEngine(object8, object10);
            engineHolder.engine = engine2;
        }
        long l3 = NativeObjectHandles.create((Object)iOAccessor);
        Object object11 = aPIAccess.getContextReceiver((Object)iOAccessor);
        JNI.JNIEnv jNIEnv = JNIMethodScope.env();
        PolyglotIsolate.registerContext(jNIEnv, object11, l3, l2, (JNI.JObject)WordFactory.pointer((long)((Long)object6)));
        HSHostLanguageService hSHostLanguageService = (HSHostLanguageService)EnterpriseEngineAccessor.ENGINE.getHostService(object8);
        hSHostLanguageService.bindToContext(jNIEnv, (JNI.JObject)WordFactory.pointer((long)((Long)object5)));
        return l3;
    }

    @Override
    public Object parseEval(Object object, String string, long l2, boolean bl) {
        AbstractPolyglotImpl.APIAccess aPIAccess = this.polyglot.getAPIAccess();
        AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = aPIAccess.getContextDispatch(object);
        Object object2 = aPIAccess.getContextReceiver(object);
        Object object3 = PolyglotIsolate.getSource(l2);
        return bl ? abstractContextDispatch.eval(object2, string, object3) : abstractContextDispatch.parse(object2, string, object3);
    }

    @Override
    public void triggerGC() {
        System.gc();
        CleanableWeakReference.clean();
    }

    @Override
    public String heapDump(String string) throws IOException {
        Path path;
        if (string != null) {
            Path path2 = Paths.get(string, new String[0]);
            Files.createDirectories(path2, new FileAttribute[0]);
            path = Files.createTempFile(path2, HEAP_DUMP_PREFIX, HEAP_DUMP_EXT, new FileAttribute[0]);
        } else {
            path = Files.createTempFile(HEAP_DUMP_PREFIX, HEAP_DUMP_EXT, new FileAttribute[0]);
        }
        try {
            VMRuntime.dumpHeap((String)path.toString(), (boolean)false);
            return path.toAbsolutePath().toString();
        }
        catch (Exception exception) {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException iOException) {
                exception.addSuppressed(iOException);
            }
            throw exception;
        }
    }

    @Override
    public IsolateSourceCache getSourceCache() {
        return PolyglotIsolate.lazy.sourceCache;
    }

    @Override
    public void onIsolateTearDown() {
        PolyglotIsolate.tearDown();
    }

    @Override
    public boolean isMemoryProtected() {
        return GuestPolyglotIsolateServices.isMemoryProtected(CurrentIsolate.getCurrentThread());
    }

    @CFunction(value="truffle_isolate_isMemoryProtected")
    private static native boolean isMemoryProtected(IsolateThread var0);

    @Override
    public void ensureInstrumentCreated(Object object, String string) {
        Object object2 = this.polyglot.getAPIAccess().getContextReceiver(object);
        EnterpriseEngineAccessor.ENGINE.ensureInstrumentCreated(object2, string);
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Xms", "MinHeapSize");
        hashMap.put("Xmx", "MaxHeapSize");
        hashMap.put("Xmn", "MaxNewSize");
        hashMap.put("Xss", "StackSize");
        XOPTIONS = hashMap;
        GUARD_TARGETS = GuestPolyglotIsolateServices.loadSpectrePHTMitigationsGuardTargets();
    }

    static final class EngineHolder {
        volatile Engine engine;

        EngineHolder(Engine engine) {
            this.engine = engine;
        }
    }
}

