/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.BytecodeOSRNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInterface;
import com.oracle.truffle.runtime.BaseOSRRootNode;
import com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativeimage.ImageInfo;

final class BytecodeOSRRootNode
extends BaseOSRRootNode {
    private final long target;
    private final Object interpreterState;
    @CompilerDirectives.CompilationFinal
    private boolean seenMaterializedFrame;
    private final Object entryTagsCache;
    private static final Map<Class<?>, Boolean> usesDeprecatedTransferClasses = new ConcurrentHashMap();
    private final boolean usesDeprecatedFrameTransfer;

    BytecodeOSRRootNode(TruffleLanguage<?> language, FrameDescriptor frameDescriptor, BytecodeOSRNode bytecodeOSRNode, long target, Object interpreterState, Object entryTagsCache) {
        super(language, frameDescriptor, (NodeInterface)bytecodeOSRNode);
        this.target = target;
        this.interpreterState = interpreterState;
        this.seenMaterializedFrame = BytecodeOSRRootNode.materializeCalled(frameDescriptor);
        this.entryTagsCache = entryTagsCache;
        this.usesDeprecatedFrameTransfer = BytecodeOSRRootNode.checkUsesDeprecatedFrameTransfer(bytecodeOSRNode.getClass());
    }

    private static boolean materializeCalled(FrameDescriptor frameDescriptor) {
        return ((OptimizedTruffleRuntime)Truffle.getRuntime()).getFrameMaterializeCalled(frameDescriptor);
    }

    Object getEntryTagsCache() {
        return this.entryTagsCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeOSR(VirtualFrame frame) {
        BytecodeOSRNode osrNode = (BytecodeOSRNode)this.loopNode;
        VirtualFrame parentFrame = (VirtualFrame)osrNode.restoreParentFrameFromArguments(frame.getArguments());
        if (!this.seenMaterializedFrame && BytecodeOSRRootNode.materializeCalled(parentFrame.getFrameDescriptor())) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.seenMaterializedFrame = true;
        }
        if (this.seenMaterializedFrame) {
            return osrNode.executeOSR(parentFrame, this.target, this.interpreterState);
        }
        if (this.usesDeprecatedFrameTransfer) {
            int intTarget = (int)this.target;
            if ((long)intTarget != this.target) {
                throw CompilerDirectives.shouldNotReachHere((String)"long target cannot be used with deprecated frame transfer");
            }
            osrNode.copyIntoOSRFrame(frame, parentFrame, intTarget);
        } else {
            osrNode.copyIntoOSRFrame(frame, parentFrame, this.target, this.entryTagsCache);
        }
        try {
            Object object = osrNode.executeOSR(frame, this.target, this.interpreterState);
            return object;
        }
        finally {
            osrNode.restoreParentFrame(frame, parentFrame);
        }
    }

    public String getName() {
        return this.toString();
    }

    public String toString() {
        return ((Node)this.loopNode).getRootNode().toString() + "<OSR@" + this.target + ">";
    }

    private static boolean usesDeprecatedFrameTransfer(Class<?> osrNodeClass) {
        try {
            Method m = osrNodeClass.getMethod("copyIntoOSRFrame", VirtualFrame.class, VirtualFrame.class, Integer.TYPE);
            return m.getDeclaringClass() != BytecodeOSRNode.class;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static boolean checkUsesDeprecatedFrameTransfer(Class<?> osrNodeClass) {
        if (ImageInfo.inImageRuntimeCode()) {
            return usesDeprecatedTransferClasses.get(osrNodeClass);
        }
        return usesDeprecatedTransferClasses.computeIfAbsent(osrNodeClass, BytecodeOSRRootNode::usesDeprecatedFrameTransfer);
    }

    private static boolean initializeClassUsingDeprecatedFrameTransfer(Class<?> subType) {
        if (subType.isInterface()) {
            return false;
        }
        if (usesDeprecatedTransferClasses.containsKey(subType)) {
            return false;
        }
        usesDeprecatedTransferClasses.put(subType, BytecodeOSRRootNode.usesDeprecatedFrameTransfer(subType));
        return true;
    }
}

