/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.injection;

import grails.build.logging.GrailsConsole;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.compiler.injection.AllArtefactClassInjector;
import org.codehaus.groovy.grails.compiler.injection.AnnotatedClassInjector;
import org.codehaus.groovy.grails.compiler.injection.ArtefactTypeAstTransformation;
import org.codehaus.groovy.grails.compiler.injection.ClassInjector;
import org.codehaus.groovy.grails.compiler.injection.GrailsAwareInjectionOperation;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public abstract class AbstractArtefactTypeAstTransformation
implements ASTTransformation {
    protected void performInjectionOnArtefactType(SourceUnit sourceUnit, ClassNode cNode, String artefactType) {
        try {
            ClassInjector[] classInjectors = GrailsAwareInjectionOperation.getClassInjectors();
            List<ClassInjector> injectors = ArtefactTypeAstTransformation.findInjectors(artefactType, classInjectors);
            if (!injectors.isEmpty()) {
                for (ClassInjector injector : injectors) {
                    if (injector instanceof AllArtefactClassInjector) {
                        injector.performInjection(sourceUnit, cNode);
                        continue;
                    }
                    if (!(injector instanceof AnnotatedClassInjector)) continue;
                    ((AnnotatedClassInjector)((Object)injector)).performInjectionOnAnnotatedClass(sourceUnit, null, cNode);
                }
            }
        }
        catch (RuntimeException e) {
            GrailsConsole.getInstance().error("Error occurred calling AST injector: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

