/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins;

import groovy.util.XmlSlurper;
import groovy.util.slurpersupport.GPathResult;
import groovy.util.slurpersupport.Node;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.exceptions.GrailsConfigurationException;
import org.codehaus.groovy.grails.io.support.IOUtils;
import org.codehaus.groovy.grails.plugins.BinaryGrailsPluginDescriptor;
import org.codehaus.groovy.grails.support.ParentApplicationContextAware;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;
import org.xml.sax.SAXException;

public class CorePluginFinder
implements ParentApplicationContextAware {
    private static final Log LOG = LogFactory.getLog(CorePluginFinder.class);
    public static final String CORE_PLUGIN_PATTERN = "classpath*:META-INF/grails-plugin.xml";
    private PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    private final Set<Class<?>> foundPluginClasses = new HashSet();
    private final GrailsApplication application;
    private final Map<Class, BinaryGrailsPluginDescriptor> binaryDescriptors = new HashMap<Class, BinaryGrailsPluginDescriptor>();

    public CorePluginFinder(GrailsApplication application) {
        this.application = application;
    }

    public Class<?>[] getPluginClasses() {
        this.foundPluginClasses.clear();
        try {
            Resource[] resources = this.resolvePluginResources();
            if (resources.length > 0) {
                this.loadCorePluginsFromResources(resources);
            } else {
                LOG.warn((Object)"WARNING: Grails was unable to load core plugins dynamically. This is normally a problem with the container class loader configuration, see troubleshooting and FAQ for more info. ");
                this.loadCorePluginsStatically();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("WARNING: I/O exception loading core plugin dynamically, attempting static load. This is usually due to deployment onto containers with unusual classloading setups. Message: " + e.getMessage()));
            this.loadCorePluginsStatically();
        }
        return this.foundPluginClasses.toArray(new Class[this.foundPluginClasses.size()]);
    }

    public BinaryGrailsPluginDescriptor getBinaryDescriptor(Class<?> pluginClass) {
        return this.binaryDescriptors.get(pluginClass);
    }

    private Resource[] resolvePluginResources() throws IOException {
        return this.resolver.getResources(CORE_PLUGIN_PATTERN);
    }

    private void loadCorePluginsStatically() {
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.CoreGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.log4j.LoggingGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.CodecsGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.i18n.I18nGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.datasource.DataSourceGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.DomainClassGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.ValidationGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.web.ServletsGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.web.ControllersGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.web.GroovyPagesGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.web.mapping.UrlMappingsGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.web.filters.FiltersGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.web.mimes.MimeTypesGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.services.ServicesGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.converters.ConvertersGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.databinding.DataBindingGrailsPlugin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCorePluginsFromResources(Resource[] resources) throws IOException {
        LOG.debug((Object)("Attempting to load [" + resources.length + "] core plugins"));
        try {
            XmlSlurper slurper = IOUtils.createXmlSlurper();
            for (Resource resource : resources) {
                InputStream input = null;
                try {
                    input = resource.getInputStream();
                    GPathResult result = slurper.parse(input);
                    GPathResult pluginClass = (GPathResult)result.getProperty("type");
                    if (pluginClass.size() == 1) {
                        String pluginClassName = pluginClass.text();
                        if (!StringUtils.hasText((String)pluginClassName)) continue;
                        this.loadCorePlugin(pluginClassName, resource, result);
                        continue;
                    }
                    Iterator iterator = pluginClass.nodeIterator();
                    while (iterator.hasNext()) {
                        Node node = (Node)iterator.next();
                        String pluginClassName = node.text();
                        if (!StringUtils.hasText((String)pluginClassName)) continue;
                        this.loadCorePlugin(pluginClassName, resource, result);
                    }
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                }
            }
        }
        catch (ParserConfigurationException e) {
            throw new GrailsConfigurationException("XML parsing error loading core plugins: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new GrailsConfigurationException("XML parsing error loading core plugins: " + e.getMessage(), e);
        }
    }

    private void loadCorePlugin(String pluginClassName, Resource resource, GPathResult result) {
        Class<?> pluginClass = this.attemptCorePluginClassLoad(pluginClassName);
        if (pluginClass != null) {
            this.addPlugin(pluginClass);
            this.binaryDescriptors.put(pluginClass, new BinaryGrailsPluginDescriptor(resource, result));
        }
    }

    private Class<?> attemptCorePluginClassLoad(String pluginClassName) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader.loadClass(pluginClassName);
        }
        catch (ClassNotFoundException e) {
            LOG.warn((Object)("[GrailsPluginManager] Core plugin [" + pluginClassName + "] not found, resuming load without.."));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    private void loadCorePlugin(String pluginClassName) {
        this.loadCorePlugin(pluginClassName, null, null);
    }

    private void addPlugin(Class<?> plugin) {
        this.foundPluginClasses.add(plugin);
    }

    @Override
    public void setParentApplicationContext(ApplicationContext parent) {
        if (parent != null) {
            this.resolver = new PathMatchingResourcePatternResolver((ResourceLoader)parent);
        }
    }
}

