/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.support;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.grails.support.GrailsByteArrayResource;
import org.codehaus.groovy.grails.support.MockResourceLoader;
import org.springframework.core.io.Resource;

public class MockStringResourceLoader
extends MockResourceLoader {
    private Map<String, Resource> mockResources = new HashMap<String, Resource>();

    @Override
    public Resource getResource(String location) {
        if (this.mockResources.containsKey(location)) {
            return this.mockResources.get(location);
        }
        return super.getResource(location);
    }

    public void registerMockResource(String location, Resource res) {
        this.mockResources.put(location, res);
    }

    public void registerMockResource(String location, String contents) {
        try {
            this.mockResources.put(location, (Resource)new GrailsByteArrayResource(contents.getBytes("UTF-8"), location));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerMockResource(String location, byte[] contents) {
        this.mockResources.put(location, (Resource)new GrailsByteArrayResource(contents, location));
    }
}

