/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.algorithm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.graphwalker.core.algorithm.Algorithm;
import org.graphwalker.core.algorithm.AlgorithmException;
import org.graphwalker.core.algorithm.FloydWarshall;
import org.graphwalker.core.common.Objects;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Path;

public class AStar
implements Algorithm {
    private final Context context;

    public AStar(Context context) {
        this.context = context;
    }

    public Element getNextElement(Element origin, Element destination) {
        AStarNode result;
        HashMap<Element, AStarNode> openSet = new HashMap<Element, AStarNode>();
        PriorityQueue<AStarNode> queue = new PriorityQueue<AStarNode>(10, new AStarNodeComparator());
        HashMap<Element, AStarNode> closeSet = new HashMap<Element, AStarNode>();
        FloydWarshall floydWarshall = this.context.getAlgorithm(FloydWarshall.class);
        AStarNode sourceNode = new AStarNode(origin, 0.0, floydWarshall.getShortestDistance(origin, destination));
        openSet.put(origin, sourceNode);
        queue.add(sourceNode);
        AStarNode node = queue.poll();
        if (node == null) {
            throw new AlgorithmException();
        }
        if (node.getElement().equals(destination)) {
            return node.getElement();
        }
        closeSet.put(node.getElement(), node);
        List<Element> neighbors = this.context.filter(this.context.getModel().getElements(node.getElement()));
        this.calculate(destination, openSet, queue, closeSet, floydWarshall, node, neighbors);
        if (!queue.isEmpty() && null != (result = queue.poll())) {
            return result.getElement();
        }
        throw new AlgorithmException();
    }

    private void calculate(Element destination, Map<Element, AStarNode> openSet, PriorityQueue<AStarNode> queue, Map<Element, AStarNode> closeSet, FloydWarshall floydWarshall, AStarNode node, List<Element> neighbors) {
        for (Element neighbor : neighbors) {
            AStarNode visited = closeSet.get(neighbor);
            if (!Objects.isNull(visited)) continue;
            double g = node.getG() + (double)floydWarshall.getShortestDistance(node.getElement(), neighbor);
            AStarNode neighborNode = openSet.get(neighbor);
            if (Objects.isNull(neighborNode)) {
                neighborNode = new AStarNode(neighbor, g, floydWarshall.getShortestDistance(neighbor, destination));
                neighborNode.setParent(node);
                openSet.put(neighbor, neighborNode);
                queue.add(neighborNode);
                continue;
            }
            if (!(g < neighborNode.getG())) continue;
            neighborNode.setParent(node);
            neighborNode.setG(g);
            neighborNode.setH(floydWarshall.getShortestDistance(neighbor, destination));
        }
    }

    public Path<Element> getShortestPath(Element origin, Element destination) {
        HashMap<Element, AStarNode> openSet = new HashMap<Element, AStarNode>();
        PriorityQueue<AStarNode> queue = new PriorityQueue<AStarNode>(10, new AStarNodeComparator());
        HashMap<Element, AStarNode> closeSet = new HashMap<Element, AStarNode>();
        FloydWarshall floydWarshall = this.context.getAlgorithm(FloydWarshall.class);
        AStarNode sourceNode = new AStarNode(origin, 0.0, floydWarshall.getShortestDistance(origin, destination));
        openSet.put(origin, sourceNode);
        queue.add(sourceNode);
        AStarNode targetNode = null;
        while (openSet.size() > 0) {
            AStarNode node = queue.poll();
            if (null == node) continue;
            openSet.remove(node.getElement());
            if (node.getElement().equals(destination)) {
                targetNode = node;
                break;
            }
            closeSet.put(node.getElement(), node);
            List<Element> neighbors = this.context.filter(this.context.getModel().getElements(node.getElement()));
            this.calculate(destination, openSet, queue, closeSet, floydWarshall, node, neighbors);
        }
        if (Objects.isNotNull(targetNode)) {
            ArrayList<Element> path = new ArrayList<Element>();
            path.add(targetNode.getElement());
            AStarNode node = targetNode.getParent();
            while (Objects.isNotNull(node)) {
                path.add(node.getElement());
                node = node.getParent();
            }
            Collections.reverse(path);
            return new Path<Element>((Collection<Element>)path);
        }
        throw new AlgorithmException();
    }

    private class AStarNodeComparator
    implements Comparator<AStarNode> {
        private AStarNodeComparator() {
        }

        @Override
        public int compare(AStarNode first, AStarNode second) {
            if (first.getF() < second.getF()) {
                return -1;
            }
            if (first.getF() > second.getF()) {
                return 1;
            }
            return 0;
        }
    }

    private class AStarNode {
        private final Element element;
        private AStarNode parent;
        private double g;
        private double h;

        AStarNode(Element element, double g, double h) {
            this.element = element;
            this.g = g;
            this.h = h;
        }

        private Element getElement() {
            return this.element;
        }

        private AStarNode getParent() {
            return this.parent;
        }

        private void setParent(AStarNode parent) {
            this.parent = parent;
        }

        private double getG() {
            return this.g;
        }

        private void setG(double g) {
            this.g = g;
        }

        private void setH(double h) {
            this.h = h;
        }

        public double getF() {
            return this.g + this.h;
        }
    }
}

