/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.algorithm;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graphwalker.core.algorithm.Algorithm;
import org.graphwalker.core.common.Objects;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Vertex;

public class DepthFirstSearch
implements Algorithm {
    private final Context context;

    public DepthFirstSearch(Context context) {
        this.context = context;
    }

    public List<Element> getConnectedComponent(Element root) {
        return this.createConnectedComponent(this.createElementStatusMap(this.context.getModel().getElements()), root);
    }

    private Map<Element, ElementStatus> createElementStatusMap(List<Element> elements) {
        HashMap<Element, ElementStatus> elementStatusMap = new HashMap<Element, ElementStatus>();
        for (Element element : elements) {
            elementStatusMap.put(element, ElementStatus.UNREACHABLE);
        }
        return elementStatusMap;
    }

    private List<Element> createConnectedComponent(Map<Element, ElementStatus> elementStatusMap, Element root) {
        ArrayList<Element> connectedComponent = new ArrayList<Element>();
        ArrayDeque<Element> stack = new ArrayDeque<Element>();
        stack.push(root);
        while (!stack.isEmpty()) {
            Element element = (Element)stack.pop();
            if (!ElementStatus.UNREACHABLE.equals((Object)elementStatusMap.get(element))) continue;
            connectedComponent.add(element);
            elementStatusMap.put(element, ElementStatus.REACHABLE);
            if (element instanceof Vertex.RuntimeVertex) {
                Vertex.RuntimeVertex vertex = (Vertex.RuntimeVertex)element;
                for (Edge.RuntimeEdge edge : this.context.getModel().getOutEdges(vertex)) {
                    stack.push(edge);
                }
                continue;
            }
            if (!(element instanceof Edge.RuntimeEdge)) continue;
            Edge.RuntimeEdge edge = (Edge.RuntimeEdge)element;
            stack.push(edge.getTargetVertex());
        }
        return Objects.unmodifiableList(connectedComponent);
    }

    private static enum ElementStatus {
        UNREACHABLE,
        REACHABLE;

    }
}

