/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.algorithm;

import java.util.HashMap;
import java.util.Map;
import org.graphwalker.core.algorithm.Algorithm;
import org.graphwalker.core.algorithm.AlgorithmException;
import org.graphwalker.core.algorithm.Fleury;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Path;
import org.graphwalker.core.model.Vertex;

public class Eulerian
implements Algorithm {
    private final Context context;
    private final Map<Vertex.RuntimeVertex, PolarityCounter> polarities;

    public Eulerian(Context context) {
        this.context = context;
        this.polarities = new HashMap<Vertex.RuntimeVertex, PolarityCounter>(context.getModel().getVertices().size());
        this.polarize();
    }

    private void polarize() {
        for (Edge.RuntimeEdge edge : this.context.getModel().getEdges()) {
            this.getPolarityCounter(edge.getSourceVertex()).decrease();
            this.getPolarityCounter(edge.getTargetVertex()).increase();
        }
        for (Vertex.RuntimeVertex vertex : this.context.getModel().getVertices()) {
            if (this.polarities.get(vertex).hasPolarity()) continue;
            this.polarities.remove(vertex);
        }
    }

    private PolarityCounter getPolarityCounter(Vertex.RuntimeVertex vertex) {
        if (!this.polarities.containsKey(vertex)) {
            this.polarities.put(vertex, new PolarityCounter());
        }
        return this.polarities.get(vertex);
    }

    public EulerianType getEulerianType() {
        if (this.polarities.isEmpty()) {
            return EulerianType.EULERIAN;
        }
        if (2 == this.polarities.size()) {
            return EulerianType.SEMI_EULERIAN;
        }
        return EulerianType.NOT_EULERIAN;
    }

    public Path<Element> getEulerPath(Element element) {
        if (EulerianType.NOT_EULERIAN.equals((Object)this.getEulerianType())) {
            throw new AlgorithmException("The model is not eulerian or semi eulerian, no single path can cover the entire graph");
        }
        return this.context.getAlgorithm(Fleury.class).getTrail(element);
    }

    class PolarityCounter {
        private int polarity = 0;

        PolarityCounter() {
        }

        public void increase() {
            ++this.polarity;
        }

        public void decrease() {
            --this.polarity;
        }

        public boolean hasPolarity() {
            return 0 != this.getPolarity();
        }

        public int getPolarity() {
            return this.polarity;
        }
    }

    public static enum EulerianType {
        EULERIAN,
        SEMI_EULERIAN,
        NOT_EULERIAN;

    }
}

