/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.algorithm;

import java.util.Arrays;
import java.util.List;
import org.graphwalker.core.algorithm.Algorithm;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Model;
import org.graphwalker.core.model.Vertex;

public class FloydWarshall
implements Algorithm {
    private final Model.RuntimeModel model;
    private final int[][] distances;

    public FloydWarshall(Context context) {
        this.model = context.getModel();
        this.distances = this.createDistanceMatrix(this.model, this.model.getElements());
        this.createPredecessorMatrix(this.model.getElements(), this.distances);
    }

    private int[][] createDistanceMatrix(Model.RuntimeModel model, List<Element> elements) {
        int[][] distances = new int[elements.size()][elements.size()];
        for (int[] row : distances) {
            Arrays.fill(row, Integer.MAX_VALUE);
        }
        Object object = elements.iterator();
        while (object.hasNext()) {
            Element element = (Element)object.next();
            if (element instanceof Edge.RuntimeEdge) {
                Edge.RuntimeEdge edge = (Edge.RuntimeEdge)element;
                Vertex.RuntimeVertex target = edge.getTargetVertex();
                distances[elements.indexOf((Object)edge)][elements.indexOf((Object)target)] = 1;
                continue;
            }
            if (!(element instanceof Vertex.RuntimeVertex)) continue;
            Vertex.RuntimeVertex vertex = (Vertex.RuntimeVertex)element;
            for (Edge.RuntimeEdge edge : model.getOutEdges(vertex)) {
                distances[elements.indexOf((Object)vertex)][elements.indexOf((Object)edge)] = 1;
            }
        }
        return distances;
    }

    private Element[][] createPredecessorMatrix(List<Element> elements, int[][] distances) {
        Element[][] predecessors = new Element[elements.size()][elements.size()];
        int size = elements.size();
        for (int k = 0; k < size; ++k) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    if (distances[i][k] == Integer.MAX_VALUE || distances[k][j] == Integer.MAX_VALUE || distances[i][k] + distances[k][j] >= distances[i][j]) continue;
                    distances[i][j] = distances[i][k] + distances[k][j];
                    predecessors[i][j] = elements.get(k);
                }
            }
        }
        return predecessors;
    }

    public int getShortestDistance(Element origin, Element destination) {
        if (!this.model.getElements().contains(destination)) {
            return Integer.MAX_VALUE;
        }
        if (origin.equals(destination)) {
            return 0;
        }
        return this.distances[this.model.getElements().indexOf(origin)][this.model.getElements().indexOf(destination)];
    }

    public int getMaximumDistance(Element destination) {
        int maximumDistance = Integer.MIN_VALUE;
        for (int[] distance : this.distances) {
            int value = distance[this.model.getElements().indexOf(destination)];
            if (value == Integer.MAX_VALUE || value <= maximumDistance) continue;
            maximumDistance = value;
        }
        return maximumDistance;
    }
}

