/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.condition;

import org.graphwalker.core.condition.CoverageStopConditionBase;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Element;

public class EdgeCoverage
extends CoverageStopConditionBase {
    public EdgeCoverage(int percent) {
        super(percent);
    }

    @Override
    public boolean isFulfilled() {
        return this.getFulfilment() >= 0.999999 && super.isFulfilled();
    }

    @Override
    public double getFulfilment() {
        Context context = this.getContext();
        long totalEdgesCount = context.getModel().getEdges().size();
        long visitedEdgesCount = context.getModel().getEdges().stream().filter(edge -> context.getProfiler().isVisited(context, (Element)edge)).count();
        return (double)visitedEdgesCount / (double)totalEdgesCount / this.getPercentAsDouble();
    }
}

