/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.condition;

import org.graphwalker.core.algorithm.FloydWarshall;
import org.graphwalker.core.common.Objects;
import org.graphwalker.core.condition.ReachedStopCondition;
import org.graphwalker.core.condition.StopConditionBase;
import org.graphwalker.core.condition.StopConditionException;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Element;

public abstract class ReachedStopConditionBase
extends StopConditionBase
implements ReachedStopCondition {
    private boolean fulfilled = false;

    protected ReachedStopConditionBase(String value) {
        super(value);
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        this.validate(context);
    }

    protected void validate(Context context) {
        if (Objects.isNotNull(context) && Objects.isNull(context.getModel())) {
            throw new StopConditionException("Context missing a model");
        }
    }

    @Override
    public boolean isFulfilled() {
        if (this.fulfilled) {
            return true;
        }
        this.fulfilled = this.getFulfilment() >= 0.999999;
        return this.fulfilled;
    }

    @Override
    public double getFulfilment() {
        Context context = this.getContext();
        double maxFulfilment = 0.0;
        if (Objects.isNotNull(context.getCurrentElement())) {
            FloydWarshall floydWarshall = context.getAlgorithm(FloydWarshall.class);
            for (Element target : this.getTargetElements()) {
                int max;
                int distance = floydWarshall.getShortestDistance(context.getCurrentElement(), target);
                double fulfilment = 1.0 - (double)distance / (double)(max = floydWarshall.getMaximumDistance(target));
                if (!(maxFulfilment < fulfilment)) continue;
                maxFulfilment = fulfilment;
            }
        }
        return maxFulfilment;
    }
}

