/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.condition;

import org.graphwalker.core.condition.CoverageStopConditionBase;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.machine.RequirementStatus;

public class RequirementCoverage
extends CoverageStopConditionBase {
    public RequirementCoverage(int percent) {
        super(percent);
    }

    @Override
    public boolean isFulfilled() {
        return this.getFulfilment() >= 0.999999 && super.isFulfilled();
    }

    @Override
    public double getFulfilment() {
        Context context = this.getContext();
        double totalCount = context.getRequirements().size();
        if (0.0 == totalCount) {
            return 1.0;
        }
        double passedCount = context.getRequirements(RequirementStatus.PASSED).size();
        double failedCount = context.getRequirements(RequirementStatus.FAILED).size();
        return (passedCount + failedCount) / totalCount / this.getPercentAsDouble();
    }
}

