/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graphwalker.core.algorithm.AStar;
import org.graphwalker.core.common.Objects;
import org.graphwalker.core.condition.StopCondition;
import org.graphwalker.core.generator.NoPathFoundException;
import org.graphwalker.core.generator.PathGeneratorBase;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.statistics.Profiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickRandomPath
extends PathGeneratorBase<StopCondition> {
    private static final Logger LOG = LoggerFactory.getLogger(QuickRandomPath.class);
    private final List<Element> elements = new ArrayList<Element>();
    private Element target = null;

    public QuickRandomPath(StopCondition stopCondition) {
        this.setStopCondition(stopCondition);
    }

    @Override
    public Context getNextStep() {
        Context context = super.getNextStep();
        if (this.elements.isEmpty()) {
            this.elements.addAll(context.getModel().getElements());
            this.elements.remove(context.getCurrentElement());
            Collections.shuffle(this.elements);
        }
        if (Objects.isNull(this.target) || this.target.equals(context.getCurrentElement())) {
            if (this.elements.isEmpty()) {
                throw new NoPathFoundException(context.getCurrentElement());
            }
            this.orderElementsUnvisitedFirst(this.elements);
            this.target = this.elements.get(0);
            LOG.debug("New selected target is: {} - {}", (Object)this.target.getId(), (Object)this.target.getName());
        }
        Element nextElement = context.getAlgorithm(AStar.class).getNextElement(context.getCurrentElement(), this.target);
        this.elements.remove(nextElement);
        return context.setCurrentElement(nextElement);
    }

    private void orderElementsUnvisitedFirst(List<Element> elements) {
        Context context = this.getContext();
        Profiler profiler = context.getProfiler();
        if (Objects.isNotNull(profiler)) {
            elements.sort((a, b) -> Boolean.compare(profiler.isVisited(context, (Element)a), profiler.isVisited(context, (Element)b)));
        }
    }

    @Override
    public boolean hasNextStep() {
        return !this.getStopCondition().isFulfilled();
    }
}

