/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.generator;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.graphwalker.core.condition.StopCondition;
import org.graphwalker.core.generator.NoPathFoundException;
import org.graphwalker.core.generator.PathGeneratorBase;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.machine.MachineException;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Vertex;

public class WeightedRandomPath
extends PathGeneratorBase<StopCondition> {
    private final Random random = new Random(System.nanoTime());

    public WeightedRandomPath(StopCondition stopCondition) {
        this.setStopCondition(stopCondition);
    }

    @Override
    public Context getNextStep() {
        Context context = super.getNextStep();
        Element currentElement = context.getCurrentElement();
        List<Element> elements = context.filter(context.getModel().getElements(currentElement));
        if (elements.isEmpty()) {
            throw new NoPathFoundException(context.getCurrentElement());
        }
        if (currentElement instanceof Vertex.RuntimeVertex) {
            context.setCurrentElement(this.getWeightedEdge(elements, currentElement));
        } else {
            context.setCurrentElement(elements.get(this.random.nextInt(elements.size())));
        }
        return context;
    }

    @Override
    public boolean hasNextStep() {
        return !this.getStopCondition().isFulfilled();
    }

    private Element getWeightedEdge(List<Element> elements, Element currentElement) {
        HashMap<Edge.RuntimeEdge, Double> probabilities = new HashMap<Edge.RuntimeEdge, Double>();
        int numberOfZeros = 0;
        double sum = 0.0;
        for (Element element : elements) {
            if (!(element instanceof Edge.RuntimeEdge)) continue;
            Edge.RuntimeEdge edge = (Edge.RuntimeEdge)element;
            if (edge.getWeight() > 0.0) {
                probabilities.put(edge, edge.getWeight());
                if (!((sum += edge.getWeight().doubleValue()) > 1.0)) continue;
                throw new MachineException("The sum of all weights in edges from vertex: '" + currentElement.getName() + "', adds up to more than 1.00");
            }
            ++numberOfZeros;
            probabilities.put(edge, 0.0);
        }
        double rest = numberOfZeros > 0 ? (1.0 - sum) / (double)numberOfZeros : 1.0 - sum;
        int index = this.random.nextInt(100);
        double weight = 0.0;
        for (Element element : elements) {
            if (!(element instanceof Edge.RuntimeEdge)) continue;
            Edge.RuntimeEdge edge = (Edge.RuntimeEdge)element;
            if ((Double)probabilities.get(edge) == 0.0) {
                probabilities.put(edge, rest);
            }
            if (!((double)index < (weight += (Double)probabilities.get(edge) * 100.0))) continue;
            return edge;
        }
        throw new MachineException("Could not calculate which weighted edge to choose from vertex: " + currentElement.getName() + "'");
    }
}

