/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.machine;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.graphwalker.core.algorithm.Algorithm;
import org.graphwalker.core.common.Objects;
import org.graphwalker.core.generator.PathGenerator;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.machine.ExecutionStatus;
import org.graphwalker.core.machine.MachineException;
import org.graphwalker.core.machine.RequirementStatus;
import org.graphwalker.core.model.Action;
import org.graphwalker.core.model.Builder;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Model;
import org.graphwalker.core.model.Requirement;
import org.graphwalker.core.statistics.Profiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutionContext
extends SimpleScriptContext
implements Context {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionContext.class);
    private static final String DEFAULT_SCRIPT_LANGUAGE = "JavaScript";
    private ScriptEngine scriptEngine;
    private Model.RuntimeModel model;
    private PathGenerator pathGenerator;
    private Profiler profiler;
    private ExecutionStatus executionStatus = ExecutionStatus.NOT_EXECUTED;
    private Element currentElement;
    private Element nextElement;
    private Element lastElement;
    private final Map<Class<? extends Algorithm>, Object> algorithms = new HashMap<Class<? extends Algorithm>, Object>();
    private final Map<Requirement, RequirementStatus> requirements = new HashMap<Requirement, RequirementStatus>();

    public ExecutionContext() {
        ScriptEngine engine = this.getEngineByName();
        engine.setContext(this);
        String script = "";
        Compilable compiler = (Compilable)((Object)engine);
        for (Method method : this.getClass().getMethods()) {
            String arguments = "";
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                if (i > 0) {
                    arguments = arguments + ",";
                }
                arguments = arguments + Character.toChars(65 + i)[0];
            }
            script = script + "function " + method.getName() + "(" + arguments;
            script = script + ") { return impl." + method.getName() + "(" + arguments + ");};";
        }
        try {
            CompiledScript compiledScript = compiler.compile(script);
            Bindings bindings = engine.getBindings(100);
            bindings.put("impl", (Object)this);
            compiledScript.eval(bindings);
            this.scriptEngine = compiledScript.getEngine();
        }
        catch (ScriptException e) {
            LOG.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private ScriptEngine getEngineByName() {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName(DEFAULT_SCRIPT_LANGUAGE);
        if (null == engine) {
            throw new MachineException("Failed to create ScriptEngine");
        }
        return engine;
    }

    public ExecutionContext(Model model, PathGenerator pathGenerator) {
        this(model.build(), pathGenerator);
    }

    public ExecutionContext(Model.RuntimeModel model, PathGenerator pathGenerator) {
        this();
        this.setModel(model);
        this.setPathGenerator(pathGenerator);
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    @Override
    public Model.RuntimeModel getModel() {
        return this.model;
    }

    @Override
    public Context setModel(Model.RuntimeModel model) {
        this.model = model;
        this.addRequirements(model);
        return this;
    }

    private void addRequirements(Model.RuntimeModel model) {
        this.requirements.clear();
        for (Requirement requirement : model.getRequirements()) {
            this.requirements.put(requirement, RequirementStatus.NOT_COVERED);
        }
        for (Element element : model.getElements()) {
            for (Requirement requirement : element.getRequirements()) {
                this.requirements.put(requirement, RequirementStatus.NOT_COVERED);
            }
        }
    }

    @Override
    public Profiler getProfiler() {
        return this.profiler;
    }

    @Override
    public Context setProfiler(Profiler profiler) {
        this.profiler = profiler;
        this.profiler.addContext(this);
        return this;
    }

    @Override
    public PathGenerator getPathGenerator() {
        return this.pathGenerator;
    }

    @Override
    public Context setPathGenerator(PathGenerator pathGenerator) {
        this.pathGenerator = pathGenerator;
        if (Objects.isNotNull(pathGenerator)) {
            this.pathGenerator.setContext(this);
        }
        return this;
    }

    @Override
    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    @Override
    public Context setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
        return this;
    }

    @Override
    public Element getLastElement() {
        return this.lastElement;
    }

    @Override
    public Element getCurrentElement() {
        return this.currentElement;
    }

    @Override
    public Context setCurrentElement(Element element) {
        this.lastElement = this.currentElement;
        this.currentElement = element;
        this.nextElement = null;
        return this;
    }

    @Override
    public Element getNextElement() {
        return this.nextElement;
    }

    @Override
    public Context setNextElement(Builder<? extends Element> nextElement) {
        this.setNextElement(nextElement.build());
        return this;
    }

    @Override
    public Context setNextElement(Element nextElement) {
        this.nextElement = nextElement;
        this.currentElement = null;
        return this;
    }

    @Override
    public Context setRequirementStatus(Requirement requirement, RequirementStatus requirementStatus) {
        this.requirements.put(requirement, requirementStatus);
        return this;
    }

    @Override
    public List<Requirement> getRequirements() {
        return new ArrayList<Requirement>(this.requirements.keySet());
    }

    @Override
    public List<Requirement> getRequirements(RequirementStatus status) {
        ArrayList<Requirement> filteredRequirements = new ArrayList<Requirement>();
        for (Requirement requirement : this.requirements.keySet()) {
            if (!status.equals((Object)this.requirements.get(requirement))) continue;
            filteredRequirements.add(requirement);
        }
        return filteredRequirements;
    }

    @Override
    public <A extends Algorithm> A getAlgorithm(Class<A> clazz) {
        if (!this.algorithms.containsKey(clazz)) {
            try {
                Constructor<A> constructor = clazz.getConstructor(Context.class);
                this.algorithms.put(clazz, constructor.newInstance(this));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOG.error(e.getMessage());
                throw new MachineException(this, (Throwable)e);
            }
        }
        return (A)((Algorithm)this.algorithms.get(clazz));
    }

    @Override
    public <E> List<E> filter(Collection<E> elements) {
        ArrayList<E> filteredElements = new ArrayList<E>();
        if (Objects.isNotNull(elements)) {
            for (E element : elements) {
                if (element instanceof Edge.RuntimeEdge) {
                    Edge.RuntimeEdge edge = (Edge.RuntimeEdge)element;
                    if (!this.isAvailable(edge)) continue;
                    filteredElements.add(element);
                    continue;
                }
                filteredElements.add(element);
            }
        }
        return filteredElements;
    }

    @Override
    public boolean isAvailable(Edge.RuntimeEdge edge) {
        if (edge.hasGuard()) {
            LOG.debug("Execute: '{}' in model: '{}'", (Object)edge.getGuard().getScript(), (Object)this.getModel().getName());
            try {
                return (Boolean)this.getScriptEngine().eval(edge.getGuard().getScript());
            }
            catch (ScriptException e) {
                LOG.error(e.getMessage());
                throw new MachineException(this, (Throwable)e);
            }
        }
        return true;
    }

    @Override
    public void execute(Action action) {
        LOG.debug("Execute: '{}' in model: '{}'", (Object)action.getScript(), (Object)this.getModel().getName());
        try {
            this.getScriptEngine().eval(action.getScript());
        }
        catch (ScriptException e) {
            LOG.error(e.getMessage());
            throw new MachineException(this, (Throwable)e);
        }
    }

    @Override
    public void execute(String name) {
        LOG.debug("Execute: '{}' in model: '{}'", (Object)name, (Object)this.getModel().getName());
        try {
            this.getClass().getMethod(name, new Class[0]);
            this.getScriptEngine().eval(name + "()");
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Throwable t) {
            LOG.error(t.getMessage());
            throw new MachineException(this, t);
        }
    }

    @Override
    public Map<String, String> getKeys() {
        HashMap<String, String> keys = new HashMap<String, String>();
        ArrayList<String> methods = new ArrayList<String>();
        for (Method method : this.getClass().getMethods()) {
            methods.add(method.getName());
        }
        if (this.getBindings(100).containsKey("nashorn.global")) {
            Map global = (Map)this.getBindings(100).get("nashorn.global");
            for (String key : global.keySet()) {
                if (!this.isVariable(key, methods)) continue;
                if (global.get(key) instanceof Double) {
                    keys.put(key, Long.toString(Math.round((Double)global.get(key))));
                    continue;
                }
                keys.put(key, global.get(key).toString());
            }
        } else {
            for (String key : this.getBindings(100).keySet()) {
                if (!this.isVariable(key, methods)) continue;
                Object value = this.getBindings(100).get(key);
                if (value instanceof Double) {
                    keys.put(key, Long.toString(Math.round((Double)value)));
                    continue;
                }
                keys.put(key, value.toString());
            }
        }
        return keys;
    }

    @Override
    public Object getAttribute(String name) {
        if (this.getBindings(100).containsKey("nashorn.global")) {
            Map attributes = (Map)this.getBindings(100).get("nashorn.global");
            return attributes.get(name);
        }
        return super.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        if (this.getBindings(100).containsKey("nashorn.global")) {
            Map attributes = (Map)this.getBindings(100).get("nashorn.global");
            attributes.put(name, value);
        } else {
            super.setAttribute(name, value, 100);
        }
    }

    private boolean isVariable(String key, List<String> methods) {
        return !"impl".equals(key) && !methods.contains(key) && !"print".equals(key) && !"println".equals(key);
    }
}

