/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.machine;

import org.graphwalker.core.machine.Context;
import org.graphwalker.core.machine.ExceptionStrategy;
import org.graphwalker.core.machine.ExecutionStatus;
import org.graphwalker.core.machine.Machine;
import org.graphwalker.core.machine.MachineException;
import org.graphwalker.core.machine.RequirementStatus;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Requirement;

public class FailFastStrategy
implements ExceptionStrategy {
    @Override
    public void handle(Machine machine, MachineException exception) {
        Context context = exception.getContext();
        this.fail(context, context.getCurrentElement());
        if (context.getLastElement() instanceof Edge.RuntimeEdge) {
            this.fail(context, context.getLastElement());
        }
        context.setExecutionStatus(ExecutionStatus.FAILED);
        throw exception;
    }

    private void fail(Context context, Element element) {
        if (element.hasRequirements()) {
            for (Requirement requirement : element.getRequirements()) {
                context.setRequirementStatus(requirement, RequirementStatus.FAILED);
            }
        }
    }
}

