/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.machine;

import java.util.ArrayList;
import java.util.List;
import org.graphwalker.core.common.Objects;
import org.graphwalker.core.event.EventType;
import org.graphwalker.core.event.Observer;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.machine.ExceptionStrategy;
import org.graphwalker.core.machine.FailFastStrategy;
import org.graphwalker.core.machine.Machine;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.statistics.Profiler;
import org.graphwalker.core.statistics.SimpleProfiler;

public abstract class MachineBase
implements Machine {
    private final List<Context> contexts = new ArrayList<Context>();
    private final List<Observer> observers = new ArrayList<Observer>();
    private final Profiler profiler = new SimpleProfiler();
    private ExceptionStrategy exceptionStrategy = new FailFastStrategy();
    private Context currentContext;

    @Override
    public List<Context> getContexts() {
        return this.contexts;
    }

    @Override
    public List<Observer> getObservers() {
        return this.observers;
    }

    @Override
    public void addObserver(Observer observer) {
        if (Objects.isNotNull(observer) && !this.observers.contains(observer)) {
            this.observers.add(observer);
        }
    }

    @Override
    public void notifyObservers(Element element, EventType type) {
        for (Observer observer : this.observers) {
            observer.update(this, element, type);
        }
    }

    @Override
    public void deleteObserver(Observer observer) {
        this.observers.remove(observer);
    }

    @Override
    public void deleteObservers() {
        this.observers.clear();
    }

    @Override
    public Profiler getProfiler() {
        return this.profiler;
    }

    @Override
    public Context getCurrentContext() {
        return this.currentContext;
    }

    protected void setCurrentContext(Context currentContext) {
        this.currentContext = currentContext;
    }

    @Override
    public ExceptionStrategy getExceptionStrategy() {
        return this.exceptionStrategy;
    }

    @Override
    public void setExceptionStrategy(ExceptionStrategy exceptionStrategy) {
        this.exceptionStrategy = exceptionStrategy;
    }
}

