/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.machine;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.machine.MachineException;
import org.graphwalker.core.machine.SimpleMachine;
import org.graphwalker.core.statistics.Execution;
import org.graphwalker.core.statistics.Profiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplayMachine
extends SimpleMachine {
    private static final Logger LOG = LoggerFactory.getLogger(ReplayMachine.class);
    private final Profiler profiler;
    private final Iterator<Execution> iterator;
    private final Map<Context, Context> contexts = new HashMap<Context, Context>();

    public ReplayMachine(Profiler profiler) {
        this.profiler = profiler;
        this.iterator = profiler.getExecutionPath().iterator();
        this.createContexts(profiler);
        Execution execution = profiler.getExecutionPath().get(0);
        Context context = this.contexts.get(execution.getContext());
        context.setNextElement(execution.getElement());
        this.setCurrentContext(context);
    }

    @Override
    public List<Context> getContexts() {
        return this.contexts.values().stream().collect(Collectors.toList());
    }

    private void createContexts(Profiler profiler) {
        for (Context context : profiler.getContexts()) {
            try {
                Context newContext = (Context)context.getClass().newInstance();
                newContext.setModel(context.getModel());
                this.contexts.put(context, newContext);
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.error(e.getMessage());
                throw new MachineException(context, (Throwable)e);
            }
        }
    }

    @Override
    protected Context getNextStep(Context context) {
        Execution execution = this.iterator.next();
        this.setCurrentContext(this.contexts.get(execution.getContext()));
        this.getCurrentContext().setCurrentElement(execution.getElement());
        return this.getCurrentContext();
    }

    @Override
    public boolean hasNextStep() {
        return this.iterator.hasNext();
    }
}

