/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.graphwalker.core.common.Objects;
import org.graphwalker.core.event.EventType;
import org.graphwalker.core.generator.NoPathFoundException;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.machine.ExecutionStatus;
import org.graphwalker.core.machine.MachineBase;
import org.graphwalker.core.machine.MachineException;
import org.graphwalker.core.machine.RequirementStatus;
import org.graphwalker.core.model.Action;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Requirement;
import org.graphwalker.core.model.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SimpleMachine
extends MachineBase {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleMachine.class);
    private Element lastElement;

    public SimpleMachine() {
    }

    public SimpleMachine(Context ... contexts) {
        this(Arrays.asList(contexts));
    }

    public SimpleMachine(Collection<Context> contexts) {
        this.getContexts().addAll(contexts);
        this.executeInitActions(contexts);
        this.setCurrentContext(this.chooseStartContext(contexts));
    }

    private void executeInitActions(Collection<Context> contexts) {
        for (Context context : contexts) {
            this.setCurrentContext(context);
            this.getCurrentContext().setProfiler(this.getProfiler());
            if (Objects.isNull(context.getModel())) {
                throw new MachineException("A context must be associated with a model");
            }
            this.execute(context.getModel().getActions());
        }
    }

    private Context chooseStartContext(Collection<Context> contexts) {
        for (Context context : contexts) {
            if (!Objects.isNotNull(context.getCurrentElement()) && !Objects.isNotNull(context.getNextElement())) continue;
            return context;
        }
        throw new MachineException("No start context found");
    }

    @Override
    public Context getNextStep() {
        MDC.put((String)"trace", (String)UUID.randomUUID().toString());
        this.walk(this.getCurrentContext());
        this.notifyObservers(this.getCurrentContext().getCurrentElement(), EventType.BEFORE_ELEMENT);
        this.getProfiler().start(this.getCurrentContext());
        this.execute(this.getCurrentContext().getCurrentElement());
        this.getProfiler().stop(this.getCurrentContext());
        if (this.getCurrentContext().getLastElement() instanceof Edge.RuntimeEdge) {
            this.updateRequirements(this.getCurrentContext(), this.getCurrentContext().getLastElement());
        }
        if (this.getCurrentContext().getCurrentElement() instanceof Vertex.RuntimeVertex) {
            this.updateRequirements(this.getCurrentContext(), this.getCurrentContext().getCurrentElement());
        }
        this.notifyObservers(this.getCurrentContext().getCurrentElement(), EventType.AFTER_ELEMENT);
        return this.getCurrentContext();
    }

    private void updateRequirements(Context context, Element element) {
        if (element.hasRequirements()) {
            for (Requirement requirement : element.getRequirements()) {
                context.setRequirementStatus(requirement, RequirementStatus.PASSED);
            }
        }
    }

    protected Context getNextStep(Context context) {
        LOG.debug("Context: " + context);
        if (Objects.isNotNull(context.getNextElement())) {
            context.setCurrentElement(context.getNextElement());
        } else {
            context.getPathGenerator().getNextStep();
        }
        return context;
    }

    private void walk(Context context) {
        try {
            context = Objects.isNull(context.getCurrentElement()) ? this.takeFirstStep(context) : this.takeNextStep(context);
            if (ExecutionStatus.NOT_EXECUTED.equals((Object)context.getExecutionStatus())) {
                context.setExecutionStatus(ExecutionStatus.EXECUTING);
            }
        }
        catch (Throwable t) {
            LOG.error(t.getMessage());
            this.getExceptionStrategy().handle(this, new MachineException(context, t));
        }
    }

    private Context takeFirstStep(Context context) {
        context = Objects.isNotNull(context.getNextElement()) ? this.getNextStep(context) : this.switchContext(this.findStartContext());
        return context;
    }

    private boolean isStartContext(Context context) {
        return this.hasNextStep(context) && (Objects.isNotNull(context.getCurrentElement()) || Objects.isNotNull(context.getNextElement()));
    }

    private Context findStartContext() {
        Context startContext = null;
        for (Context context : this.getContexts()) {
            if (!this.isStartContext(context)) continue;
            startContext = context;
            break;
        }
        if (Objects.isNull(startContext)) {
            throw new NoPathFoundException("No start element defined");
        }
        return startContext;
    }

    private Context switchContext(Context context) {
        this.hasNextStep(this.getCurrentContext());
        this.lastElement = this.getCurrentContext().getCurrentElement();
        this.getCurrentContext().setCurrentElement(null);
        this.setCurrentContext(context);
        return this.getCurrentContext();
    }

    private Context takeNextStep(Context context) {
        Vertex.RuntimeVertex vertex;
        if (this.isVertex(context.getCurrentElement()) && (vertex = (Vertex.RuntimeVertex)context.getCurrentElement()).hasSharedState() && this.hasPossibleSharedStates(vertex)) {
            context = this.chooseSharedContext(context, vertex);
        }
        return this.getNextStep(context);
    }

    private Context chooseSharedContext(Context context, Vertex.RuntimeVertex vertex) {
        Random random;
        List<SharedStateTuple> candidates = this.getPossibleSharedStates(vertex.getSharedState());
        SharedStateTuple candidate = candidates.get((random = new Random(System.nanoTime())).nextInt(candidates.size()));
        if (!candidate.getVertex().equals(context.getCurrentElement())) {
            candidate.context.setNextElement(candidate.getVertex());
            context = this.switchContext(candidate.context);
        } else {
            this.lastElement = null;
        }
        return context;
    }

    private boolean isVertex(Element element) {
        return element instanceof Vertex.RuntimeVertex;
    }

    private boolean hasPossibleSharedStates(Vertex.RuntimeVertex vertex) {
        return Objects.isNotNull(vertex.getSharedState()) && 0 < this.getPossibleSharedStates(vertex.getSharedState()).size();
    }

    private List<SharedStateTuple> getPossibleSharedStates(String sharedState) {
        ArrayList<SharedStateTuple> sharedStates = new ArrayList<SharedStateTuple>();
        for (Context context : this.getContexts()) {
            if (this.getCurrentContext().equals(context) && this.hasOutEdges(context)) {
                sharedStates.add(new SharedStateTuple(this.getCurrentContext(), (Vertex.RuntimeVertex)this.getCurrentContext().getCurrentElement()));
                continue;
            }
            if (this.getCurrentContext().equals(context) || !context.getModel().hasSharedState(sharedState)) continue;
            for (Vertex.RuntimeVertex vertex : context.getModel().getSharedStates(sharedState)) {
                if (vertex.equals(this.lastElement) && !this.getCurrentContext().getModel().getOutEdges((Vertex.RuntimeVertex)this.getCurrentContext().getCurrentElement()).isEmpty() || !vertex.hasName() && context.getModel().getOutEdges(vertex).isEmpty()) continue;
                sharedStates.add(new SharedStateTuple(context, vertex));
            }
        }
        return sharedStates;
    }

    private boolean hasOutEdges(Context context) {
        return Objects.isNotNull(context.getCurrentElement()) && context.getCurrentElement() instanceof Vertex.RuntimeVertex && !context.getModel().getOutEdges((Vertex.RuntimeVertex)context.getCurrentElement()).isEmpty();
    }

    @Override
    public boolean hasNextStep() {
        MDC.put((String)"trace", (String)UUID.randomUUID().toString());
        for (Context context : this.getContexts()) {
            if (!this.hasNextStep(context)) continue;
            if (!context.equals(this.getCurrentContext()) && this.isStartContext(context)) {
                this.switchContext(context);
            }
            return true;
        }
        return false;
    }

    private boolean hasNextStep(Context context) {
        ExecutionStatus status = context.getExecutionStatus();
        if (ExecutionStatus.COMPLETED.equals((Object)status) || ExecutionStatus.FAILED.equals((Object)status)) {
            return false;
        }
        if (Objects.isNull(context.getPathGenerator())) {
            throw new MachineException("No path generator is defined");
        }
        boolean hasMoreSteps = context.getPathGenerator().hasNextStep();
        if (!hasMoreSteps) {
            context.setExecutionStatus(ExecutionStatus.COMPLETED);
            this.updateRequirements(context, context.getModel());
        }
        return hasMoreSteps;
    }

    private void execute(Element element) {
        try {
            if (element instanceof Vertex.RuntimeVertex) {
                this.execute((Vertex.RuntimeVertex)element);
            } else if (element instanceof Edge.RuntimeEdge) {
                this.execute((Edge.RuntimeEdge)element);
            }
        }
        catch (MachineException e) {
            LOG.error(e.getMessage());
            this.getExceptionStrategy().handle(this, e);
        }
    }

    private void execute(Edge.RuntimeEdge edge) {
        this.execute(edge.getActions());
        if (edge.hasName()) {
            this.getCurrentContext().execute(edge.getName());
        }
    }

    private void execute(List<Action> actions) {
        for (Action action : actions) {
            this.getCurrentContext().execute(action);
        }
    }

    private void execute(Vertex.RuntimeVertex vertex) {
        if (vertex.hasName()) {
            this.getCurrentContext().execute(vertex.getName());
        }
    }

    private static class SharedStateTuple {
        private final Context context;
        private final Vertex.RuntimeVertex vertex;

        private SharedStateTuple(Context context, Vertex.RuntimeVertex vertex) {
            this.context = context;
            this.vertex = vertex;
        }

        public Context getContext() {
            return this.context;
        }

        public Vertex.RuntimeVertex getVertex() {
            return this.vertex;
        }
    }
}

