/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.model;

import java.util.Map;
import java.util.Set;
import org.graphwalker.core.common.Objects;
import org.graphwalker.core.model.BuilderBase;
import org.graphwalker.core.model.Requirement;

public abstract class CachedBuilder<B, T>
extends BuilderBase<B, T> {
    private T cache;

    protected void invalidateCache() {
        this.cache = null;
    }

    protected abstract T createCache();

    @Override
    public T build() {
        if (Objects.isNull(this.cache)) {
            this.cache = this.createCache();
        }
        return this.cache;
    }

    @Override
    public B setId(String id) {
        this.invalidateCache();
        return super.setId(id);
    }

    @Override
    public B setName(String name) {
        this.invalidateCache();
        return super.setName(name);
    }

    @Override
    public B addRequirement(Requirement requirement) {
        this.invalidateCache();
        return super.addRequirement(requirement);
    }

    @Override
    public B setRequirements(Set<Requirement> requirements) {
        this.invalidateCache();
        return super.setRequirements(requirements);
    }

    @Override
    public B setProperties(Map<String, Object> properties) {
        this.invalidateCache();
        return super.setProperties(properties);
    }

    @Override
    public B setProperty(String key, Object value) {
        this.invalidateCache();
        return super.setProperty(key, value);
    }
}

