/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.model;

import java.util.ArrayList;
import java.util.List;
import org.graphwalker.core.common.Objects;
import org.graphwalker.core.model.BuilderFactory;
import org.graphwalker.core.model.CachedBuilder;
import org.graphwalker.core.model.ElementVisitor;
import org.graphwalker.core.model.RuntimeBase;

public class Classification
extends CachedBuilder<Classification, RuntimeClassification> {
    private final List<Classification> classifications = new ArrayList<Classification>();

    public Classification addClassification(Classification classification) {
        this.classifications.add(classification);
        this.invalidateCache();
        return this;
    }

    public List<Classification> getClassifications() {
        return this.classifications;
    }

    @Override
    protected RuntimeClassification createCache() {
        return new RuntimeClassification(this);
    }

    public static class RuntimeClassification
    extends RuntimeBase {
        private final List<RuntimeClassification> classifications;

        private RuntimeClassification(Classification classification) {
            super(classification.getId(), classification.getName());
            this.classifications = BuilderFactory.build(classification.getClassifications());
        }

        public List<RuntimeClassification> getClassifications() {
            return this.classifications;
        }

        @Override
        public void accept(ElementVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            RuntimeClassification that = (RuntimeClassification)o;
            return Objects.equals(this.classifications, that.classifications);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.classifications);
        }

        public String toString() {
            return this.getName();
        }
    }
}

