/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graphwalker.core.common.Objects;
import org.graphwalker.core.model.Action;
import org.graphwalker.core.model.BuilderBase;
import org.graphwalker.core.model.BuilderFactory;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.ElementVisitor;
import org.graphwalker.core.model.RuntimeBase;
import org.graphwalker.core.model.Vertex;

public class Model
extends BuilderBase<Model, RuntimeModel> {
    private List<Vertex> vertices = new ArrayList<Vertex>();
    private List<Edge> edges = new ArrayList<Edge>();
    private List<Action> actions = new ArrayList<Action>();

    public Model() {
    }

    public Model(RuntimeModel model) {
        this.setId(model.getId());
        this.setName(model.getName());
        this.setProperties(model.getProperties());
        this.setRequirements(model.getRequirements());
        this.setActions(model.getActions());
        HashMap<Vertex.RuntimeVertex, Vertex> cache = new HashMap<Vertex.RuntimeVertex, Vertex>();
        for (Vertex.RuntimeVertex runtimeVertex : model.getVertices()) {
            Vertex vertex = new Vertex();
            vertex.setId(runtimeVertex.getId());
            vertex.setName(runtimeVertex.getName());
            vertex.setSharedState(runtimeVertex.getSharedState());
            vertex.setRequirements(runtimeVertex.getRequirements());
            vertex.setProperties(runtimeVertex.getProperties());
            this.vertices.add(vertex);
            cache.put(runtimeVertex, vertex);
        }
        for (Edge.RuntimeEdge runtimeEdge : model.getEdges()) {
            Edge edge = new Edge();
            edge.setId(runtimeEdge.getId());
            edge.setName(runtimeEdge.getName());
            edge.setSourceVertex((Vertex)cache.get(runtimeEdge.getSourceVertex()));
            edge.setTargetVertex((Vertex)cache.get(runtimeEdge.getTargetVertex()));
            edge.setGuard(runtimeEdge.getGuard());
            edge.setActions(runtimeEdge.getActions());
            edge.setRequirements(runtimeEdge.getRequirements());
            edge.setWeight(runtimeEdge.getWeight());
            edge.setProperties(runtimeEdge.getProperties());
            this.edges.add(edge);
        }
    }

    public Model addVertex(Vertex vertex) {
        this.vertices.add(vertex);
        return this;
    }

    public Model addEdge(Edge edge) {
        this.edges.add(edge);
        if (Objects.isNotNull(edge.getSourceVertex()) && !this.vertices.contains(edge.getSourceVertex())) {
            this.vertices.add(edge.getSourceVertex());
        }
        if (Objects.isNotNull(edge.getTargetVertex()) && !this.vertices.contains(edge.getTargetVertex())) {
            this.vertices.add(edge.getTargetVertex());
        }
        return this;
    }

    public Model deleteEdge(Edge edge) {
        this.edges.remove(edge);
        return this;
    }

    public Model deleteVertex(Vertex vertex) {
        this.edges.removeIf(edge -> vertex.equals(edge.getSourceVertex()) || vertex.equals(edge.getTargetVertex()));
        this.vertices.remove(vertex);
        return this;
    }

    public Model addAction(Action action) {
        this.actions.add(action);
        return this;
    }

    public Model addActions(Action ... actions) {
        return this.addActions(Arrays.asList(actions));
    }

    public Model addActions(List<Action> actions) {
        this.actions.addAll(actions);
        return this;
    }

    public Model setActions(List<Action> actions) {
        this.actions = new ArrayList<Action>(actions);
        return this;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public List<Vertex> getVertices() {
        return this.vertices;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    @Override
    public RuntimeModel build() {
        return new RuntimeModel(this);
    }

    public static class RuntimeModel
    extends RuntimeBase {
        private final List<Vertex.RuntimeVertex> vertices;
        private final List<Edge.RuntimeEdge> edges;
        private final List<Element> elementsCache;
        private final Map<Element, List<Element>> elementsByElementCache;
        private final Map<String, List<Element>> elementsByNameCache;
        private final Map<String, List<Edge.RuntimeEdge>> edgesByNameCache;
        private final Map<String, List<Vertex.RuntimeVertex>> verticesByNameCache;
        private final Map<Vertex.RuntimeVertex, List<Edge.RuntimeEdge>> inEdgesByVertexCache;
        private final Map<Vertex.RuntimeVertex, List<Edge.RuntimeEdge>> outEdgesByVertexCache;
        private final Map<String, List<Vertex.RuntimeVertex>> sharedStateCache;

        private RuntimeModel(Model model) {
            super(model.getId(), model.getName(), model.getActions(), model.getRequirements(), model.getProperties());
            this.vertices = BuilderFactory.build(model.getVertices());
            this.edges = BuilderFactory.build(model.getEdges());
            this.edgesByNameCache = this.createEdgesByNameCache();
            this.verticesByNameCache = this.createVerticesByNameCache();
            this.inEdgesByVertexCache = this.createInEdgesByVertexCache();
            this.outEdgesByVertexCache = this.createOutEdgesByVertexCache();
            this.elementsCache = this.createElementCache();
            this.elementsByNameCache = this.createElementsByNameCache();
            this.elementsByElementCache = this.createElementsByElementCache(this.elementsCache, this.outEdgesByVertexCache);
            this.sharedStateCache = this.createSharedStateCache();
        }

        public List<Vertex.RuntimeVertex> getVertices() {
            return this.vertices;
        }

        public Set<String> getSharedStates() {
            return this.sharedStateCache.keySet();
        }

        public List<Vertex.RuntimeVertex> getSharedStates(String sharedState) {
            return this.sharedStateCache.get(sharedState);
        }

        public boolean hasSharedState(String sharedState) {
            return this.sharedStateCache.containsKey(sharedState);
        }

        public boolean hasSharedStates() {
            return !this.sharedStateCache.isEmpty();
        }

        public List<Vertex.RuntimeVertex> findVertices(String name) {
            return this.verticesByNameCache.get(name);
        }

        public List<Edge.RuntimeEdge> getInEdges(Vertex.RuntimeVertex vertex) {
            return this.inEdgesByVertexCache.get(vertex);
        }

        public List<Edge.RuntimeEdge> getEdges() {
            return this.edges;
        }

        public List<Edge.RuntimeEdge> getOutEdges(Vertex.RuntimeVertex vertex) {
            return this.outEdgesByVertexCache.get(vertex);
        }

        public List<Edge.RuntimeEdge> findEdges(String name) {
            return this.edgesByNameCache.get(name);
        }

        public List<Element> findElements(String name) {
            return this.elementsByNameCache.get(name);
        }

        public List<Element> getElements() {
            return this.elementsCache;
        }

        public Element getElementById(String id) {
            for (Element element : this.elementsCache) {
                if (!element.getId().equals(id)) continue;
                return element;
            }
            return null;
        }

        public List<Element> getElements(Element element) {
            return this.elementsByElementCache.get(element);
        }

        private List<Element> createElementCache() {
            ArrayList<RuntimeBase> elements = new ArrayList<RuntimeBase>();
            elements.addAll(this.vertices);
            elements.addAll(this.edges);
            return Objects.unmodifiableList(elements);
        }

        private Map<Element, List<Element>> createElementsByElementCache(List<Element> elements, Map<Vertex.RuntimeVertex, List<Edge.RuntimeEdge>> outEdges) {
            HashMap<Element, List<Element>> elementsByElementCache = new HashMap<Element, List<Element>>();
            for (Element element : elements) {
                if (element instanceof Edge.RuntimeEdge) {
                    Edge.RuntimeEdge edge = (Edge.RuntimeEdge)element;
                    elementsByElementCache.put(element, Collections.singletonList(edge.getTargetVertex()));
                    continue;
                }
                if (!(element instanceof Vertex.RuntimeVertex)) continue;
                Vertex.RuntimeVertex vertex = (Vertex.RuntimeVertex)element;
                elementsByElementCache.put(element, this.cast(outEdges.get(vertex)));
            }
            return this.makeImmutable(elementsByElementCache);
        }

        private List<Element> cast(List<? extends Element> list) {
            return list;
        }

        private Map<String, List<Element>> createElementsByNameCache() {
            HashMap elementsByElementCache = new HashMap();
            for (Element element : this.createElementCache()) {
                if (!element.hasName()) continue;
                if (!elementsByElementCache.containsKey(element.getName())) {
                    elementsByElementCache.put(element.getName(), new ArrayList());
                }
                ((List)elementsByElementCache.get(element.getName())).add(element);
            }
            return this.makeImmutable(elementsByElementCache);
        }

        private Map<String, List<Edge.RuntimeEdge>> createEdgesByNameCache() {
            HashMap edgesByNameCache = new HashMap();
            for (Edge.RuntimeEdge edge : this.edges) {
                if (!edge.hasName()) continue;
                if (!edgesByNameCache.containsKey(edge.getName())) {
                    edgesByNameCache.put(edge.getName(), new ArrayList());
                }
                ((List)edgesByNameCache.get(edge.getName())).add(edge);
            }
            return this.makeImmutable(edgesByNameCache);
        }

        private Map<String, List<Vertex.RuntimeVertex>> createVerticesByNameCache() {
            HashMap verticesByNameCache = new HashMap();
            for (Vertex.RuntimeVertex vertex : this.vertices) {
                if (!vertex.hasName()) continue;
                if (!verticesByNameCache.containsKey(vertex.getName())) {
                    verticesByNameCache.put(vertex.getName(), new ArrayList());
                }
                ((List)verticesByNameCache.get(vertex.getName())).add(vertex);
            }
            return this.makeImmutable(verticesByNameCache);
        }

        private Map<Vertex.RuntimeVertex, List<Edge.RuntimeEdge>> createInEdgesByVertexCache() {
            HashMap inEdgesByVertexCache = new HashMap();
            for (Vertex.RuntimeVertex vertex : this.vertices) {
                inEdgesByVertexCache.put(vertex, new ArrayList());
            }
            for (Edge.RuntimeEdge edge : this.edges) {
                Vertex.RuntimeVertex vertex = edge.getTargetVertex();
                if (!Objects.isNotNull(vertex)) continue;
                ((List)inEdgesByVertexCache.get(vertex)).add(edge);
            }
            return this.makeImmutable(inEdgesByVertexCache);
        }

        private Map<Vertex.RuntimeVertex, List<Edge.RuntimeEdge>> createOutEdgesByVertexCache() {
            HashMap outEdgesByVertexCache = new HashMap();
            for (Vertex.RuntimeVertex vertex : this.vertices) {
                outEdgesByVertexCache.put(vertex, new ArrayList());
            }
            for (Edge.RuntimeEdge edge : this.edges) {
                Vertex.RuntimeVertex vertex = edge.getSourceVertex();
                if (!Objects.isNotNull(vertex)) continue;
                ((List)outEdgesByVertexCache.get(vertex)).add(edge);
            }
            return this.makeImmutable(outEdgesByVertexCache);
        }

        private Map<String, List<Vertex.RuntimeVertex>> createSharedStateCache() {
            HashMap sharedStateCache = new HashMap();
            for (Vertex.RuntimeVertex vertex : this.vertices) {
                if (!vertex.hasSharedState()) continue;
                if (!sharedStateCache.containsKey(vertex.getSharedState())) {
                    sharedStateCache.put(vertex.getSharedState(), new ArrayList());
                }
                ((List)sharedStateCache.get(vertex.getSharedState())).add(vertex);
            }
            return this.makeImmutable(sharedStateCache);
        }

        private <K, E> Map<K, List<E>> makeImmutable(Map<K, List<E>> source) {
            HashMap<K, List<E>> map = new HashMap<K, List<E>>();
            for (K key : source.keySet()) {
                map.put(key, Objects.unmodifiableList(source.get(key)));
            }
            return Objects.unmodifiableMap(map);
        }

        @Override
        public void accept(ElementVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.edges == null ? 0 : this.edges.hashCode());
            result = 31 * result + (this.edgesByNameCache == null ? 0 : this.edgesByNameCache.hashCode());
            result = 31 * result + (this.elementsByElementCache == null ? 0 : this.elementsByElementCache.hashCode());
            result = 31 * result + (this.elementsByNameCache == null ? 0 : this.elementsByNameCache.hashCode());
            result = 31 * result + (this.elementsCache == null ? 0 : this.elementsCache.hashCode());
            result = 31 * result + (this.inEdgesByVertexCache == null ? 0 : this.inEdgesByVertexCache.hashCode());
            result = 31 * result + (this.outEdgesByVertexCache == null ? 0 : this.outEdgesByVertexCache.hashCode());
            result = 31 * result + (this.sharedStateCache == null ? 0 : this.sharedStateCache.hashCode());
            result = 31 * result + (this.vertices == null ? 0 : this.vertices.hashCode());
            result = 31 * result + (this.verticesByNameCache == null ? 0 : this.verticesByNameCache.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            RuntimeModel that = (RuntimeModel)o;
            return Objects.equals(this.vertices, that.vertices) && Objects.equals(this.edges, that.edges) && Objects.equals(this.elementsCache, that.elementsCache) && Objects.equals(this.elementsByElementCache, that.elementsByElementCache) && Objects.equals(this.elementsByNameCache, that.elementsByNameCache) && Objects.equals(this.edgesByNameCache, that.edgesByNameCache) && Objects.equals(this.verticesByNameCache, that.verticesByNameCache) && Objects.equals(this.inEdgesByVertexCache, that.inEdgesByVertexCache) && Objects.equals(this.outEdgesByVertexCache, that.outEdgesByVertexCache) && Objects.equals(this.sharedStateCache, that.sharedStateCache);
        }
    }
}

