/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.model;

import org.graphwalker.core.common.Objects;
import org.graphwalker.core.model.CachedBuilder;
import org.graphwalker.core.model.ElementVisitor;
import org.graphwalker.core.model.RuntimeBase;

public class Vertex
extends CachedBuilder<Vertex, RuntimeVertex> {
    private String sharedState;

    public String getSharedState() {
        return this.sharedState;
    }

    public Vertex setSharedState(String sharedState) {
        this.sharedState = sharedState;
        this.invalidateCache();
        return this;
    }

    @Override
    protected RuntimeVertex createCache() {
        return new RuntimeVertex(this);
    }

    public static class RuntimeVertex
    extends RuntimeBase {
        private final String sharedState;

        private RuntimeVertex(Vertex vertex) {
            super(vertex.getId(), vertex.getName(), vertex.getRequirements(), vertex.getProperties());
            this.sharedState = vertex.getSharedState();
        }

        public String getSharedState() {
            return this.sharedState;
        }

        public boolean hasSharedState() {
            return Objects.isNotNullOrEmpty(this.sharedState);
        }

        @Override
        public void accept(ElementVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.sharedState == null ? 0 : this.sharedState.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            RuntimeVertex that = (RuntimeVertex)o;
            return Objects.equals(this.sharedState, that.sharedState);
        }
    }
}

