/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.statistics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Vertex;
import org.graphwalker.core.statistics.Execution;
import org.graphwalker.core.statistics.Profile;
import org.graphwalker.core.statistics.Profiler;

public class SimpleProfiler
implements Profiler {
    private long startTime = 0L;
    private final Map<Context, Map<Element, List<Execution>>> executions = new HashMap<Context, Map<Element, List<Execution>>>();
    private final List<Execution> executionPath = new ArrayList<Execution>();

    @Override
    public void addContext(Context context) {
        if (!this.executions.containsKey(context)) {
            this.executions.put(context, new HashMap());
        }
    }

    @Override
    public Set<Context> getContexts() {
        return this.executions.keySet();
    }

    @Override
    public void start(Context context) {
        if (!this.executions.containsKey(context)) {
            this.executions.put(context, new HashMap());
        }
        if (!this.executions.get(context).containsKey(context.getCurrentElement())) {
            this.executions.get(context).put(context.getCurrentElement(), new ArrayList());
        }
        this.startTime = System.nanoTime();
    }

    @Override
    public void stop(Context context) {
        long stopTime = System.nanoTime();
        Execution execution = new Execution(context, context.getCurrentElement(), this.startTime, stopTime - this.startTime);
        this.executionPath.add(execution);
        this.executions.get(context).get(context.getCurrentElement()).add(execution);
    }

    @Override
    public boolean isVisited(Context context, Element element) {
        return this.executions.containsKey(context) && this.executions.get(context).containsKey(element);
    }

    @Override
    public long getTotalVisitCount() {
        return this.executionPath.size();
    }

    @Override
    public long getVisitCount(Context context, Element element) {
        if (this.executions.containsKey(context) && this.executions.get(context).containsKey(element)) {
            return this.executions.get(context).get(element).size();
        }
        return 0L;
    }

    @Override
    public List<Element> getUnvisitedElements() {
        return this.executions.keySet().stream().map(this::getUnvisitedElements).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<Element> getUnvisitedElements(Context context) {
        return context.getModel().getElements().stream().filter(element -> !this.executions.get(context).containsKey(element)).collect(Collectors.toList());
    }

    @Override
    public List<Element> getVisitedEdges() {
        return this.executions.keySet().stream().map(this::getVisitedEdges).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<Element> getVisitedEdges(Context context) {
        return context.getModel().getElements().stream().filter(element -> element instanceof Edge.RuntimeEdge).filter(element -> this.executions.get(context).containsKey(element)).collect(Collectors.toList());
    }

    @Override
    public List<Element> getUnvisitedEdges() {
        return this.executions.keySet().stream().map(this::getUnvisitedEdges).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<Element> getUnvisitedEdges(Context context) {
        return context.getModel().getElements().stream().filter(element -> element instanceof Edge.RuntimeEdge).filter(element -> !this.executions.get(context).containsKey(element)).collect(Collectors.toList());
    }

    @Override
    public List<Element> getUnvisitedVertices() {
        return this.executions.keySet().stream().map(this::getUnvisitedVertices).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<Element> getUnvisitedVertices(Context context) {
        return context.getModel().getElements().stream().filter(element -> element instanceof Vertex.RuntimeVertex).filter(element -> !this.executions.get(context).containsKey(element)).collect(Collectors.toList());
    }

    @Override
    public List<Element> getVisitedVertices() {
        return this.executions.keySet().stream().map(this::getVisitedVertices).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<Element> getVisitedVertices(Context context) {
        return context.getModel().getElements().stream().filter(element -> element instanceof Vertex.RuntimeVertex).filter(element -> this.executions.get(context).containsKey(element)).collect(Collectors.toList());
    }

    @Override
    public List<Execution> getExecutionPath() {
        return this.executionPath;
    }

    @Override
    public long getTotalExecutionTime() {
        return this.getTotalExecutionTime(TimeUnit.MILLISECONDS);
    }

    @Override
    public long getTotalExecutionTime(TimeUnit unit) {
        return this.executionPath.stream().mapToLong(e -> e.getDuration(unit)).sum();
    }

    @Override
    public List<Profile> getProfiles() {
        return this.executions.entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).keySet().stream().map(element -> this.getProfile((Context)entry.getKey(), (Element)element))).collect(Collectors.toList());
    }

    @Override
    public Profile getProfile(Context context, Element element) {
        return new Profile(context, element, this.executions.get(context).get(element));
    }
}

