/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.dsl.antlr.dot;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.RuleContext;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Model;
import org.graphwalker.core.model.Vertex;
import org.graphwalker.dsl.dot.DOTBaseListener;
import org.graphwalker.dsl.dot.DOTParser;

public class DotModelListener
extends DOTBaseListener {
    private Model model = new Model();
    private Map<String, Vertex> vertices = new HashMap<String, Vertex>();

    public Model getModel() {
        return this.model;
    }

    private Vertex createVertex(String id, String label) {
        if ("Start".equalsIgnoreCase(id) || "Start".equalsIgnoreCase(label)) {
            this.vertices.put(id, null);
            return null;
        }
        if (!this.vertices.containsKey(id)) {
            this.vertices.put(id, (Vertex)((Vertex)new Vertex().setId(id)).setName(label != null ? label : id));
            this.model.addVertex(this.vertices.get(id));
        }
        return this.vertices.get(id);
    }

    @Override
    public void enterGraph(DOTParser.GraphContext context) {
        this.model.setName(context.id().getText());
    }

    @Override
    public void enterNode_stmt(DOTParser.Node_stmtContext context) {
        if (context.attr_list() != null) {
            Map<String, String> attributes = context.attr_list().a_list().stream().map(RuleContext::getText).map(item -> item.split("=")).collect(Collectors.toMap(parts -> parts[0], parts -> parts[1].replace("\"", "")));
            String label = attributes.get("label");
            this.createVertex(context.node_id().id().getText(), label);
        } else {
            this.createVertex(context.node_id().id().getText(), null);
        }
    }

    @Override
    public void enterEdge_stmt(DOTParser.Edge_stmtContext context) {
        Vertex source = this.createVertex(context.node_id().id().getText(), null);
        for (DOTParser.Node_idContext node_id : context.edgeRHS().node_id()) {
            Vertex target = this.createVertex(node_id.getText(), null);
            Edge edge = new Edge().setSourceVertex(source).setTargetVertex(target);
            if (context.attr_list() != null) {
                Map<String, String> attributes = context.attr_list().a_list().stream().map(RuleContext::getText).map(item -> item.split("=")).collect(Collectors.toMap(parts -> parts[0], parts -> parts[1].replace("\"", "")));
                String label = attributes.get("label");
                ((Edge)edge.setId(label)).setName(label);
            }
            this.model.addEdge(edge);
            source = target;
        }
    }
}

