/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.dsl.antlr.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.graphwalker.core.condition.AlternativeCondition;
import org.graphwalker.core.condition.CombinedCondition;
import org.graphwalker.core.condition.DependencyEdgeCoverage;
import org.graphwalker.core.condition.EdgeCoverage;
import org.graphwalker.core.condition.Length;
import org.graphwalker.core.condition.Never;
import org.graphwalker.core.condition.ReachedEdge;
import org.graphwalker.core.condition.ReachedSharedState;
import org.graphwalker.core.condition.ReachedStopCondition;
import org.graphwalker.core.condition.ReachedVertex;
import org.graphwalker.core.condition.RequirementCoverage;
import org.graphwalker.core.condition.StopCondition;
import org.graphwalker.core.condition.TimeDuration;
import org.graphwalker.core.condition.VertexCoverage;
import org.graphwalker.core.generator.AStarPath;
import org.graphwalker.core.generator.CombinedPath;
import org.graphwalker.core.generator.PathGenerator;
import org.graphwalker.core.generator.QuickRandomPath;
import org.graphwalker.core.generator.RandomPath;
import org.graphwalker.core.generator.ShortestAllPaths;
import org.graphwalker.core.generator.WeightedRandomPath;
import org.graphwalker.dsl.generator.GeneratorParser;
import org.graphwalker.dsl.generator.GeneratorParserBaseListener;

public class GeneratorLoader
extends GeneratorParserBaseListener {
    private StopCondition stopCondition = null;
    private final List<PathGenerator> pathGenerators = new ArrayList<PathGenerator>();
    private final List<StopCondition> stopConditions = new ArrayList<StopCondition>();

    @Override
    public void exitBooleanAndExpression(GeneratorParser.BooleanAndExpressionContext ctx) {
        if (!ctx.AND().isEmpty()) {
            CombinedCondition combinedCondition = new CombinedCondition();
            this.stopConditions.forEach(arg_0 -> ((CombinedCondition)combinedCondition).addStopCondition(arg_0));
            this.stopCondition = combinedCondition;
        }
    }

    @Override
    public void exitStopCondition(GeneratorParser.StopConditionContext ctx) {
        String conditionName = ctx.getChild(0).getText().toLowerCase();
        if ("never".equals(conditionName)) {
            this.stopConditions.add((StopCondition)new Never());
        } else if ("edge_coverage".equals(conditionName) || "edgecoverage".equals(conditionName)) {
            this.stopConditions.add((StopCondition)new EdgeCoverage(Integer.parseInt(ctx.getChild(2).getText())));
        } else if ("vertex_coverage".equals(conditionName) || "vertexcoverage".equals(conditionName)) {
            this.stopConditions.add((StopCondition)new VertexCoverage(Integer.parseInt(ctx.getChild(2).getText())));
        } else if ("reached_vertex".equals(conditionName) || "reachedvertex".equals(conditionName)) {
            this.stopConditions.add((StopCondition)new ReachedVertex(ctx.getChild(2).getText()));
        } else if ("reached_shared_state".equals(conditionName) || "reachedsharedstate".equals(conditionName)) {
            this.stopConditions.add((StopCondition)new ReachedSharedState(ctx.getChild(2).getText()));
        } else if ("reached_edge".equals(conditionName) || "reachededge".equals(conditionName)) {
            this.stopConditions.add((StopCondition)new ReachedEdge(ctx.getChild(2).getText()));
        } else if ("time_duration".equals(conditionName) || "timeduration".equals(conditionName)) {
            this.stopConditions.add((StopCondition)new TimeDuration(Long.parseLong(ctx.getChild(2).getText()), TimeUnit.SECONDS));
        } else if ("dependency_edge_coverage".equals(conditionName) || "dependencyedgecoverage".equals(conditionName)) {
            this.stopConditions.add((StopCondition)new DependencyEdgeCoverage(Integer.parseInt(ctx.getChild(2).getText())));
        } else if ("requirement_coverage".equals(conditionName) || "requirementcoverage".equals(conditionName)) {
            this.stopConditions.add((StopCondition)new RequirementCoverage(Integer.parseInt(ctx.getChild(2).getText())));
        } else if ("length".equals(conditionName)) {
            this.stopConditions.add((StopCondition)new Length((long)Integer.parseInt(ctx.getChild(2).getText())));
        }
    }

    @Override
    public void exitLogicalExpression(GeneratorParser.LogicalExpressionContext ctx) {
        if (!ctx.OR().isEmpty()) {
            AlternativeCondition alternativeCondition = new AlternativeCondition();
            this.stopConditions.forEach(arg_0 -> ((AlternativeCondition)alternativeCondition).addStopCondition(arg_0));
            this.stopCondition = alternativeCondition;
        }
    }

    @Override
    public void exitGenerator(GeneratorParser.GeneratorContext context) {
        String generatorName;
        if (this.stopConditions.size() == 1) {
            this.stopCondition = this.stopConditions.get(0);
        }
        if ("random".equals(generatorName = context.getChild(0).getText().toLowerCase()) || "randompath".equals(generatorName)) {
            this.pathGenerators.add((PathGenerator)new RandomPath(this.stopCondition));
        } else if ("weighted_random".equals(generatorName) || "weightedrandompath".equals(generatorName)) {
            this.pathGenerators.add((PathGenerator)new WeightedRandomPath(this.stopCondition));
        } else if ("quick_random".equals(generatorName) || "quickrandom".equals(generatorName) || "quickrandompath".equals(generatorName)) {
            this.pathGenerators.add((PathGenerator)new QuickRandomPath(this.stopCondition));
        } else if ("a_star".equals(generatorName) || "astarpath".equals(generatorName)) {
            this.pathGenerators.add((PathGenerator)new AStarPath((ReachedStopCondition)this.stopCondition));
        } else if ("shortest_all_paths".equals(generatorName) || "shortestallpaths".equals(generatorName)) {
            this.pathGenerators.add((PathGenerator)new ShortestAllPaths(this.stopCondition));
        }
        this.stopConditions.clear();
    }

    public PathGenerator getGenerator() {
        if (this.pathGenerators.isEmpty()) {
            return null;
        }
        if (this.pathGenerators.size() == 1) {
            return this.pathGenerators.get(0);
        }
        CombinedPath combinedPath = new CombinedPath();
        this.pathGenerators.forEach(arg_0 -> ((CombinedPath)combinedPath).addPathGenerator(arg_0));
        return combinedPath;
    }
}

