/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.gelfclient.encoder;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class GelfMessageChunkEncoder
extends MessageToMessageEncoder<ByteBuf> {
    private static final Logger LOG = LoggerFactory.getLogger(GelfMessageChunkEncoder.class);
    private static final int MAX_CHUNKS = 128;
    private static final int MAX_CHUNK_SIZE = 1420;
    private static final int MAX_MESSAGE_SIZE = 181760;
    private static final byte[] CHUNK_MAGIC_BYTES = new byte[]{30, 15};
    private final byte[] machineIdentifier = new byte[4];

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        LOG.error("Chunking error", cause);
    }

    public GelfMessageChunkEncoder(byte[] machineIdentifier) {
        if (machineIdentifier.length < 4) {
            throw new IllegalArgumentException("The machine identifier must at least be 4 bytes long.");
        }
        System.arraycopy(machineIdentifier, 0, this.machineIdentifier, 0, 4);
    }

    public GelfMessageChunkEncoder() {
        this(GelfMessageChunkEncoder.randomIdentifier(4));
    }

    private static byte[] randomIdentifier(int length) {
        byte[] randomIdentifier = new byte[length];
        Random random = new Random();
        random.nextBytes(randomIdentifier);
        return randomIdentifier;
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        if (buf.readableBytes() > 181760) {
            throw new EncoderException("Message too big. " + buf.readableBytes() + " bytes (max " + 181760 + ")");
        }
        if (buf.readableBytes() <= 1420) {
            out.add(buf.retain());
        } else {
            Chunker chunker = new Chunker(buf.readableBytes());
            try {
                while (buf.readableBytes() > 0) {
                    if (buf.readableBytes() >= 1420) {
                        out.add(chunker.nextChunk(buf.readSlice(1420)));
                        continue;
                    }
                    out.add(chunker.nextChunk(buf.readSlice(buf.readableBytes())));
                }
            }
            catch (Exception e) {
                LOG.error("Chunk encoder error", (Throwable)e);
                buf.release();
            }
        }
    }

    private class Chunker {
        private final byte[] sequenceCount;
        private int sequenceNumber = 0;
        private final byte[] messageId = this.generateMessageId();

        public Chunker(int messageSize) {
            int sequenceCount = messageSize / 1420;
            if (messageSize % 1420 != 0) {
                ++sequenceCount;
            }
            this.sequenceCount = new byte[]{(byte)sequenceCount};
        }

        public ByteBuf nextChunk(ByteBuf chunk) {
            byte[] sequenceNumber = new byte[]{(byte)this.sequenceNumber++};
            byte[] data = new byte[chunk.readableBytes()];
            chunk.readBytes(data);
            LOG.debug("nextChunk bytes magicBytes={} messageId={} sequenceNumber={} sequenceCount={} data={}", new Object[]{CHUNK_MAGIC_BYTES.length, this.messageId.length, sequenceNumber.length, this.sequenceCount.length, data.length});
            return Unpooled.copiedBuffer((byte[][])new byte[][]{CHUNK_MAGIC_BYTES, this.messageId, sequenceNumber, this.sequenceCount, data});
        }

        private byte[] generateMessageId() {
            ByteBuf messageId = Unpooled.buffer((int)8, (int)8);
            messageId.writeInt((int)System.currentTimeMillis());
            messageId.writeBytes(GelfMessageChunkEncoder.this.machineIdentifier, 0, 4);
            return messageId.array();
        }
    }
}

