/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.dr;

import java.io.Serializable;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.cache.dr.CacheDrEntryFilter;
import org.gridgain.grid.dr.DrSenderLoadBalancingMode;
import org.jetbrains.annotations.Nullable;

public class CacheDrSenderConfiguration
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final long DFLT_BATCH_SND_FREQUENCY = 2000L;
    public static final int DFLT_BATCH_SND_SIZE = 2048;
    public static final int DFLT_MAX_BATCHES = 32;
    public static final DrSenderLoadBalancingMode DFLT_SND_HUB_LOAD_BALANCING_MODE = DrSenderLoadBalancingMode.DR_RANDOM;
    public static final int DFLT_STATE_TRANSFER_THREADS_CNT = 2;
    public static final long DFLT_STATE_TRANSFER_THROTTLE = 50L;
    private static final int DFLT_STATE_TRANSFER_THROTTLE_BYTES = 0xA00000;
    private static final boolean DFLT_PREFER_LOC_SND = true;
    private int batchSndSize = 2048;
    private long batchSndFreq = 2000L;
    private int maxBatches = 32;
    private int maxBackupQueueSize;
    private CacheDrEntryFilter entryFilter;
    private DrSenderLoadBalancingMode loadBalancingMode = DFLT_SND_HUB_LOAD_BALANCING_MODE;
    private long stateTransferThrottle = 50L;
    private int stateTransferThrottleBytes = 0xA00000;
    private int stateTransferThreadsCnt = 2;
    private boolean preferLocSnd = true;
    private String senderGroup;

    public CacheDrSenderConfiguration() {
    }

    public CacheDrSenderConfiguration(CacheDrSenderConfiguration cfg) {
        assert (cfg != null);
        this.batchSndFreq = cfg.getBatchSendFrequency();
        this.batchSndSize = cfg.getBatchSendSize();
        this.entryFilter = cfg.getEntryFilter();
        this.maxBatches = cfg.getMaxBatches();
        this.loadBalancingMode = cfg.getLoadBalancingMode();
        this.preferLocSnd = cfg.isPreferLocalSender();
        this.stateTransferThreadsCnt = cfg.getStateTransferThreadsCount();
        this.stateTransferThrottle = cfg.getStateTransferThrottle();
        this.stateTransferThrottleBytes = cfg.getStateTransferThrottleBytes();
        this.senderGroup = cfg.getSenderGroup();
        this.maxBackupQueueSize = cfg.getMaxBackupQueueSize();
    }

    @Deprecated
    public int getBatchSendSize() {
        return this.batchSndSize;
    }

    @Deprecated
    public CacheDrSenderConfiguration setBatchSendSize(int batchSndSize) {
        this.batchSndSize = batchSndSize;
        return this;
    }

    public long getBatchSendFrequency() {
        return this.batchSndFreq;
    }

    public CacheDrSenderConfiguration setBatchSendFrequency(long batchSndFreq) {
        this.batchSndFreq = batchSndFreq;
        return this;
    }

    public int getMaxBatches() {
        return this.maxBatches;
    }

    public CacheDrSenderConfiguration setMaxBatches(int maxBatches) {
        this.maxBatches = maxBatches;
        return this;
    }

    public int getMaxBackupQueueSize() {
        return this.maxBackupQueueSize;
    }

    public CacheDrSenderConfiguration setMaxBackupQueueSize(int maxBackupSize) {
        this.maxBackupQueueSize = maxBackupSize;
        return this;
    }

    public CacheDrEntryFilter getEntryFilter() {
        return this.entryFilter;
    }

    public CacheDrSenderConfiguration setEntryFilter(@Nullable CacheDrEntryFilter entryFilter) {
        this.entryFilter = entryFilter;
        return this;
    }

    public DrSenderLoadBalancingMode getLoadBalancingMode() {
        return this.loadBalancingMode;
    }

    public CacheDrSenderConfiguration setLoadBalancingMode(DrSenderLoadBalancingMode loadBalancingMode) {
        this.loadBalancingMode = loadBalancingMode;
        return this;
    }

    @Deprecated
    public long getStateTransferThrottle() {
        return this.stateTransferThrottle;
    }

    @Deprecated
    public CacheDrSenderConfiguration setStateTransferThrottle(long stateTransferThrottle) {
        this.stateTransferThrottle = stateTransferThrottle;
        return this;
    }

    public int getStateTransferThrottleBytes() {
        return this.stateTransferThrottleBytes;
    }

    public CacheDrSenderConfiguration setStateTransferThrottleBytes(int stateTransferThrottleBytes) {
        this.stateTransferThrottleBytes = stateTransferThrottleBytes;
        return this;
    }

    @Deprecated
    public int getStateTransferThreadsCount() {
        return this.stateTransferThreadsCnt;
    }

    @Deprecated
    public CacheDrSenderConfiguration setStateTransferThreadsCount(int stateTransferThreadsCnt) {
        this.stateTransferThreadsCnt = stateTransferThreadsCnt;
        return this;
    }

    public boolean isPreferLocalSender() {
        return this.preferLocSnd;
    }

    public CacheDrSenderConfiguration setPreferLocalSender(boolean preferLocSnd) {
        this.preferLocSnd = preferLocSnd;
        return this;
    }

    public String getSenderGroup() {
        return this.senderGroup;
    }

    public CacheDrSenderConfiguration setSenderGroup(String senderGroup) {
        this.senderGroup = senderGroup;
        return this;
    }

    public String toString() {
        return S.toString(CacheDrSenderConfiguration.class, (Object)this);
    }
}

