/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.configuration;

import javax.cache.configuration.Factory;
import javax.net.ssl.SSLContext;
import org.apache.ignite.internal.util.typedef.internal.S;

public class DrReceiverConfiguration {
    public static final int DFLT_LOCAL_PORT = 49000;
    public static final int DFLT_SELECTOR_CNT = Math.min(4, Runtime.getRuntime().availableProcessors());
    public static final int DFLT_WORKER_THREAD_CNT = Runtime.getRuntime().availableProcessors() * 4;
    public static final int DFLT_MSG_QUEUE_LIMIT = 0;
    public static final boolean DFLT_TCP_NODELAY = true;
    public static final boolean DFLT_DIRECT_BUF = true;
    public static final long DFLT_IDLE_TIMEOUT = 60000L;
    public static final long DFLT_WRITE_TIMEOUT = 60000L;
    public static final long DFLT_FLUSH_FREQ = 2000L;
    public static final int DFLT_PER_NODE_BUF_SIZE = 1024;
    public static final int DFLT_PARALLEL_LOAD_OPS = 16;
    public static final boolean DFLT_USE_IGNITE_SSL_CTX_FACTORY = true;
    private String locInboundHost;
    private int locInboundPort = 49000;
    private int selectorCnt = DFLT_SELECTOR_CNT;
    private int workerCnt = DFLT_WORKER_THREAD_CNT;
    private int msgQueueLimit = 0;
    private boolean tcpNodelay = true;
    private boolean directBuf = true;
    private long idleTimeout = 60000L;
    private long writeTimeout = 60000L;
    private long flushFreq = 2000L;
    private int perNodeBufSize = 1024;
    private int perNodeParallelLoadOps = 16;
    private Factory<SSLContext> sslCtxFactory;
    private boolean useIgniteSslCtxFactory = true;
    private int sockSndBufSize;
    private int sockRcvBufSize;

    public DrReceiverConfiguration() {
    }

    public DrReceiverConfiguration(DrReceiverConfiguration cfg) {
        this.directBuf = cfg.isDirectBuffer();
        this.flushFreq = cfg.getFlushFrequency();
        this.idleTimeout = cfg.getIdleTimeout();
        this.locInboundHost = cfg.getLocalInboundHost();
        this.locInboundPort = cfg.getLocalInboundPort();
        this.msgQueueLimit = cfg.getMessageQueueLimit();
        this.perNodeBufSize = cfg.getPerNodeBufferSize();
        this.perNodeParallelLoadOps = cfg.getPerNodeParallelLoadOperations();
        this.selectorCnt = cfg.getSelectorCount();
        this.sockRcvBufSize = cfg.getSocketReceiveBufferSize();
        this.sockSndBufSize = cfg.getSocketSendBufferSize();
        this.sslCtxFactory = cfg.getSslContextFactory();
        this.tcpNodelay = cfg.isTcpNodelay();
        this.useIgniteSslCtxFactory = cfg.isUseIgniteSslContextFactory();
        this.workerCnt = cfg.getWorkerThreads();
        this.writeTimeout = cfg.getWriteTimeout();
    }

    public String getLocalInboundHost() {
        return this.locInboundHost;
    }

    public DrReceiverConfiguration setLocalInboundHost(String locInboundHost) {
        this.locInboundHost = locInboundHost;
        return this;
    }

    public int getLocalInboundPort() {
        return this.locInboundPort;
    }

    public DrReceiverConfiguration setLocalInboundPort(int locInboundPort) {
        this.locInboundPort = locInboundPort;
        return this;
    }

    public int getSelectorCount() {
        return this.selectorCnt;
    }

    public DrReceiverConfiguration setSelectorCount(int selectorCnt) {
        this.selectorCnt = selectorCnt;
        return this;
    }

    public int getWorkerThreads() {
        return this.workerCnt;
    }

    public DrReceiverConfiguration setWorkerThreads(int workerCnt) {
        this.workerCnt = workerCnt;
        return this;
    }

    public int getMessageQueueLimit() {
        return this.msgQueueLimit;
    }

    public DrReceiverConfiguration setMessageQueueLimit(int msgQueueLimit) {
        this.msgQueueLimit = msgQueueLimit;
        return this;
    }

    public boolean isTcpNodelay() {
        return this.tcpNodelay;
    }

    public DrReceiverConfiguration setTcpNodelay(boolean tcpNodelay) {
        this.tcpNodelay = tcpNodelay;
        return this;
    }

    public boolean isDirectBuffer() {
        return this.directBuf;
    }

    public DrReceiverConfiguration setDirectBuffer(boolean directBuf) {
        this.directBuf = directBuf;
        return this;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public DrReceiverConfiguration setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public DrReceiverConfiguration setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public long getFlushFrequency() {
        return this.flushFreq;
    }

    public DrReceiverConfiguration setFlushFrequency(long flushFreq) {
        this.flushFreq = flushFreq;
        return this;
    }

    public int getPerNodeBufferSize() {
        return this.perNodeBufSize;
    }

    public DrReceiverConfiguration setPerNodeBufferSize(int perNodeBufSize) {
        this.perNodeBufSize = perNodeBufSize;
        return this;
    }

    public int getPerNodeParallelLoadOperations() {
        return this.perNodeParallelLoadOps;
    }

    public DrReceiverConfiguration setPerNodeParallelLoadOperations(int perNodeParallelLoadOps) {
        this.perNodeParallelLoadOps = perNodeParallelLoadOps;
        return this;
    }

    public Factory<SSLContext> getSslContextFactory() {
        return this.sslCtxFactory;
    }

    public DrReceiverConfiguration setSslContextFactory(Factory<SSLContext> sslCtxFactory) {
        this.sslCtxFactory = sslCtxFactory;
        return this;
    }

    public boolean isUseIgniteSslContextFactory() {
        return this.useIgniteSslCtxFactory;
    }

    public DrReceiverConfiguration setUseIgniteSslContextFactory(boolean useIgniteSslCtxFactory) {
        this.useIgniteSslCtxFactory = useIgniteSslCtxFactory;
        return this;
    }

    public int getSocketSendBufferSize() {
        return this.sockSndBufSize;
    }

    public DrReceiverConfiguration setSocketSendBufferSize(int sockSndBufSize) {
        this.sockSndBufSize = sockSndBufSize;
        return this;
    }

    public int getSocketReceiveBufferSize() {
        return this.sockRcvBufSize;
    }

    public DrReceiverConfiguration setSocketReceiveBufferSize(int sockRcvBufSize) {
        this.sockRcvBufSize = sockRcvBufSize;
        return this;
    }

    public String toString() {
        return S.toString(DrReceiverConfiguration.class, (Object)this);
    }
}

