/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.configuration;

import java.util.Arrays;
import javax.cache.configuration.Factory;
import javax.net.ssl.SSLContext;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.dr.store.DrSenderStore;

public class DrSenderConfiguration {
    public static final int DFLT_MAX_FAILED_CONNECT_ATTEMPTS = 5;
    public static final int DFLT_MAX_ERRORS = 10;
    public static final long DFLT_HEALTH_CHECK_FREQ = 2000L;
    public static final long DFLT_SYS_REQ_TIMEOUT = 5000L;
    public static final long DFLT_READ_TIMEOUT = 5000L;
    public static final int DFLT_MAX_QUEUE_SIZE = 100;
    public static final long DFLT_RECONNECT_ON_FAILURE_TIMEOUT = 5000L;
    public static final boolean DFLT_USE_IGNITE_SSL_CTX_FACTORY = true;
    public static final long DFLT_FST_BUFFER_SIZE = 0xC800000L;
    private DrSenderConnectionConfiguration[] connCfg;
    private int maxFailedConnectAttempts = 5;
    private int maxErrors = 10;
    private long healthCheckFreq = 2000L;
    private long sysReqTimeout = 5000L;
    private long readTimeout = 5000L;
    private int maxQueueSize = 100;
    private long reconnOnFailureTimeout = 5000L;
    @Deprecated
    private String[] cacheNames;
    private String[] senderGroups;
    private DrSenderStore store;
    private long fullStateTransferBufferSize = 0xC800000L;
    private Factory<SSLContext> sslCtxFactory;
    private boolean useIgniteSslCtxFactory = true;
    private int sockSndBufSize;
    private int sockRcvBufSize;

    public DrSenderConfiguration() {
    }

    public DrSenderConfiguration(DrSenderConfiguration cfg) {
        this.cacheNames = cfg.getCacheNames();
        this.senderGroups = cfg.getSenderGroups();
        this.healthCheckFreq = cfg.getHealthCheckFrequency();
        this.maxErrors = cfg.getMaxErrors();
        this.maxFailedConnectAttempts = cfg.getMaxFailedConnectAttempts();
        this.maxQueueSize = cfg.getMaxQueueSize();
        this.store = cfg.getStore();
        this.readTimeout = cfg.getReadTimeout();
        this.reconnOnFailureTimeout = cfg.getReconnectOnFailureTimeout();
        this.connCfg = cfg.getConnectionConfiguration();
        this.sockRcvBufSize = cfg.getSocketReceiveBufferSize();
        this.sockSndBufSize = cfg.getSocketSendBufferSize();
        this.sslCtxFactory = cfg.getSslContextFactory();
        this.sysReqTimeout = cfg.getSystemRequestTimeout();
        this.useIgniteSslCtxFactory = cfg.isUseIgniteSslContextFactory();
    }

    public DrSenderConnectionConfiguration[] getConnectionConfiguration() {
        return this.connCfg;
    }

    public DrSenderConfiguration setConnectionConfiguration(DrSenderConnectionConfiguration ... connCfg) {
        this.connCfg = connCfg;
        return this;
    }

    public int getMaxFailedConnectAttempts() {
        return this.maxFailedConnectAttempts;
    }

    public DrSenderConfiguration setMaxFailedConnectAttempts(int maxFailedConnectAttempts) {
        this.maxFailedConnectAttempts = maxFailedConnectAttempts;
        return this;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public DrSenderConfiguration setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
        return this;
    }

    public long getHealthCheckFrequency() {
        return this.healthCheckFreq;
    }

    public DrSenderConfiguration setHealthCheckFrequency(long healthCheckFreq) {
        this.healthCheckFreq = healthCheckFreq;
        return this;
    }

    public long getSystemRequestTimeout() {
        return this.sysReqTimeout;
    }

    public DrSenderConfiguration setSystemRequestTimeout(long sysReqTimeout) {
        this.sysReqTimeout = sysReqTimeout;
        return this;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public DrSenderConfiguration setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public DrSenderConfiguration setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    public long getReconnectOnFailureTimeout() {
        return this.reconnOnFailureTimeout;
    }

    public DrSenderConfiguration setReconnectOnFailureTimeout(long reconnectOnFailureTimeout) {
        this.reconnOnFailureTimeout = reconnectOnFailureTimeout;
        return this;
    }

    @Deprecated
    public String[] getCacheNames() {
        return this.cacheNames;
    }

    @Deprecated
    public DrSenderConfiguration setCacheNames(String ... cacheNames) {
        this.cacheNames = cacheNames != null ? cacheNames : new String[]{};
        for (int i = 0; i < this.cacheNames.length; ++i) {
            this.cacheNames[i] = CU.mask((String)this.cacheNames[i]);
        }
        Arrays.sort(this.cacheNames);
        return this;
    }

    public String[] getSenderGroups() {
        return this.senderGroups;
    }

    public DrSenderConfiguration setSenderGroups(String ... senderGroups) {
        this.senderGroups = senderGroups;
        return this;
    }

    public DrSenderStore getStore() {
        return this.store;
    }

    public DrSenderConfiguration setStore(DrSenderStore store) {
        this.store = store;
        return this;
    }

    public Factory<SSLContext> getSslContextFactory() {
        return this.sslCtxFactory;
    }

    public DrSenderConfiguration setSslContextFactory(Factory<SSLContext> sslCtxFactory) {
        this.sslCtxFactory = sslCtxFactory;
        return this;
    }

    public boolean isUseIgniteSslContextFactory() {
        return this.useIgniteSslCtxFactory;
    }

    public DrSenderConfiguration setUseIgniteSslContextFactory(boolean useIgniteSslCtxFactory) {
        this.useIgniteSslCtxFactory = useIgniteSslCtxFactory;
        return this;
    }

    public int getSocketSendBufferSize() {
        return this.sockSndBufSize;
    }

    public DrSenderConfiguration setSocketSendBufferSize(int sockSndBufSize) {
        this.sockSndBufSize = sockSndBufSize;
        return this;
    }

    public int getSocketReceiveBufferSize() {
        return this.sockRcvBufSize;
    }

    public DrSenderConfiguration setSocketReceiveBufferSize(int sockRcvBufSize) {
        this.sockRcvBufSize = sockRcvBufSize;
        return this;
    }

    public long getFullStateTransferBufferSize() {
        return this.fullStateTransferBufferSize;
    }

    public DrSenderConfiguration setFullStateTransferBufferSize(long fstBufferSize) {
        this.fullStateTransferBufferSize = fstBufferSize;
        return this;
    }

    public String toString() {
        return S.toString(DrSenderConfiguration.class, (Object)this);
    }
}

