/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.dr.store;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.dr.store.DrSenderStore;
import org.gridgain.grid.dr.store.DrSenderStoreCursor;
import org.gridgain.grid.dr.store.DrSenderStoreCursorClosedException;
import org.gridgain.grid.dr.store.DrSenderStoreEntry;
import org.gridgain.grid.dr.store.DrSenderStoreOverflowException;
import org.gridgain.grid.dr.store.DrSenderStoreOverflowMode;
import org.jetbrains.annotations.Nullable;

public abstract class DrAbstractSenderStore
implements DrSenderStore {
    private final Set<CursorWrapper> cursors = Collections.newSetFromMap(new IdentityHashMap());
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private IgniteRunnable overflowCb;
    protected DrSenderStoreOverflowMode overflowMode = DrSenderStoreOverflowMode.STOP;
    private final AtomicBoolean overflow = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(byte[] dataCenterIds, byte[] data, int cnt, @Nullable IgniteUuid fstId) throws IgniteCheckedException {
        this.rwLock.readLock().lock();
        try {
            this.store0(dataCenterIds, data, cnt, fstId);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrSenderStoreCursor cursor(byte dataCenterId) throws IgniteCheckedException {
        this.rwLock.writeLock().lock();
        try {
            DrSenderStoreCursor target = this.cursor0(dataCenterId);
            assert (target != null);
            CursorWrapper res = new CursorWrapper(target);
            this.cursors.add(res);
            CursorWrapper cursorWrapper = res;
            return cursorWrapper;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IgniteCheckedException {
        this.rwLock.writeLock().lock();
        try {
            this.clear0();
            Iterator<CursorWrapper> iter = this.cursors.iterator();
            while (iter.hasNext()) {
                CursorWrapper cursor = iter.next();
                try {
                    cursor.internalClose(false);
                    iter.remove();
                }
                catch (Exception e) {
                    throw new IgniteCheckedException("Failed to close store cursor.", (Throwable)e);
                }
            }
            this.overflow.set(false);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isOverflow() {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.overflow.get();
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public DrSenderStoreOverflowMode getOverflowMode() {
        return this.overflowMode;
    }

    public DrAbstractSenderStore setOverflowMode(DrSenderStoreOverflowMode overflowMode) {
        this.overflowMode = overflowMode;
        return this;
    }

    public void setOverflowCallback(IgniteRunnable overflowCb) {
        this.overflowCb = overflowCb;
    }

    protected void onOverflow() throws DrSenderStoreOverflowException {
        assert (this.rwLock.getReadLockCount() > 0 || this.rwLock.isWriteLockedByCurrentThread()) : "Lock is not held.";
        if (this.getOverflowMode() == DrSenderStoreOverflowMode.STOP) {
            throw new DrSenderStoreOverflowException();
        }
        if (this.overflow.compareAndSet(false, true) && this.overflowCb != null) {
            this.overflowCb.run();
        }
    }

    protected abstract void store0(byte[] var1, byte[] var2, int var3, @Nullable IgniteUuid var4) throws IgniteCheckedException;

    protected abstract DrSenderStoreCursor cursor0(byte var1) throws IgniteCheckedException;

    protected abstract void clear0() throws IgniteCheckedException;

    private class EntryWrapper
    implements DrSenderStoreEntry {
        private final CursorWrapper cursor;
        private final DrSenderStoreEntry target;

        EntryWrapper(CursorWrapper cursor, DrSenderStoreEntry target) {
            assert (cursor != null);
            assert (target != null);
            this.cursor = cursor;
            this.target = target;
        }

        @Override
        public byte[] data() {
            return this.target.data();
        }

        @Override
        public void acknowledge(byte dcId) {
            DrAbstractSenderStore.this.rwLock.readLock().lock();
            try {
                if (this.cursor.closed) {
                    return;
                }
                this.target.acknowledge(dcId);
            }
            finally {
                DrAbstractSenderStore.this.rwLock.readLock().unlock();
            }
        }

        @Override
        public IgniteUuid stateTransferId() {
            return this.target.stateTransferId();
        }
    }

    private class CursorWrapper
    implements DrSenderStoreCursor {
        private final DrSenderStoreCursor target;
        private boolean closed;

        private CursorWrapper(DrSenderStoreCursor target) {
            this.target = target;
        }

        @Override
        @Nullable
        public DrSenderStoreEntry next() throws IgniteCheckedException {
            DrAbstractSenderStore.this.rwLock.readLock().lock();
            try {
                if (this.closed) {
                    throw new DrSenderStoreCursorClosedException("Cursor is closed.");
                }
                DrSenderStoreEntry entry = this.target.next();
                EntryWrapper entryWrapper = entry != null ? new EntryWrapper(this, entry) : null;
                return entryWrapper;
            }
            finally {
                DrAbstractSenderStore.this.rwLock.readLock().unlock();
            }
        }

        @Override
        public void close() throws Exception {
            DrAbstractSenderStore.this.rwLock.writeLock().lock();
            try {
                this.internalClose(true);
            }
            finally {
                DrAbstractSenderStore.this.rwLock.writeLock().unlock();
            }
        }

        private void internalClose(boolean rmv) throws Exception {
            if (!this.closed) {
                this.target.close();
                if (rmv) {
                    DrAbstractSenderStore.this.cursors.remove(this);
                }
                this.closed = true;
            }
        }
    }
}

