/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal;

import java.util.BitSet;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.gridgain.grid.ru.GridGainRollingUpgradeStatus;

public final class GridGainFeatures
extends Enum<GridGainFeatures> {
    public static final /* enum */ GridGainFeatures SNAPSHOT_RECOVERY_FORCE_FLAG = new GridGainFeatures(0);
    public static final /* enum */ GridGainFeatures SNAPSHOT_CANCEL_PROTOCOL_V2 = new GridGainFeatures(1);
    public static final /* enum */ GridGainFeatures SNAPSHOT_V2_METADATA_COLLECTION = new GridGainFeatures(2);
    public static final /* enum */ GridGainFeatures SNAPSHOT_OPERATION_STAGE_CHANGE_PROTOCOL_V2 = new GridGainFeatures(3);
    public static final /* enum */ GridGainFeatures SNAPSHOT_CANCEL_PROTOCOL_V3 = new GridGainFeatures(4);
    public static final /* enum */ GridGainFeatures SNAPSHOT_STORED_CACHE_DATA = new GridGainFeatures(5);
    public static final /* enum */ GridGainFeatures SNAPSHOT_COPY_OPERATION_SUPPORT = new GridGainFeatures(6);
    public static final /* enum */ GridGainFeatures SNAPSHOT_ZIP_COMPRESSION = new GridGainFeatures(7);
    public static final /* enum */ GridGainFeatures RESTART_ID_SUPPORT = new GridGainFeatures(8);
    public static final /* enum */ GridGainFeatures COMMON_PARAMETERS_SUPPORTED = new GridGainFeatures(10);
    public static final /* enum */ GridGainFeatures SNAPSHOT_RESTORE_OWN_CONSISTENT_ID_STRATEGY = new GridGainFeatures(11);
    public static final /* enum */ GridGainFeatures SNAPSHOT_COUNTERS_IN_METASTORAGE = new GridGainFeatures(12);
    public static final /* enum */ GridGainFeatures TRANSACTIONAL_REPLICATION = new GridGainFeatures(13);
    public static final /* enum */ GridGainFeatures SYNCHRONOUS_STATE_TRANSFER = new GridGainFeatures(14);
    private int featureId;
    private static final /* synthetic */ GridGainFeatures[] $VALUES;

    public static GridGainFeatures[] values() {
        return (GridGainFeatures[])$VALUES.clone();
    }

    public static GridGainFeatures valueOf(String name) {
        return Enum.valueOf(GridGainFeatures.class, name);
    }

    private GridGainFeatures(int featureId) {
        this.featureId = featureId;
    }

    public static boolean nodeSupports(GridKernalContext ctx, ClusterNode clusterNode, GridGainFeatures feature) {
        GridGainRollingUpgradeStatus status;
        if (ctx != null && (status = (GridGainRollingUpgradeStatus)ctx.rollingUpgrade().getStatus()).enabled() && !status.forcedModeEnabled()) {
            return status.supportedGridGainFeatures().contains((Object)feature);
        }
        return GridGainFeatures.nodeSupports(clusterNode, feature);
    }

    public static boolean allNodesSupports(GridKernalContext ctx, Iterable<ClusterNode> nodes, GridGainFeatures feature) {
        GridGainRollingUpgradeStatus status;
        if (ctx != null && nodes.iterator().hasNext() && (status = (GridGainRollingUpgradeStatus)ctx.rollingUpgrade().getStatus()).enabled() && !status.forcedModeEnabled()) {
            return status.supportedGridGainFeatures().contains((Object)feature);
        }
        for (ClusterNode next : nodes) {
            if (GridGainFeatures.nodeSupports(next, feature)) continue;
            return false;
        }
        return true;
    }

    private static boolean nodeSupports(ClusterNode clusterNode, GridGainFeatures feature) {
        byte[] features = (byte[])clusterNode.attribute("plugins.gg.supported.features");
        return features != null && BitSet.valueOf(features).get(feature.getFeatureId());
    }

    public static byte[] allFeatures() {
        BitSet set = new BitSet();
        for (GridGainFeatures value : GridGainFeatures.values()) {
            int featureId = value.getFeatureId();
            assert (!set.get(featureId)) : "Duplicate feature ID found for [" + (Object)((Object)value) + "] having same ID [" + featureId + "]";
            set.set(featureId);
        }
        return set.toByteArray();
    }

    public int getFeatureId() {
        return this.featureId;
    }

    static {
        $VALUES = new GridGainFeatures[]{SNAPSHOT_RECOVERY_FORCE_FLAG, SNAPSHOT_CANCEL_PROTOCOL_V2, SNAPSHOT_V2_METADATA_COLLECTION, SNAPSHOT_OPERATION_STAGE_CHANGE_PROTOCOL_V2, SNAPSHOT_CANCEL_PROTOCOL_V3, SNAPSHOT_STORED_CACHE_DATA, SNAPSHOT_COPY_OPERATION_SUPPORT, SNAPSHOT_ZIP_COMPRESSION, RESTART_ID_SUPPORT, COMMON_PARAMETERS_SUPPORTED, SNAPSHOT_RESTORE_OWN_CONSISTENT_ID_STRATEGY, SNAPSHOT_COUNTERS_IN_METASTORAGE, TRANSACTIONAL_REPLICATION, SYNCHRONOUS_STATE_TRANSFER};
    }
}

