/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal;

import java.io.Serializable;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.PluginContext;
import org.apache.ignite.plugin.PluginValidationException;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.GridPluginProcessor;
import org.jetbrains.annotations.Nullable;

public abstract class GridPluginProcessorAdapter
implements GridPluginProcessor {
    @GridToStringExclude
    protected final PluginContext ctx;
    protected final GridGainConfiguration cfg;
    @GridToStringExclude
    protected final GridKernalContext igniteCtx;
    @GridToStringExclude
    protected final IgniteLogger log;

    protected GridPluginProcessorAdapter(PluginContext ctx, GridGainConfiguration cfg) {
        assert (ctx != null);
        assert (cfg != null);
        this.ctx = ctx;
        this.cfg = cfg;
        this.igniteCtx = ((IgniteKernal)ctx.grid()).context();
        this.log = ctx.log(this.getClass());
    }

    @Override
    public void start() throws IgniteCheckedException {
    }

    @Override
    public void onIgniteStart() throws IgniteCheckedException {
    }

    @Override
    public void onIgniteStop(boolean cancel) {
    }

    @Override
    @Nullable
    public Serializable provideDiscoveryData(UUID nodeId) {
        return null;
    }

    @Override
    public void receiveDiscoveryData(UUID nodeId, Serializable data) {
    }

    @Override
    public void stop(boolean cancel) {
    }

    @Override
    public void validateNewNode(ClusterNode node) throws PluginValidationException {
    }

    @Override
    public void printMemoryStats() {
    }

    protected final void assertParameter(boolean cond, String condDesc) {
        if (!cond) {
            throw new IgniteException("Grid configuration parameter invalid: " + condDesc);
        }
    }

    public GridGainConfiguration ggConfig() {
        return this.cfg;
    }

    public IgniteConfiguration config() {
        return this.ctx.grid().configuration();
    }

    public PluginContext context() {
        return this.ctx;
    }

    public UUID localNodeId() {
        return this.ctx.localNode().id();
    }

    public String igniteInstanceName() {
        return this.ctx.grid().name();
    }

    public String toString() {
        return S.toString(GridPluginProcessorAdapter.class, (Object)this);
    }
}

