/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.cache;

import java.util.UUID;
import javax.cache.Cache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.CacheConflictResolutionManager;
import org.apache.ignite.internal.processors.cache.CacheInvokeEntry;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrManager;
import org.apache.ignite.internal.processors.cache.dr.GridOsCacheDrManager;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionedEntryEx;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.plugin.CachePluginContext;
import org.apache.ignite.plugin.CachePluginProvider;
import org.gridgain.grid.cache.conflict.CacheConflictEntry;
import org.gridgain.grid.cache.conflict.CacheConflictMode;
import org.gridgain.grid.cache.dr.CacheDrSenderConfiguration;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.GridPluginProvider;
import org.gridgain.grid.internal.GridPluginUtils;
import org.gridgain.grid.internal.processors.cache.conflict.CacheConflictEntryImpl;
import org.gridgain.grid.internal.processors.cache.conflict.CacheEntConflictResolutionManager;
import org.gridgain.grid.internal.processors.cache.dr.GridGainCacheDrManager;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.jetbrains.annotations.Nullable;

public class GridCachePluginProvider
implements CachePluginProvider<GridGainCacheConfiguration> {
    private final GridPluginProvider provider;
    private final CachePluginContext<GridGainCacheConfiguration> ctx;
    private final IgniteLogger log;
    private GridGainCacheConfiguration ggCcfg;

    public GridCachePluginProvider(GridPluginProvider provider, CachePluginContext ctx) {
        this.provider = provider;
        this.ctx = ctx;
        this.log = ctx.log(this.getClass());
        this.ggCcfg = (GridGainCacheConfiguration)GridCacheUtils.cachePluginConfiguration((CacheConfiguration)ctx.igniteCacheConfiguration(), GridGainCacheConfiguration.class);
    }

    public void start() throws IgniteCheckedException {
    }

    public void stop(boolean cancel) {
    }

    public void onIgniteStart() {
    }

    public void onIgniteStop(boolean cancel) {
    }

    @Nullable
    public <T> T createComponent(Class<T> cls) {
        GridGainConfiguration cfg = GridPluginUtils.gridPluginConfiguration(this.ctx.igniteConfiguration());
        if (cls.equals(GridCacheDrManager.class)) {
            return (T)((Object)(DrUtils.isDrEnabled(cfg) && !CU.isSystemCache((String)this.ctx.igniteCacheConfiguration().getName()) ? new GridGainCacheDrManager(this.ctx, this.provider.dr()) : new GridOsCacheDrManager()));
        }
        if (cls.equals(CacheConflictResolutionManager.class)) {
            return (T)((Object)new CacheEntConflictResolutionManager(this.ctx));
        }
        return null;
    }

    @Nullable
    public <T, K, V> T unwrapCacheEntry(Cache.Entry<K, V> entry, Class<T> cls) {
        if (cls.isAssignableFrom(CacheConflictEntry.class) && entry instanceof CacheInvokeEntry) {
            CacheInvokeEntry invokeEntry = (CacheInvokeEntry)entry;
            try {
                GridCacheVersionedEntryEx verEntry = invokeEntry.entry().versionedEntry(invokeEntry.keepBinary());
                CacheObjectContext coctx = invokeEntry.entry().context().cacheObjectContext();
                return (T)new CacheConflictEntryImpl((CacheObjectValueContext)coctx, verEntry);
            }
            catch (IgniteCheckedException | GridCacheEntryRemovedException e) {
                throw new IgniteException("Failed to unwrap entry: " + entry, e);
            }
        }
        return null;
    }

    public void validate() {
        CacheConfiguration ccfg = this.ctx.igniteCacheConfiguration();
        if (this.ggCcfg != null) {
            CacheConflictMode rslvrMode = this.ggCcfg.getConflictResolverMode();
            if (rslvrMode == CacheConflictMode.ALWAYS && this.ggCcfg.getConflictResolver() == null) {
                throw new IgniteException("Conflict resolver must be not null with " + (Object)((Object)rslvrMode) + " resolving policy");
            }
            if (DrUtils.isDrEnabled(this.provider.configuration())) {
                CacheDrSenderConfiguration drSndCfg = this.ggCcfg.getDrSenderConfiguration();
                if (drSndCfg != null) {
                    if (ccfg.getCacheMode() == CacheMode.LOCAL) {
                        throw new IgniteException("Data center replication is not supported for LOCAL cache");
                    }
                    this.assertParameter(drSndCfg.getBatchSendSize() >= 0, "cfg.getDrSenderConfiguration().getBatchSendSize() >= 0");
                    this.assertParameter(this.provider.configuration().getBatchSendSizeBytes() >= 0, "ggCfg.getBatchSendSizeBytes() >= 0");
                    this.assertParameter(drSndCfg.getBatchSendSize() > 0 || this.provider.configuration().getBatchSendSizeBytes() > 0, "ggCfg.getBatchSendSizeBytes() > 0 or cfg.getDrSenderConfiguration().getBatchSendSize() > 0");
                    if (drSndCfg.getBatchSendFrequency() < 0L) {
                        drSndCfg.setBatchSendFrequency(0L);
                    }
                    this.assertParameter(drSndCfg.getLoadBalancingMode() != null, "cfg.getDrSenderConfiguration().getLoadBalancingMode() != null");
                    this.assertParameter(drSndCfg.getStateTransferThreadsCount() > 0, "cfg.getDrSenderConfiguration().getStateTransferThreadsCount() > 0");
                    this.assertParameter(drSndCfg.getStateTransferThrottle() >= 0L, "cfg.getDrSenderConfiguration().getStateTransferThrottle >= 0");
                    this.assertParameter(drSndCfg.getStateTransferThrottleBytes() >= 0, "cfg.getDrSenderConfiguration().getStateTransferThrottleBytes >= 0");
                }
                if (ccfg.getCacheMode() != CacheMode.LOCAL) {
                    this.assertParameter(rslvrMode != null, "cfg.getConflictResolverMode() != null");
                }
            }
        }
    }

    private void assertParameter(boolean cond, String condDesc) {
        if (!cond) {
            throw new IgniteException("GridGain cache plugin configuration parameter invalid: " + condDesc);
        }
    }

    public void validateRemote(CacheConfiguration locCfg, CacheConfiguration rmtCfg, ClusterNode rmt) throws IgniteCheckedException {
        GridGainCacheConfiguration rmtPluginCcfg = (GridGainCacheConfiguration)GridCacheUtils.cachePluginConfiguration((CacheConfiguration)rmtCfg, GridGainCacheConfiguration.class);
        if (rmtPluginCcfg != null && this.ggCcfg != null) {
            CacheDrSenderConfiguration locSndCfg = this.ggCcfg.getDrSenderConfiguration();
            CacheDrSenderConfiguration rmtSndCfg = rmtPluginCcfg.getDrSenderConfiguration();
            if (locSndCfg != null && rmtSndCfg != null) {
                CU.checkAttributeMismatch((IgniteLogger)this.log, (String)rmtCfg.getName(), (UUID)rmt.id(), (String)"entryFilterClassName", (String)"Class name for replication cache entry filter", (Object)GridCachePluginProvider.className(locSndCfg.getEntryFilter()), (Object)GridCachePluginProvider.className(rmtSndCfg.getEntryFilter()), (boolean)true);
            } else if (locSndCfg != null || rmtSndCfg != null) {
                UUID nullAttrNode = locSndCfg == null ? this.ctx.localNode().id() : rmt.id();
                throw new IgniteCheckedException("Replication sender cache should be enabled for all nodes or disabled for all of them (configuration is not set for nodeId=" + nullAttrNode + ").");
            }
            if (this.ggCcfg.isDrReceiverEnabled() != rmtPluginCcfg.isDrReceiverEnabled()) {
                UUID nullAttrNode = !this.ggCcfg.isDrReceiverEnabled() ? this.ctx.localNode().id() : rmt.id();
                throw new IgniteCheckedException("DR receiver cache should be enabled for all nodes or disabled for all of them (configuration is not set for nodeId=" + nullAttrNode + ").");
            }
            CU.checkAttributeMismatch((IgniteLogger)this.log, (String)rmtCfg.getName(), (UUID)rmt.id(), (String)"conflictResolverPolicy", (String)"Policy for conflict resolver", (Object)((Object)this.ggCcfg.getConflictResolverMode()), (Object)((Object)rmtPluginCcfg.getConflictResolverMode()), (boolean)true);
            CU.checkAttributeMismatch((IgniteLogger)this.log, (String)rmtCfg.getName(), (UUID)rmt.id(), (String)"conflictResolverClassName", (String)"Class name for conflict resolver", (Object)GridCachePluginProvider.className(this.ggCcfg.getConflictResolver()), (Object)GridCachePluginProvider.className(rmtPluginCcfg.getConflictResolver()), (boolean)true);
        }
    }

    @Nullable
    private static String className(@Nullable Object obj) {
        return obj != null ? obj.getClass().getName() : null;
    }
}

