/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.communication;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.direct.state.DirectMessageState;
import org.apache.ignite.internal.direct.state.DirectMessageStateItem;
import org.apache.ignite.internal.direct.stream.DirectByteBufferStream;
import org.apache.ignite.internal.direct.stream.v1.DirectByteBufferStreamImplV1;
import org.apache.ignite.internal.direct.stream.v2.DirectByteBufferStreamImplV2;
import org.apache.ignite.internal.direct.stream.v3.DirectByteBufferStreamImplV3;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageFactory;
import org.apache.ignite.plugin.extensions.communication.MessageReader;

class RollingUpgradeMessageReader
implements MessageReader {
    @GridToStringInclude
    private final DirectMessageState<StateItem> state;
    @GridToStringInclude
    private final byte protoVer;
    private boolean lastRead;

    public RollingUpgradeMessageReader(final MessageFactory msgFactory, final byte protoVer) {
        this.state = new DirectMessageState(StateItem.class, (IgniteOutClosure)new IgniteOutClosure<StateItem>(){

            public StateItem apply() {
                return new StateItem(msgFactory, protoVer);
            }
        });
        this.protoVer = protoVer;
    }

    public void setBuffer(ByteBuffer buf) {
        ((StateItem)this.state.item()).stream.setBuffer(buf);
    }

    public void setCurrentReadClass(Class<? extends Message> msgCls) {
        ((StateItem)this.state.item()).readMsgCls = msgCls;
    }

    public boolean beforeMessageRead() {
        StateItem item = (StateItem)this.state.item();
        if (item.fieldCnt == -1) {
            item.fieldCnt = item.stream.readByte();
            boolean finished = item.stream.lastFinished();
            if (!finished) {
                item.fieldCnt = (byte)-1;
            }
            return finished;
        }
        return true;
    }

    public boolean afterMessageRead(Class<? extends Message> msgCls) {
        return msgCls != ((StateItem)this.state.item()).readMsgCls || this.readRemovedFields();
    }

    public byte readByte(String name) {
        StateItem item = (StateItem)this.state.item();
        if (!this.readFieldHeader(name, (byte)1)) {
            return 0;
        }
        byte val = item.stream.readByte();
        this.onValueRead();
        return val;
    }

    public short readShort(String name) {
        if (!this.readFieldHeader(name, (byte)2)) {
            return 0;
        }
        short val = ((StateItem)this.state.item()).stream.readShort();
        this.onValueRead();
        return val;
    }

    public int readInt(String name) {
        return this.readInt(name, 0);
    }

    public int readInt(String name, int dflt) {
        if (!this.readFieldHeader(name, (byte)3)) {
            return dflt;
        }
        int val = ((StateItem)this.state.item()).stream.readInt();
        this.onValueRead();
        return val;
    }

    public long readLong(String name) {
        if (!this.readFieldHeader(name, (byte)4)) {
            return 0L;
        }
        long val = ((StateItem)this.state.item()).stream.readLong();
        this.onValueRead();
        return val;
    }

    public float readFloat(String name) {
        if (!this.readFieldHeader(name, (byte)5)) {
            return 0.0f;
        }
        float val = ((StateItem)this.state.item()).stream.readFloat();
        this.onValueRead();
        return val;
    }

    public double readDouble(String name) {
        if (!this.readFieldHeader(name, (byte)6)) {
            return 0.0;
        }
        double val = ((StateItem)this.state.item()).stream.readDouble();
        this.onValueRead();
        return val;
    }

    public char readChar(String name) {
        if (!this.readFieldHeader(name, (byte)7)) {
            return '\u0000';
        }
        char val = ((StateItem)this.state.item()).stream.readChar();
        this.onValueRead();
        return val;
    }

    public boolean readBoolean(String name) {
        if (!this.readFieldHeader(name, (byte)8)) {
            return false;
        }
        boolean val = ((StateItem)this.state.item()).stream.readBoolean();
        this.onValueRead();
        return val;
    }

    public byte[] readByteArray(String name) {
        if (!this.readFieldHeader(name, (byte)9)) {
            return null;
        }
        byte[] val = ((StateItem)this.state.item()).stream.readByteArray();
        this.onValueRead();
        return val;
    }

    public short[] readShortArray(String name) {
        if (!this.readFieldHeader(name, (byte)10)) {
            return null;
        }
        short[] val = ((StateItem)this.state.item()).stream.readShortArray();
        this.onValueRead();
        return val;
    }

    public int[] readIntArray(String name) {
        if (!this.readFieldHeader(name, (byte)11)) {
            return null;
        }
        int[] val = ((StateItem)this.state.item()).stream.readIntArray();
        this.onValueRead();
        return val;
    }

    public long[] readLongArray(String name) {
        if (!this.readFieldHeader(name, (byte)12)) {
            return null;
        }
        long[] val = ((StateItem)this.state.item()).stream.readLongArray();
        this.onValueRead();
        return val;
    }

    public float[] readFloatArray(String name) {
        if (!this.readFieldHeader(name, (byte)13)) {
            return null;
        }
        float[] val = ((StateItem)this.state.item()).stream.readFloatArray();
        this.onValueRead();
        return val;
    }

    public double[] readDoubleArray(String name) {
        if (!this.readFieldHeader(name, (byte)14)) {
            return null;
        }
        double[] val = ((StateItem)this.state.item()).stream.readDoubleArray();
        this.onValueRead();
        return val;
    }

    public char[] readCharArray(String name) {
        if (!this.readFieldHeader(name, (byte)15)) {
            return null;
        }
        char[] val = ((StateItem)this.state.item()).stream.readCharArray();
        this.onValueRead();
        return val;
    }

    public boolean[] readBooleanArray(String name) {
        if (!this.readFieldHeader(name, (byte)16)) {
            return null;
        }
        boolean[] val = ((StateItem)this.state.item()).stream.readBooleanArray();
        this.onValueRead();
        return val;
    }

    public String readString(String name) {
        if (!this.readFieldHeader(name, (byte)17)) {
            return null;
        }
        String val = ((StateItem)this.state.item()).stream.readString();
        this.onValueRead();
        return val;
    }

    public BitSet readBitSet(String name) {
        if (!this.readFieldHeader(name, (byte)18)) {
            return null;
        }
        BitSet val = ((StateItem)this.state.item()).stream.readBitSet();
        this.onValueRead();
        return val;
    }

    public UUID readUuid(String name) {
        if (!this.readFieldHeader(name, (byte)19)) {
            return null;
        }
        UUID val = ((StateItem)this.state.item()).stream.readUuid();
        this.onValueRead();
        return val;
    }

    public IgniteUuid readIgniteUuid(String name) {
        if (!this.readFieldHeader(name, (byte)20)) {
            return null;
        }
        IgniteUuid val = ((StateItem)this.state.item()).stream.readIgniteUuid();
        this.onValueRead();
        return val;
    }

    public AffinityTopologyVersion readAffinityTopologyVersion(String name) {
        if (this.protoVer >= 3) {
            if (!this.readFieldHeader(name, (byte)25)) {
                return null;
            }
            AffinityTopologyVersion val = ((StateItem)this.state.item()).stream.readAffinityTopologyVersion();
            this.onValueRead();
            return val;
        }
        return (AffinityTopologyVersion)this.readMessage(name);
    }

    public <T extends Message> T readMessage(String name) {
        if (!this.readFieldHeader(name, (byte)21)) {
            return null;
        }
        Message msg = ((StateItem)this.state.item()).stream.readMessage((MessageReader)this);
        this.onValueRead();
        return (T)msg;
    }

    public <T> T[] readObjectArray(String name, MessageCollectionItemType itemType, Class<T> itemCls) {
        if (!this.readFieldHeader(name, (byte)22)) {
            return null;
        }
        StateItem item = (StateItem)this.state.item();
        if (itemType != item.curItemType) {
            throw new IgniteException("Unexpected array component type [name=" + name + ", expType=" + itemType + ", type=" + item.curItemType + ']');
        }
        Object[] arr = item.stream.readObjectArray(itemType, itemCls, (MessageReader)this);
        this.onValueRead();
        return arr;
    }

    public <C extends Collection<?>> C readCollection(String name, MessageCollectionItemType itemType) {
        if (!this.readFieldHeader(name, (byte)23)) {
            return null;
        }
        StateItem item = (StateItem)this.state.item();
        if (itemType != item.curItemType) {
            throw new IgniteException("Unexpected collection item type [name=" + name + ", expType=" + itemType + ", type=" + item.curItemType + ']');
        }
        Collection col = item.stream.readCollection(itemType, (MessageReader)this);
        this.onValueRead();
        return (C)col;
    }

    public <M extends Map<?, ?>> M readMap(String name, MessageCollectionItemType keyType, MessageCollectionItemType valType, boolean linked) {
        if (!this.readFieldHeader(name, (byte)24)) {
            return null;
        }
        StateItem item = (StateItem)this.state.item();
        if (keyType != item.curKeyType) {
            throw new IgniteException("Unexpected map key type [name=" + name + ", expType=" + keyType + ", type=" + item.curKeyType + ']');
        }
        if (valType != item.curValType) {
            throw new IgniteException("Unexpected map key type [name=" + name + ", expType=" + valType + ", type=" + item.curValType + ']');
        }
        Map map = item.stream.readMap(keyType, valType, linked, (MessageReader)this);
        this.onValueRead();
        return (M)map;
    }

    public boolean isLastRead() {
        return this.lastRead;
    }

    public int state() {
        return ((StateItem)this.state.item()).state;
    }

    public void incrementState() {
        ((StateItem)this.state.item()).state++;
    }

    public void beforeInnerMessageRead() {
        this.state.forward();
    }

    public void afterInnerMessageRead(boolean finished) {
        this.state.backward(finished);
    }

    public void reset() {
        this.state.reset();
    }

    private void onValueRead() {
        StateItem item = (StateItem)this.state.item();
        this.lastRead = item.stream.lastFinished();
        if (this.lastRead) {
            StateItem.access$708(item);
            item.curName = null;
            item.typeRead = false;
            item.itemTypeRead = false;
            item.keyTypeRead = false;
            item.valTypeRead = false;
        }
    }

    private boolean readFieldHeader(String expName, byte expType) {
        int cmp;
        StateItem item;
        block17: {
            item = (StateItem)this.state.item();
            if (item.readFieldCnt == item.fieldCnt) {
                this.lastRead = true;
                return false;
            }
            do {
                if (item.curName == null) {
                    item.curName = item.stream.readString();
                    if (!item.stream.lastFinished()) {
                        assert (item.curName == null);
                        this.lastRead = false;
                        return false;
                    }
                }
                assert (item.curName != null);
                cmp = expName.compareTo(item.curName);
                if (cmp < 0) {
                    this.lastRead = true;
                    return false;
                }
                if (!item.typeRead) {
                    item.curType = item.stream.readByte();
                    if (!item.stream.lastFinished()) {
                        this.lastRead = false;
                        return false;
                    }
                    item.typeRead = true;
                }
                if (!(item.curType != 22 && item.curType != 23 || item.itemTypeRead)) {
                    item.curItemType = MessageCollectionItemType.fromOrdinal((int)item.stream.readByte());
                    if (!item.stream.lastFinished()) {
                        this.lastRead = false;
                        return false;
                    }
                    item.itemTypeRead = true;
                }
                if (item.curType == 24) {
                    if (!item.keyTypeRead) {
                        item.curKeyType = MessageCollectionItemType.fromOrdinal((int)item.stream.readByte());
                        if (!item.stream.lastFinished()) {
                            this.lastRead = false;
                            return false;
                        }
                        item.keyTypeRead = true;
                    }
                    if (!item.valTypeRead) {
                        item.curValType = MessageCollectionItemType.fromOrdinal((int)item.stream.readByte());
                        if (!item.stream.lastFinished()) {
                            this.lastRead = false;
                            return false;
                        }
                        item.valTypeRead = true;
                    }
                }
                if (cmp <= 0) break block17;
                this.readRemovedField();
                this.onValueRead();
            } while (this.lastRead);
            return false;
        }
        if (cmp == 0 && expType != item.curType) {
            throw new IgniteException("Unexpected field type [name=" + item.curName + ", expType=" + expType + ", type=" + item.curType + ']');
        }
        return true;
    }

    private boolean readRemovedFields() {
        StateItem item = (StateItem)this.state.item();
        while (item.readFieldCnt < item.fieldCnt) {
            if (item.curName == null) {
                item.curName = item.stream.readString();
                if (!item.stream.lastFinished()) {
                    assert (item.curName == null);
                    this.lastRead = false;
                    return false;
                }
            }
            assert (item.curName != null);
            if (!item.typeRead) {
                item.curType = item.stream.readByte();
                if (!item.stream.lastFinished()) {
                    this.lastRead = false;
                    return false;
                }
                item.typeRead = true;
            }
            if (!(item.curType != 22 && item.curType != 23 || item.itemTypeRead)) {
                item.curItemType = MessageCollectionItemType.fromOrdinal((int)item.stream.readByte());
                if (!item.stream.lastFinished()) {
                    this.lastRead = false;
                    return false;
                }
                item.itemTypeRead = true;
            }
            if (item.curType == 24) {
                if (!item.keyTypeRead) {
                    item.curKeyType = MessageCollectionItemType.fromOrdinal((int)item.stream.readByte());
                    if (!item.stream.lastFinished()) {
                        this.lastRead = false;
                        return false;
                    }
                    item.keyTypeRead = true;
                }
                if (!item.valTypeRead) {
                    item.curValType = MessageCollectionItemType.fromOrdinal((int)item.stream.readByte());
                    if (!item.stream.lastFinished()) {
                        this.lastRead = false;
                        return false;
                    }
                    item.valTypeRead = true;
                }
            }
            this.readRemovedField();
            this.onValueRead();
            if (this.lastRead) continue;
            return false;
        }
        return true;
    }

    private void readRemovedField() {
        StateItem item = (StateItem)this.state.item();
        switch (item.curType) {
            case 1: {
                item.stream.readByte();
                break;
            }
            case 2: {
                item.stream.readShort();
                break;
            }
            case 3: {
                item.stream.readInt();
                break;
            }
            case 4: {
                item.stream.readLong();
                break;
            }
            case 5: {
                item.stream.readFloat();
                break;
            }
            case 6: {
                item.stream.readDouble();
                break;
            }
            case 7: {
                item.stream.readChar();
                break;
            }
            case 8: {
                item.stream.readBoolean();
                break;
            }
            case 9: {
                item.stream.readByteArray();
                break;
            }
            case 10: {
                item.stream.readShortArray();
                break;
            }
            case 11: {
                item.stream.readIntArray();
                break;
            }
            case 12: {
                item.stream.readLongArray();
                break;
            }
            case 13: {
                item.stream.readFloatArray();
                break;
            }
            case 14: {
                item.stream.readDoubleArray();
                break;
            }
            case 15: {
                item.stream.readCharArray();
                break;
            }
            case 16: {
                item.stream.readBooleanArray();
                break;
            }
            case 17: {
                item.stream.readString();
                break;
            }
            case 18: {
                item.stream.readBitSet();
                break;
            }
            case 19: {
                item.stream.readUuid();
                break;
            }
            case 20: {
                item.stream.readIgniteUuid();
                break;
            }
            case 21: {
                item.stream.readMessage((MessageReader)this);
                break;
            }
            case 22: {
                item.stream.readObjectArray(item.curItemType, null, (MessageReader)this);
                break;
            }
            case 23: {
                item.stream.readCollection(item.curItemType, (MessageReader)this);
                break;
            }
            case 24: {
                item.stream.readMap(item.curKeyType, item.curValType, false, (MessageReader)this);
                break;
            }
            default: {
                throw new IgniteException("Invalid field type: " + item.curType);
            }
        }
    }

    public String toString() {
        return S.toString(RollingUpgradeMessageReader.class, (Object)this);
    }

    static class StateItem
    implements DirectMessageStateItem {
        private final DirectByteBufferStream stream;
        private int state;
        private byte fieldCnt = (byte)-1;
        private byte readFieldCnt;
        private String curName;
        private boolean typeRead;
        private boolean itemTypeRead;
        private boolean keyTypeRead;
        private boolean valTypeRead;
        private byte curType;
        private MessageCollectionItemType curItemType;
        private MessageCollectionItemType curKeyType;
        private MessageCollectionItemType curValType;
        private Class<? extends Message> readMsgCls;

        public StateItem(MessageFactory msgFactory, byte protoVer) {
            switch (protoVer) {
                case 1: {
                    this.stream = new DirectByteBufferStreamImplV1(msgFactory);
                    break;
                }
                case 2: {
                    this.stream = new DirectByteBufferStreamImplV2(msgFactory);
                    break;
                }
                case 3: {
                    this.stream = new DirectByteBufferStreamImplV3(msgFactory);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid protocol version: " + protoVer);
                }
            }
        }

        public void reset() {
            this.state = 0;
            this.fieldCnt = (byte)-1;
            this.readFieldCnt = 0;
            this.curName = null;
            this.typeRead = false;
            this.itemTypeRead = false;
            this.keyTypeRead = false;
            this.valTypeRead = false;
            this.curType = 0;
            this.curItemType = null;
            this.curKeyType = null;
            this.curValType = null;
            this.readMsgCls = null;
        }

        public String toString() {
            return S.toString(StateItem.class, (Object)this);
        }

        static /* synthetic */ byte access$708(StateItem x0) {
            byte by = x0.readFieldCnt;
            x0.readFieldCnt = (byte)(by + 1);
            return by;
        }
    }
}

