/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.interop.dotnet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.platform.PlatformPluginConfigurationClosure;
import org.apache.ignite.plugin.platform.PlatformPluginConfigurationClosureFactory;
import org.apache.ignite.plugin.security.SecurityBasicPermissionSet;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityCredentialsBasicProvider;
import org.apache.ignite.plugin.security.SecurityCredentialsProvider;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.gridgain.grid.configuration.DrReceiverConfiguration;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.configuration.SnapshotsCatalogConnectorConfiguration;
import org.gridgain.grid.dr.DrReceiverLoadBalancingMode;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.security.Authenticator;
import org.gridgain.grid.security.passcode.AuthenticationAclProvider;
import org.gridgain.grid.security.passcode.PasscodeAuthenticator;
import org.jetbrains.annotations.NotNull;

public class InteropDotNetPluginConfigurationClosureFactory
implements PlatformPluginConfigurationClosureFactory,
PlatformPluginConfigurationClosure {
    private static final long serialVersionUID = 0L;

    public int id() {
        return 1;
    }

    public PlatformPluginConfigurationClosure create() {
        return this;
    }

    public void apply(@NotNull IgniteConfiguration cfg, @NotNull BinaryRawReader reader) {
        ArrayList<GridGainConfiguration> cfgs = new ArrayList<GridGainConfiguration>();
        GridGainConfiguration plugCfg = new GridGainConfiguration();
        if (cfg.getPluginConfigurations() != null) {
            Collections.addAll(cfgs, cfg.getPluginConfigurations());
            for (PluginConfiguration pluginConfiguration : cfgs) {
                if (!(pluginConfiguration instanceof GridGainConfiguration)) continue;
                plugCfg = (GridGainConfiguration)pluginConfiguration;
                break;
            }
        }
        plugCfg.setLicenseUrl(reader.readString());
        plugCfg.setRollingUpdatesEnabled(reader.readBoolean());
        plugCfg.setDataCenterId(reader.readByte());
        if (reader.readBoolean()) {
            plugCfg.setDrSenderConfiguration(this.readDrSenderConfiguration(reader));
        }
        if (reader.readBoolean()) {
            plugCfg.setDrReceiverConfiguration(this.readDrReceiverConfiguration(reader));
        }
        if (reader.readBoolean()) {
            plugCfg.setAuthenticator(this.readAuthenticator(reader));
        }
        if (reader.readBoolean()) {
            plugCfg.setSecurityCredentialsProvider(this.readCredentialsProvider(reader));
        }
        if (reader.readBoolean()) {
            plugCfg.setSnapshotConfiguration(this.readSnapshotConfiguration(reader));
        }
        plugCfg.setDrUseCacheNames(reader.readBoolean());
        int poolSize = reader.readInt();
        if (poolSize > 0) {
            plugCfg.setDrStateTransferThreadPoolSize(poolSize);
        }
        cfgs.add(plugCfg);
        cfg.setPluginConfigurations(cfgs.toArray(new PluginConfiguration[cfgs.size()]));
    }

    private DrSenderConfiguration readDrSenderConfiguration(BinaryRawReader r) {
        int i;
        DrSenderConfiguration res = new DrSenderConfiguration();
        res.setConnectionConfiguration(this.readConnectionConfigurations(r));
        int cnt = r.readInt();
        if (cnt > 0) {
            String[] cacheNames = new String[cnt];
            for (i = 0; i < cnt; ++i) {
                cacheNames[i] = r.readString();
            }
            res.setCacheNames(cacheNames);
        }
        res.setHealthCheckFrequency(r.readLong());
        res.setMaxErrors(r.readInt());
        res.setMaxFailedConnectAttempts(r.readInt());
        res.setMaxQueueSize(r.readInt());
        res.setReadTimeout(r.readLong());
        res.setReconnectOnFailureTimeout(r.readLong());
        res.setSocketReceiveBufferSize(r.readInt());
        res.setSocketSendBufferSize(r.readInt());
        res.setSystemRequestTimeout(r.readLong());
        cnt = r.readInt();
        if (cnt > 0) {
            String[] senderGroups = new String[cnt];
            for (i = 0; i < cnt; ++i) {
                senderGroups[i] = r.readString();
            }
            res.setSenderGroups(senderGroups);
        }
        return res;
    }

    private DrSenderConnectionConfiguration[] readConnectionConfigurations(BinaryRawReader r) {
        int cnt = r.readInt();
        if (cnt <= 0) {
            return null;
        }
        DrSenderConnectionConfiguration[] res = new DrSenderConnectionConfiguration[cnt];
        for (int i = 0; i < cnt; ++i) {
            res[i] = r.readBoolean() ? this.readConnectionConfiguration(r) : null;
        }
        return res;
    }

    private DrSenderConnectionConfiguration readConnectionConfiguration(BinaryRawReader r) {
        int i;
        DrSenderConnectionConfiguration res = new DrSenderConnectionConfiguration();
        res.setDataCenterId(r.readByte());
        int cnt = r.readInt();
        if (cnt > 0) {
            String[] rcAddr = new String[cnt];
            for (i = 0; i < cnt; ++i) {
                rcAddr[i] = r.readString();
            }
            res.setReceiverAddresses(rcAddr);
        }
        res.setLocalOutboundAddress(r.readString());
        res.setLoadBalancingMode(DrReceiverLoadBalancingMode.values()[r.readInt()]);
        cnt = r.readInt();
        if (cnt > 0) {
            byte[] dcIds = new byte[cnt];
            for (i = 0; i < cnt; ++i) {
                dcIds[i] = r.readByte();
            }
            res.setIgnoredDataCenterIds(dcIds);
        }
        res.setAwaitAcknowledge(r.readBoolean());
        return res;
    }

    private DrReceiverConfiguration readDrReceiverConfiguration(BinaryRawReader r) {
        DrReceiverConfiguration res = new DrReceiverConfiguration();
        res.setLocalInboundHost(r.readString());
        res.setLocalInboundPort(r.readInt());
        res.setTcpNodelay(r.readBoolean());
        res.setDirectBuffer(r.readBoolean());
        res.setIdleTimeout(r.readLong());
        res.setWriteTimeout(r.readLong());
        res.setFlushFrequency(r.readLong());
        res.setPerNodeBufferSize(r.readInt());
        res.setPerNodeParallelLoadOperations(r.readInt());
        res.setSelectorCount(r.readInt());
        res.setWorkerThreads(r.readInt());
        return res;
    }

    private Authenticator readAuthenticator(BinaryRawReader reader) {
        PasscodeAuthenticator auth = new PasscodeAuthenticator();
        int cnt = reader.readInt();
        final HashMap<SecurityCredentials, SecurityPermissionSet> perms = new HashMap<SecurityCredentials, SecurityPermissionSet>(cnt);
        for (int i = 0; i < cnt; ++i) {
            SecurityCredentials cred = this.readCredentials(reader);
            SecurityPermissionSet permSet = this.readPermissionSet(reader);
            perms.put(cred, permSet);
        }
        auth.setAclProvider(new AuthenticationAclProvider(){

            @Override
            public Map<SecurityCredentials, SecurityPermissionSet> acl() {
                return perms;
            }
        });
        return auth;
    }

    private SecurityPermissionSet readPermissionSet(BinaryRawReader reader) {
        SecurityBasicPermissionSet res = new SecurityBasicPermissionSet();
        res.setDefaultAllowAll(reader.readBoolean());
        res.setTaskPermissions(this.readPermissionsMap(reader));
        res.setCachePermissions(this.readPermissionsMap(reader));
        res.setSystemPermissions(this.readPermissions(reader));
        return res;
    }

    private Collection<SecurityPermission> readPermissions(BinaryRawReader reader) {
        int cnt = reader.readInt();
        ArrayList<SecurityPermission> res = new ArrayList<SecurityPermission>(cnt);
        for (int i = 0; i < cnt; ++i) {
            res.add(SecurityPermission.fromOrdinal((int)reader.readInt()));
        }
        return res;
    }

    private Map<String, Collection<SecurityPermission>> readPermissionsMap(BinaryRawReader reader) {
        int cnt = reader.readInt();
        HashMap<String, Collection<SecurityPermission>> res = new HashMap<String, Collection<SecurityPermission>>();
        for (int i = 0; i < cnt; ++i) {
            res.put(reader.readString(), this.readPermissions(reader));
        }
        return res;
    }

    private SecurityCredentials readCredentials(BinaryRawReader reader) {
        SecurityCredentials creds = new SecurityCredentials();
        creds.setLogin(reader.readObject());
        creds.setPassword(reader.readObject());
        creds.setUserObject(reader.readObject());
        return creds;
    }

    private SecurityCredentialsProvider readCredentialsProvider(BinaryRawReader reader) {
        return new SecurityCredentialsBasicProvider(this.readCredentials(reader));
    }

    private SnapshotConfiguration readSnapshotConfiguration(BinaryRawReader reader) {
        SnapshotConfiguration dbCfg = new SnapshotConfiguration().setSnapshotsPath(reader.readString());
        if (reader.readBoolean()) {
            dbCfg.setSnapshotsCatalogConnectorConfiguration(this.readSnapshotsCatalogConnectorConfiguration(reader));
        }
        return dbCfg;
    }

    private SnapshotsCatalogConnectorConfiguration readSnapshotsCatalogConnectorConfiguration(BinaryRawReader reader) {
        return new SnapshotsCatalogConnectorConfiguration().setServerUri(reader.readString()).setPort(reader.readInt()).setFlushFrequency(reader.readLong()).setRetries(reader.readInt()).setBatchSize(reader.readInt());
    }
}

