/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.interop.dr;

import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformAsyncResult;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.utils.PlatformFutureUtils;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.cache.dr.CacheDrReceiverMetrics;
import org.gridgain.grid.cache.dr.CacheDrSenderMetrics;
import org.gridgain.grid.cache.dr.CacheDrStateTransfer;
import org.gridgain.grid.cache.dr.CacheDrStatus;
import org.gridgain.grid.dr.DrReceiverInMetrics;
import org.gridgain.grid.dr.DrReceiverOutMetrics;
import org.gridgain.grid.dr.DrSenderInMetrics;
import org.gridgain.grid.dr.DrSenderOutMetrics;

public class InteropDr
extends PlatformAbstractTarget {
    private static final byte STATUS_NON_PAUSED = 0;
    private static final byte STATUS_USER_REQUEST = 1;
    private static final byte STATUS_BATCH_FAILED = 2;
    private static final byte STATUS_NO_SND_HUBS = 3;
    private static final int OP_START_TRANSFER = 1;
    private static final int OP_GET_TRANSFERS = 2;
    private static final int OP_SENDER_CACHE_METRICS = 3;
    private static final int OP_RECEIVER_CACHE_METRICS = 4;
    private static final int OP_SENDER_IN_METRICS = 5;
    private static final int OP_SENDER_AGGREGATED_IN_METRICS = 6;
    private static final int OP_SENDER_OUT_METRICS = 7;
    private static final int OP_SENDER_AGGREGATED_OUT_METRICS = 8;
    private static final int OP_SENDER_AGGREGATED_OUT_METRICS_CACHE = 9;
    private static final int OP_SENDER_AGGREGATED_OUT_METRICS_DC = 10;
    private static final int OP_RECEIVER_IN_METRICS = 11;
    private static final int OP_RECEIVER_AGGREGATED_IN_METRICS = 12;
    private static final int OP_RECEIVER_AGGREGATED_IN_METRICS_CACHE = 13;
    private static final int OP_RECEIVER_AGGREGATED_IN_METRICS_DC = 14;
    private static final int OP_RECEIVER_OUT_METRICS = 15;
    private static final int OP_RECEIVER_AGGREGATED_OUT_METRICS = 16;
    private static final int OP_STOP = 17;
    private static final int OP_START = 18;
    private static final int OP_SENDER_CACHE_STATUS = 19;
    private static final int OP_RESET_METRICS = 20;
    private final GridDr dr;

    public InteropDr(PlatformContext platformCtx) {
        super(platformCtx);
        GridGain gg = (GridGain)platformCtx.kernalContext().grid().plugin("GridGain");
        this.dr = gg.dr();
    }

    public PlatformAsyncResult processInStreamAsync(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        if (type == 1) {
            String cacheName = reader.readString();
            byte[] dcIds = new byte[reader.readInt()];
            for (int i = 0; i < dcIds.length; ++i) {
                dcIds[i] = reader.readByte();
            }
            final IgniteFuture<?> fut = this.dr.stateTransfer(cacheName, dcIds);
            return new PlatformAsyncResult(){

                public IgniteFuture future() {
                    return fut;
                }

                public void write(BinaryRawWriterEx writer, Object result) {
                    writer.writeObject(result);
                }
            };
        }
        return super.processInStreamAsync(type, reader);
    }

    public long processInStreamOutLong(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        switch (type) {
            case 1: {
                String cacheName = reader.readString();
                byte[] dcIds = new byte[reader.readInt()];
                for (int i = 0; i < dcIds.length; ++i) {
                    dcIds[i] = reader.readByte();
                }
                long futHnd = reader.readLong();
                IgniteFuture<?> fut = this.dr.stateTransfer(cacheName, dcIds);
                PlatformFutureUtils.listen((PlatformContext)this.platformCtx, fut, (long)futHnd, (int)9, null);
                return 1L;
            }
            case 17: {
                this.dr.stopReplication(reader.readString());
                return 1L;
            }
            case 18: {
                this.dr.startReplication(reader.readString());
                return 1L;
            }
            case 19: {
                return this.convertStatus(this.dr.senderCacheStatus(reader.readString()));
            }
        }
        return super.processInStreamOutLong(type, reader);
    }

    public void processInStreamOutStream(int type, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 2: {
                Collection<CacheDrStateTransfer> transfers = this.dr.listStateTransfers(reader.readString());
                writer.writeInt(transfers.size());
                for (CacheDrStateTransfer t : transfers) {
                    PlatformUtils.writeIgniteUuid((BinaryRawWriterEx)writer, (IgniteUuid)t.id());
                    writer.writeInt(t.dataCenterIds().size());
                    for (byte id : t.dataCenterIds()) {
                        writer.writeByte(id);
                    }
                }
                return;
            }
            case 3: {
                CacheDrSenderMetrics metrics = this.dr.senderCacheMetrics(reader.readString());
                writer.writeInt(metrics.batchesSent());
                writer.writeLong(metrics.entriesSent());
                writer.writeInt(metrics.batchesAcked());
                writer.writeLong(metrics.entriesAcked());
                writer.writeInt(metrics.batchesFailed());
                writer.writeLong(metrics.entriesFiltered());
                writer.writeLong(metrics.backupQueueSize());
                writer.writeByte(this.convertStatus(metrics.status()));
                return;
            }
            case 4: {
                CacheDrReceiverMetrics metrics = this.dr.receiverCacheMetrics(reader.readString());
                writer.writeLong(metrics.entriesReceived());
                writer.writeLong(metrics.conflictNew());
                writer.writeLong(metrics.conflictOld());
                writer.writeLong(metrics.conflictMerge());
                return;
            }
            case 5: {
                DrSenderInMetrics metrics = this.dr.senderInMetrics(reader.readString());
                this.writeMetrics(metrics, writer);
                return;
            }
            case 7: {
                DrSenderOutMetrics metrics = this.dr.senderOutMetrics(reader.readByte(), reader.readString());
                this.writeMetrics(metrics, writer);
                return;
            }
            case 9: {
                DrSenderOutMetrics metrics = this.dr.senderAggregatedOutMetrics(reader.readString());
                this.writeMetrics(metrics, writer);
                return;
            }
            case 10: {
                DrSenderOutMetrics metrics = this.dr.senderAggregatedOutMetrics(reader.readByte());
                this.writeMetrics(metrics, writer);
                return;
            }
            case 11: {
                DrReceiverInMetrics metrics = this.dr.receiverInMetrics(reader.readByte(), reader.readString());
                this.writeMetrics(metrics, writer);
                return;
            }
            case 13: {
                DrReceiverInMetrics metrics = this.dr.receiverAggregatedInMetrics(reader.readString());
                this.writeMetrics(metrics, writer);
                return;
            }
            case 14: {
                DrReceiverInMetrics metrics = this.dr.receiverAggregatedInMetrics(reader.readByte());
                this.writeMetrics(metrics, writer);
                return;
            }
            case 15: {
                DrReceiverOutMetrics metrics = this.dr.receiverOutMetrics(reader.readString());
                this.writeMetrics(metrics, writer);
                return;
            }
        }
        super.processInStreamOutStream(type, reader, writer);
    }

    public long processInLongOutLong(int type, long val) throws IgniteCheckedException {
        switch (type) {
            case 20: {
                this.dr.resetMetrics();
                return 1L;
            }
        }
        return super.processInLongOutLong(type, val);
    }

    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 6: {
                DrSenderInMetrics metrics = this.dr.senderAggregatedInMetrics();
                this.writeMetrics(metrics, writer);
                return;
            }
            case 8: {
                DrSenderOutMetrics metrics = this.dr.senderAggregatedOutMetrics();
                this.writeMetrics(metrics, writer);
                return;
            }
            case 12: {
                DrReceiverInMetrics metrics = this.dr.receiverAggregatedInMetrics();
                this.writeMetrics(metrics, writer);
                return;
            }
            case 16: {
                DrReceiverOutMetrics metrics = this.dr.receiverAggregatedOutMetrics();
                this.writeMetrics(metrics, writer);
                return;
            }
        }
        super.processOutStream(type, writer);
    }

    private void writeMetrics(DrSenderInMetrics metrics, BinaryRawWriterEx writer) {
        writer.writeInt(metrics.batchesReceived());
        writer.writeLong(metrics.entriesReceived());
        writer.writeLong(metrics.bytesReceived());
    }

    private void writeMetrics(DrReceiverInMetrics metrics, BinaryRawWriterEx writer) {
        writer.writeInt(metrics.batchesReceived());
        writer.writeLong(metrics.entriesReceived());
        writer.writeLong(metrics.bytesReceived());
    }

    private void writeMetrics(DrSenderOutMetrics metrics, BinaryRawWriterEx writer) {
        writer.writeInt(metrics.batchesSent());
        writer.writeLong(metrics.entriesSent());
        writer.writeLong(metrics.bytesSent());
        writer.writeInt(metrics.batchesAcked());
        writer.writeLong(metrics.entriesAcked());
        writer.writeLong(metrics.bytesAcked());
        writer.writeDouble(metrics.averageBatchAckTime());
    }

    private void writeMetrics(DrReceiverOutMetrics metrics, BinaryRawWriterEx writer) {
        writer.writeInt(metrics.batchesSent());
        writer.writeLong(metrics.entriesSent());
        writer.writeLong(metrics.bytesSent());
        writer.writeInt(metrics.batchesAcked());
        writer.writeLong(metrics.entriesAcked());
        writer.writeLong(metrics.bytesAcked());
        writer.writeDouble(metrics.averageBatchAckTime());
    }

    private byte convertStatus(CacheDrStatus status) {
        assert (status != null);
        if (!status.stopped()) {
            return 0;
        }
        assert (status.reason() != null);
        switch (status.reason()) {
            case USER_REQUEST: {
                return 1;
            }
            case BATCH_FAILED: {
                return 2;
            }
            case NO_SND_HUBS: {
                return 3;
            }
        }
        throw new IgniteException("Unsupported CacheDrPauseReason");
    }
}

