/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.PluginConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.SnapshotUpdateOperationParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInfoExtended;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotCommonParams;
import org.gridgain.grid.persistentstore.SnapshotCreateParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotInfoEx;
import org.gridgain.grid.persistentstore.SnapshotIssue;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridSnapshotImpl
implements GridSnapshotEx {
    private final GridCacheSharedContext ctx;
    private final GridSnapshotManager snapshotMgr;
    private final SnapshotConfiguration snapCfg;

    public GridSnapshotImpl(GridCacheSharedContext ctx, GridSnapshotManager snapshotMgr, SnapshotConfiguration snapCfg) {
        this.ctx = ctx;
        this.snapshotMgr = snapshotMgr;
        this.snapCfg = snapCfg;
    }

    @Override
    public SnapshotFuture<Void> createFullSnapshot(Set<String> cacheNames, String msg) {
        return this.snapshotMgr.startGlobalSnapshotCreation(this.cacheNames(cacheNames), null, true, null, msg, null, new SnapshotCommonParameters(this.snapCfg.getSnapshotOperationParallelism()), new SnapshotCreateParameters(this.snapCfg.getCompressionOption(), this.snapCfg.getCompressionLevel(), 0));
    }

    @Override
    public SnapshotFuture<Void> createFullSnapshot(Set<String> cacheNames, File storePath, SnapshotCreateParameters snapshotCreateParameters, @Nullable String msg) {
        return this.snapshotMgr.startGlobalSnapshotCreation(this.cacheNames(cacheNames), storePath, true, null, msg, null, snapshotCreateParameters);
    }

    @Override
    public SnapshotFuture<Void> createFullSnapshot(Set<String> cacheNames, File storePath, SnapshotCreateParams snapshotCreateParams, String msg) {
        return this.createFullSnapshot(cacheNames, storePath, this.convertSnapshotCreateParams(snapshotCreateParams), msg);
    }

    @Override
    public SnapshotFuture<Void> createFullSnapshot(@Nullable Set<String> cacheNames, File storePath, @Nullable SnapshotCommonParameters snapshotCommonParameters, @Nullable SnapshotCreateParameters snapshotCreateParameters, @Nullable String msg) {
        return this.snapshotMgr.startGlobalSnapshotCreation(this.cacheNames(cacheNames), storePath, true, null, msg, null, snapshotCommonParameters == null ? new SnapshotCommonParameters(this.snapCfg.getSnapshotOperationParallelism()) : snapshotCommonParameters, snapshotCreateParameters == null ? new SnapshotCreateParameters(this.snapCfg.getCompressionOption(), this.snapCfg.getCompressionLevel(), 0) : snapshotCreateParameters);
    }

    @Override
    public SnapshotFuture<Void> createFullSnapshot(Set<String> cacheNames, File storePath, SnapshotCommonParams snapshotCommonParams, SnapshotCreateParams snapshotCreateParams, String msg) {
        return this.createFullSnapshot(cacheNames, storePath, this.convertSnapshotCommonParams(snapshotCommonParams), this.convertSnapshotCreateParams(snapshotCreateParams), msg);
    }

    @Override
    public SnapshotFuture<Void> createSnapshot(Set<String> cacheNames, String msg) {
        return this.snapshotMgr.startGlobalSnapshotCreation(this.cacheNames(cacheNames), null, false, null, msg, null, new SnapshotCommonParameters(this.snapCfg.getSnapshotOperationParallelism()), new SnapshotCreateParameters(this.snapCfg.getCompressionOption(), this.snapCfg.getCompressionLevel(), 0));
    }

    @Override
    public SnapshotFuture<Void> createSnapshot(Set<String> cacheNames, File storePath, SnapshotCreateParameters snapshotCreateParameters, @Nullable String msg) {
        return this.snapshotMgr.startGlobalSnapshotCreation(this.cacheNames(cacheNames), storePath, false, null, msg, null, snapshotCreateParameters);
    }

    @Override
    public SnapshotFuture<Void> createSnapshot(Set<String> cacheNames, File storePath, SnapshotCreateParams snapshotCreateParams, String msg) {
        return this.createSnapshot(cacheNames, storePath, this.convertSnapshotCreateParams(snapshotCreateParams), msg);
    }

    @Override
    public SnapshotFuture<Void> createSnapshot(@Nullable Set<String> cacheNames, File storePath, @Nullable SnapshotCommonParameters snapshotCommonParameters, @Nullable SnapshotCreateParameters snapshotCreateParameters, @Nullable String msg) {
        return this.snapshotMgr.startGlobalSnapshotCreation(this.cacheNames(cacheNames), storePath, false, null, msg, null, snapshotCommonParameters == null ? new SnapshotCommonParameters(this.snapCfg.getSnapshotOperationParallelism()) : snapshotCommonParameters, snapshotCreateParameters == null ? new SnapshotCreateParameters(this.snapCfg.getCompressionOption(), this.snapCfg.getCompressionLevel(), 0) : snapshotCreateParameters);
    }

    @Override
    public SnapshotFuture<Void> createSnapshot(Set<String> cacheNames, File storePath, SnapshotCommonParams snapshotCommonParams, SnapshotCreateParams snapshotCreateParams, String msg) {
        return this.createSnapshot(cacheNames, storePath, this.convertSnapshotCommonParams(snapshotCommonParams), this.convertSnapshotCreateParams(snapshotCreateParams), msg);
    }

    @NotNull
    private Set<String> cacheNames(Set<String> cacheNames) {
        GridGainConfiguration ggCfg = null;
        for (PluginConfiguration pluginConfiguration : this.ctx.gridConfig().getPluginConfigurations()) {
            if (!(pluginConfiguration instanceof GridGainConfiguration)) continue;
            ggCfg = (GridGainConfiguration)pluginConfiguration;
            break;
        }
        if (ggCfg == null) {
            throw new IgniteException("No gridgain configuration. Snapshot is not allowed.");
        }
        if (ggCfg.getSnapshotConfiguration() == null) {
            throw new IgniteException("No snapshot configuration. Snapshot is not allowed.");
        }
        if (ggCfg.getSnapshotConfiguration().isPointInTimeRecoveryEnabled() && cacheNames != null) {
            throw new IgniteException("If point in time recovery is enabled then snapshot with explicit cache is not possible!");
        }
        Collection<DynamicCacheDescriptor> cacheDescs = this.ctx.cache().cacheDescriptors().values();
        if (!F.isEmpty(cacheNames)) {
            for (DynamicCacheDescriptor desc : cacheDescs) {
                if (!cacheNames.contains(desc.cacheName())) continue;
                if (!desc.groupDescriptor().persistenceEnabled()) {
                    throw new IgniteException("Can't create snapshot of cache '" + desc.cacheName() + "': cache resides in non-persistent data region");
                }
                if (GridCacheUtils.isReservedCacheName((String)desc.cacheName())) {
                    throw new IgniteException("Can't create snapshot of cache '" + desc.cacheName() + "': cache is for internal purpose.");
                }
                if (!(desc.cacheType().userCache() || desc.cacheType() == CacheType.DATA_STRUCTURES && CU.cacheId((String)"default-volatile-ds-group") != desc.groupId())) {
                    throw new IgniteException("Can't create snapshot of cache '" + desc.cacheName() + "': not user cache and not data structure cache, cacheType=" + desc.cacheType() + ".");
                }
                if (desc.cacheConfiguration().getAtomicityMode() != CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) continue;
                throw new IgniteException("Snapshot creation is not supported for caches with " + CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT + " atomicity mode [cacheName=\"" + desc.cacheName() + "\"]");
            }
            return cacheNames;
        }
        return GridSnapshotManager.getAllCachesForSnapshot(cacheDescs);
    }

    @Override
    public List<SnapshotInfo> listSnapshots(Collection<File> optSearchPaths) {
        this.checkPaths(optSearchPaths);
        try {
            return this.snapshotMgr.getSnapshotList(optSearchPaths);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public SnapshotInfoEx snapshot(long snapshotId, Collection<File> optSearchPaths) {
        try {
            SnapshotInfoExtended res = this.snapshotMgr.getSnapshotInfo(snapshotId, optSearchPaths);
            if (res == null) {
                throw new IgniteCheckedException("Snapshot does not exist [id=" + snapshotId + ']');
            }
            return res;
        }
        catch (IgniteException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("Failed to merge snapshot metadata [oldMeta=")) {
                return null;
            }
            throw new IgniteException((Throwable)e);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public SnapshotFuture<Void> restoreSnapshot(long snapshotId, @Nullable Collection<File> optSearchPaths, Set<String> cacheNames, String msg) {
        return this.restoreSnapshot(snapshotId, optSearchPaths, cacheNames, null, msg);
    }

    @Override
    public SnapshotFuture<Void> restoreSnapshot(long snapshotId, @Nullable Collection<File> optSearchPaths, Set<String> cacheNames, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, String msg) {
        return this.restoreSnapshot(snapshotId, optSearchPaths, cacheNames, false, c, msg);
    }

    @Override
    public SnapshotFuture<Void> restoreSnapshot(long snapshotId, @Nullable Collection<File> optSearchPaths, @Nullable Set<String> cacheNames, boolean forceRestore, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, @Nullable String msg) {
        this.checkPaths(optSearchPaths);
        try {
            return this.snapshotMgr.startGlobalSnapshotRestore(snapshotId, cacheNames, forceRestore, optSearchPaths, c, msg, null);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public SnapshotFuture<Void> restoreSnapshot(long snapshotId, Set<String> cacheNames, String msg) {
        return this.restoreSnapshot(snapshotId, null, cacheNames, msg);
    }

    @Override
    public SnapshotFuture<Void> deleteSnapshot(long snapshotId, @Nullable String msg) {
        try {
            return this.snapshotMgr.startGlobalSnapshotDeletion(snapshotId, new SnapshotUpdateOperationParameters(), msg);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public SnapshotFuture<Void> deleteSnapshot(long snapshotId, SnapshotUpdateOperationParameters operationParameters, String msg) {
        try {
            return this.snapshotMgr.startGlobalSnapshotDeletion(snapshotId, operationParameters, msg);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public SnapshotFuture<Void> deleteSnapshot(long snapshotId, SnapshotUpdateOperationParams operationParams, String msg) {
        return this.deleteSnapshot(snapshotId, this.convertSnapshotUpdateOperationParams(operationParams), msg);
    }

    @Override
    public SnapshotFuture<Void> forceDeleteSnapshot(long snapshotId, String msg) {
        try {
            return this.snapshotMgr.startGlobalSnapshotDeletion(snapshotId, new SnapshotUpdateOperationParameters(SnapshotChainMode.FROM_CURRENT_TO_LAST, false, false, null), msg);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public SnapshotFuture<List<SnapshotIssue>> checkSnapshot(long snapshotId, Collection<File> optSearchPaths, boolean skipCrc, String msg) {
        return this.checkSnapshot(snapshotId, SnapshotOperationType.RESTORE, null, false, optSearchPaths, skipCrc, null, msg);
    }

    @Override
    public SnapshotFuture<List<SnapshotIssue>> checkSnapshot(long snapshotId, @Nullable Collection<File> optSearchPaths, @Nullable Set<String> cacheNames, boolean forceRestore, boolean skipCrc, @Nullable String msg) {
        return this.checkSnapshot(snapshotId, SnapshotOperationType.RESTORE, cacheNames, forceRestore, optSearchPaths, skipCrc, null, msg);
    }

    @Override
    public SnapshotFuture<List<SnapshotIssue>> checkSnapshot(long snapshotId, SnapshotOperationType type, Collection<File> optSearchPaths, boolean skipCrc, String msg) {
        return this.checkSnapshot(snapshotId, type, null, false, optSearchPaths, skipCrc, null, msg);
    }

    @Override
    public SnapshotFuture<List<SnapshotIssue>> checkSnapshot(long snapshotId, SnapshotOperationType type, @Nullable Set<String> cacheNames, boolean forceRestore, Collection<File> optSearchPaths, boolean skipCrc, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, String msg) {
        this.checkPaths(optSearchPaths);
        try {
            return this.snapshotMgr.startGlobalSnapshotCheck(snapshotId, type, cacheNames, forceRestore, optSearchPaths, skipCrc, c, msg);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public SnapshotFuture<Void> moveSnapshot(long snapshotId, File destPath, String msg) {
        return this.moveSnapshot(snapshotId, destPath, false, (SnapshotUpdateOperationParameters)null, msg);
    }

    @Override
    public SnapshotFuture<Void> forceMoveSnapshot(long snapshotId, File destPath, String msg) {
        return this.moveSnapshot(snapshotId, destPath, false, new SnapshotUpdateOperationParameters(SnapshotChainMode.FROM_CURRENT_TO_LAST, true, false, null), msg);
    }

    @Override
    public SnapshotFuture<Void> moveSnapshot(long snapshotId, File destPath, boolean skipWalMove, String msg) {
        return this.moveSnapshot(snapshotId, destPath, skipWalMove, (SnapshotUpdateOperationParameters)null, msg);
    }

    @Override
    public SnapshotFuture<Void> moveSnapshot(long snapshotId, File destPath, boolean skipWalMove, SnapshotUpdateOperationParameters operationParameters, String msg) {
        A.notNull((Object)destPath, (String)"destPath");
        try {
            return this.snapshotMgr.startGlobalSnapshotMoving(snapshotId, destPath, skipWalMove, operationParameters, msg);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public SnapshotFuture<Void> moveSnapshot(long snapshotId, File destPath, boolean skipWalMove, SnapshotUpdateOperationParams operationParams, String msg) {
        return this.moveSnapshot(snapshotId, destPath, skipWalMove, this.convertSnapshotUpdateOperationParams(operationParams), msg);
    }

    @Override
    public SnapshotFuture<Void> copySnapshot(long snapshotId, File destPath, SnapshotUpdateOperationParameters operationParameters, String msg) {
        return this.copySnapshot(snapshotId, destPath, false, operationParameters, msg);
    }

    @Override
    public SnapshotFuture<Void> copySnapshot(long snapshotId, File destPath, SnapshotUpdateOperationParams operationParams, String msg) {
        return this.copySnapshot(snapshotId, destPath, false, operationParams, msg);
    }

    @Override
    public SnapshotFuture<Void> copySnapshot(long snapshotId, File destPath, boolean skipWalMove, SnapshotUpdateOperationParameters operationParameters, String msg) {
        A.notNull((Object)destPath, (String)"destPath");
        try {
            return this.snapshotMgr.startGlobalSnapshotCopying(snapshotId, destPath, skipWalMove, operationParameters, msg);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public SnapshotFuture<Void> copySnapshot(long snapshotId, File destPath, boolean skipWalMove, SnapshotUpdateOperationParams operationParams, String msg) {
        return this.copySnapshot(snapshotId, destPath, skipWalMove, this.convertSnapshotUpdateOperationParams(operationParams), msg);
    }

    @Override
    public SnapshotStatus ongoingSnapshotOperation() {
        try {
            return this.snapshotMgr.getOngoingOperation();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    @Nullable
    public IgniteFuture ongoingSnapshotOperationFuture() {
        return this.snapshotMgr.getOngoingOperationFuture();
    }

    private void checkPaths(Collection<File> optSearchPaths) {
        if (!F.isEmpty(optSearchPaths)) {
            for (File path : optSearchPaths) {
                A.ensure((path != null ? 1 : 0) != 0, (String)"optSearchPaths contains null value");
            }
        }
    }

    @Override
    public IgniteFuture<Boolean> cancelSnapshotOperation(IgniteUuid operationId, String msg) {
        A.notNull((Object)operationId, (String)"operationId");
        try {
            return new IgniteFutureImpl(this.snapshotMgr.cancelSnapshotOperation(operationId, false, msg));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public IgniteFuture<Boolean> forceCancelSnapshotOperation(IgniteUuid operationId, String msg) {
        A.notNull((Object)operationId, (String)"operationId");
        try {
            return new IgniteFutureImpl(this.snapshotMgr.cancelSnapshotOperation(operationId, true, msg));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    public SnapshotFuture<Void> recoveryTo(long time, @Nullable String msg) {
        return this.recoveryTo(time, null, null, null, msg);
    }

    public SnapshotFuture<Void> recoveryTo(long time, @Nullable Set<String> caches, @Nullable String msg) {
        return this.recoveryTo(time, null, caches, null, msg);
    }

    public SnapshotFuture<Void> recoveryTo(long time, @Nullable Collection<File> optSearchPaths, @Nullable Set<String> caches, @Nullable String msg) {
        return this.recoveryTo(time, optSearchPaths, caches, null, msg);
    }

    public SnapshotFuture<Void> recoveryTo(long time, @Nullable Collection<File> optSearchPaths, @Nullable Set<String> caches, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, @Nullable String msg) {
        this.checkPaths(optSearchPaths);
        if (!F.isEmpty(caches)) {
            throw new UnsupportedOperationException("Recovery to a specific point in time is not supported for cache subset, please, don't specify caches to recover.");
        }
        try {
            return this.snapshotMgr.startGlobalRecoveryToPointInTime(time, optSearchPaths, caches, c, msg);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public void updateSecurityLevel(SnapshotSecurityLevel level) throws IgniteCheckedException {
        this.snapshotMgr.updateSnapshotSecurityLevel(level);
    }

    @Override
    public SnapshotSecurityLevel getSecurityLevel() {
        return this.snapshotMgr.getSnapshotSecurityLevel();
    }

    private SnapshotCreateParameters convertSnapshotCreateParams(SnapshotCreateParams createParams) {
        return createParams == null ? null : new SnapshotCreateParameters(createParams.snapshotCompressionOption(), createParams.compressionLevel(), createParams.writeThrottlingThreshold());
    }

    private SnapshotCommonParameters convertSnapshotCommonParams(SnapshotCommonParams commonParams) {
        return commonParams == null ? null : new SnapshotCommonParameters(commonParams.snapshotOperationParallelism());
    }

    private SnapshotUpdateOperationParameters convertSnapshotUpdateOperationParams(SnapshotUpdateOperationParams updateOperationParams) {
        return updateOperationParams == null ? null : new SnapshotUpdateOperationParameters(updateOperationParams.chainMode(), updateOperationParams.removeSources(), updateOperationParams.singleFileCopy(), updateOperationParams.parallelismLevel());
    }
}

