/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cache.configuration.CompleteConfiguration;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;

public class CacheSnapshotMetadata
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final IgniteProductVersion FIRST_VERSION_WHEN_ISSUE_WITH_PART_CNTRS_WAS_FIXED = IgniteProductVersion.fromString((String)"2.4.4");
    @Deprecated
    private Collection<CacheConfiguration> cacheCfgs;
    private Collection<StoredCacheData> storedCacheDatas;
    private Map<String, byte[]> cacheCfgsBinary;
    private int grpId;
    private String cacheOrGrpName;
    @GridToStringInclude
    private Long prevSnapshotId;
    private Map<Integer, Map<String, Integer>> partCntrs;

    public CacheSnapshotMetadata(Collection<StoredCacheData> storedCacheDatas, int grpId, String cacheOrGrpName, Long prevSnapshotId, Map<Integer, Map<String, Integer>> partCntrs) {
        this.storedCacheDatas = storedCacheDatas;
        this.grpId = grpId;
        this.cacheOrGrpName = cacheOrGrpName;
        this.prevSnapshotId = prevSnapshotId;
        this.partCntrs = partCntrs;
    }

    public Collection<CacheConfiguration> cacheConfigurations() {
        return this.storedCacheDatas.stream().map(StoredCacheData::config).collect(Collectors.toList());
    }

    public Collection<StoredCacheData> storedCacheDataList() {
        return this.storedCacheDatas;
    }

    public Map<Integer, Map<String, Integer>> partitionSizesPerNode() {
        return this.partCntrs;
    }

    public Long previousSnapshotId() {
        return this.prevSnapshotId;
    }

    public Set<String> cacheNames() {
        if (this.cacheCfgsBinary != null) {
            return this.cacheCfgsBinary.keySet();
        }
        HashSet<String> cacheNames = new HashSet<String>();
        for (StoredCacheData cfg : this.storedCacheDatas) {
            cacheNames.add(cfg.config().getName());
        }
        return cacheNames;
    }

    public int groupId() {
        return this.grpId;
    }

    public String cacheOrGroupName() {
        return this.cacheOrGrpName;
    }

    public CacheSnapshotMetadata merge(CacheSnapshotMetadata other, Set<IgniteProductVersion> versions, boolean exchangelessSnapshot) throws IgniteCheckedException {
        if (!F.eq((Object)this.prevSnapshotId, (Object)other.previousSnapshotId()) && this.prevSnapshotId != null && other.prevSnapshotId != null) {
            throw new IgniteCheckedException("Failed to merge snapshot metadata (different previous snapshot ID) [prev=" + this.prevSnapshotId + ", otherPrev=" + other.previousSnapshotId() + ']');
        }
        if (this.grpId != other.grpId) {
            throw new IgniteCheckedException("Failed to merge snapshot metadata (different cache groups) [cache=" + this.cacheOrGrpName + ", otherCache=" + other.cacheOrGrpName + "]");
        }
        Map<Integer, Map<String, Integer>> oldCntrs = other.partitionSizesPerNode();
        for (Map.Entry<Integer, Map<String, Integer>> partCounters : this.partCntrs.entrySet()) {
            Integer part = partCounters.getKey();
            assert (part != null);
            Map<String, Integer> partCntr = partCounters.getValue();
            assert (partCntr != null);
            Map<String, Integer> partCntrFromOldMeta = oldCntrs.get(part);
            if (partCntrFromOldMeta == null) {
                oldCntrs.put(part, partCntr);
                continue;
            }
            int partCnt = -1;
            for (Map.Entry<String, Integer> e : partCntr.entrySet()) {
                String consId = e.getKey();
                Integer val = e.getValue();
                Integer cnt = partCntrFromOldMeta.get(consId);
                if (cnt != null) {
                    if (!Objects.equals(cnt, val)) {
                        throw new IgniteCheckedException("Failed to merge cache snapshot metadata (different partition counters for the same consistent ID) [cache=" + this.cacheOrGrpName + ", partition=" + part + ", consId=" + consId + ']');
                    }
                } else {
                    partCntrFromOldMeta.put(consId, val);
                }
                if ((partCnt == 0 && val > 0 || partCnt > 0 && val == 0) && !this.ignoreIssueWithDifferentPartCounters(versions) && !exchangelessSnapshot) {
                    throw new IgniteCheckedException("Failed to merge cache metadata (partition counter was not initialized for consistent ID) [cache=" + this.cacheOrGrpName + ", consId=" + consId + ", part=" + part + ']');
                }
                partCnt = val;
            }
        }
        return new CacheSnapshotMetadata(this.storedCacheDatas, this.grpId, this.cacheOrGrpName, this.prevSnapshotId != null ? this.prevSnapshotId : other.prevSnapshotId, oldCntrs);
    }

    private boolean ignoreIssueWithDifferentPartCounters(Set<IgniteProductVersion> versions) {
        for (IgniteProductVersion version : versions) {
            if (version.compareTo(FIRST_VERSION_WHEN_ISSUE_WITH_PART_CNTRS_WAS_FIXED) >= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasCacheConfiguration() {
        return !this.storedCacheDatas.isEmpty();
    }

    public boolean checkPartitions() {
        Iterator<StoredCacheData> iter = this.storedCacheDatas.iterator();
        if (iter.hasNext()) {
            return this.partCntrs.size() == iter.next().config().getAffinity().partitions();
        }
        throw new IgniteException("No cache configuration. You should check that it exists before checking.");
    }

    void prepareMarshal() throws IgniteCheckedException {
        if (this.storedCacheDatas == null) {
            return;
        }
        JdkMarshaller marsh = new JdkMarshaller();
        this.cacheCfgsBinary = new HashMap<String, byte[]>(this.storedCacheDatas.size());
        for (StoredCacheData cfg : this.storedCacheDatas) {
            byte[] bytes = marsh.marshal((Object)cfg);
            this.cacheCfgsBinary.put(cfg.config().getName(), bytes);
        }
        this.storedCacheDatas = null;
        this.cacheCfgs = null;
    }

    void finishUnmarshal(ClassLoader ldr, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, boolean ignoreMissedClasses) throws IgniteCheckedException {
        if (this.cacheCfgsBinary == null) {
            return;
        }
        JdkMarshaller marsh = new JdkMarshaller();
        this.storedCacheDatas = new ArrayList<StoredCacheData>(this.cacheCfgsBinary.size());
        for (String cacheName : this.cacheCfgsBinary.keySet()) {
            StoredCacheData storedCacheData;
            block8: {
                storedCacheData = null;
                try {
                    Object unmarshaledObj = marsh.unmarshal(this.cacheCfgsBinary.get(cacheName), ldr);
                    storedCacheData = unmarshaledObj instanceof CacheConfiguration ? new StoredCacheData((CacheConfiguration)unmarshaledObj) : (StoredCacheData)unmarshaledObj;
                }
                catch (IgniteCheckedException e) {
                    if ((c != null || ignoreMissedClasses) && X.hasCause((Throwable)e, (Class[])new Class[]{ClassNotFoundException.class})) break block8;
                    throw e;
                }
            }
            if (c != null) {
                if (storedCacheData == null) {
                    storedCacheData = new StoredCacheData((CacheConfiguration)c.apply((Object)cacheName, null));
                } else {
                    CacheConfiguration cfg = new CacheConfiguration((CompleteConfiguration)storedCacheData.config());
                    cfg.clearQueryEntities();
                    cfg.setQueryEntities(storedCacheData.queryEntities());
                    cfg = (CacheConfiguration)c.apply((Object)cacheName, (Object)cfg);
                    storedCacheData.config(cfg);
                    storedCacheData.queryEntities(cfg.getQueryEntities());
                }
            }
            if (storedCacheData != null) {
                this.storedCacheDatas.add(storedCacheData);
            }
            if (storedCacheData != null || ignoreMissedClasses) continue;
            throw new IgniteCheckedException("can't deserialize configuration for cache " + cacheName);
        }
    }

    public String toString() {
        return S.toString(CacheSnapshotMetadata.class, (Object)this, (String)"cache", (Object)this.cacheOrGrpName);
    }
}

